/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteButtonFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModelLock;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WmiMathMLPaletteButtonFactory
extends WmiPaletteButtonFactory {
    public WmiMathMLPaletteButtonFactory() {
        super(null);
    }

    public AbstractButton createButton(char unicodeChar, boolean isTopLevel) {
        WmiPaletteButtonFactory.PaletteButton b = isTopLevel ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        WmiMathMLPaletteButtonFactory.installFont(b, unicodeChar);
        return b;
    }

    public AbstractButton createButton(String mathML, boolean isTopLevel, int width, int height) {
        WmiPaletteButtonFactory.PaletteButton b = isTopLevel ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        if (mathML.startsWith("<mrow")) {
            try {
                try {
                    WmiModelLock.writeLock(this.renderView.getModel(), true);
                    int[] baseline = new int[1];
                    Image image = this.renderMathML(mathML, this.renderView, baseline, false);
                    b.setIcon(new ImageIcon(image));
                    b.setBaseline(baseline[0]);
                    b.setPreferredSize(new Dimension(width, height));
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    WmiModelLock.writeUnlock(this.renderView.getModel());
                }
                catch (WmiNoWriteAccessException nwae) {
                    WmiErrorLog.log(nwae);
                    WmiModelLock.writeUnlock(this.renderView.getModel());
                }
            }
            finally {
                WmiModelLock.writeUnlock(this.renderView.getModel());
            }
        }
        return b;
    }

    public AbstractButton createButton(String imageResourcePath, String imageFileName, boolean isTopLevel, int width, int height) {
        WmiPaletteButtonFactory.PaletteButton b = isTopLevel ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        ImageIcon icon = WmiComponentUtil.getImageIcon(String.valueOf(imageResourcePath) + imageFileName);
        b.setIcon(icon);
        if (width != 0 && height != 0) {
            b.setPreferredSize(new Dimension(width, height));
        }
        return b;
    }

    public AbstractButton createButton(JComponent comp, boolean isTopLevel, int width, int height) {
        WmiPaletteButtonFactory.PaletteButton b = isTopLevel ? new TopLevelPaletteButton() : new WmiPaletteButtonFactory.PaletteButton();
        Image ci = this.renderComponent(comp);
        b.setIcon(new ImageIcon(ci));
        b.setPreferredSize(new Dimension(width, height));
        return b;
    }

    public static class TopLevelPaletteButton
    extends WmiPaletteButtonFactory.PaletteButton {
        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Object textHint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object antiAliasHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(g);
            Rectangle r = this.getBounds();
            Polygon triangle = new Polygon();
            triangle.addPoint(r.width - 11, r.height - 10);
            triangle.addPoint(r.width - 5, r.height - 10);
            triangle.addPoint(r.width - 8, r.height - 5);
            g2.setColor(Color.black);
            g2.fill(triangle);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textHint);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAliasHint);
        }
    }
}

