/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiToolBar;
import com.maplesoft.mathdoc.components.WmiToolBarButton;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiDocumentType;
import com.maplesoft.mathdoc.controller.WmiMenuItem;
import com.maplesoft.mathdoc.controller.WmiNormalMenuItem;
import com.maplesoft.mathdoc.controller.WmiSwitchingMenuItem;
import com.maplesoft.mathdoc.controller.WmiTaskMonitor;
import com.maplesoft.mathdoc.controller.WmiToggleMenuItem;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiInputLock;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.platform.WmiComboBoxUIFactory;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class WmiCommand
extends AbstractAction {
    public static final int NORMAL = 0;
    public static final int TOGGLE = 1;
    public static final int MULTI_OPTION = 2;
    public static final int SWITCHING = 3;
    public static final int ICON_SIZE_NONE = 0;
    public static final int ICON_SIZE_SMALL = 1;
    public static final int ICON_SIZE_LARGE = 2;
    public static final int MENU_ITEM_KEY = 0;
    public static final int TOOLTIP_KEY = 1;
    public static final int ICON_KEY = 2;
    public static final int ACCELERATOR_KEY = 3;
    public static final int BUTTON_TEXT_KEY = 4;
    public static final int UNDO_KEY = 5;
    public static final int EDIT_KEY = 6;
    public static final int LOCK_KEY = 7;
    public static final int BACKGROUND_KEY = 8;
    public static final int DOCUMENT_KEY = 9;
    public static final int ALT_TEXT_KEY = 10;
    public static final int TOOLBAR_ITEM_KEY = 11;
    public static final int INPUT_LOCK_KEY = 12;
    public static final int RESOURCE_KEY_COUNT = 13;
    public static final String MENU_KEY_STRING = ".menu";
    public static final String MENU_MODEL_KEY_STRING = ".model";
    public static final String MENU_ITEM_KEY_STRING = ".menuitem";
    public static final String TOOLTIP_KEY_STRING = ".tooltip";
    public static final String ICON_KEY_STRING = ".icon";
    public static final String ACCELERATOR_KEY_STRING = ".accel";
    public static final String PRIORITY_KEY_STRING = ".priority";
    public static final String BUTTON_TEXT_KEY_STRING = ".button";
    public static final String UNDO_KEY_STRING = ".undo";
    public static final String EDIT_KEY_STRING = ".edit";
    public static final String LOCK_KEY_STRING = ".lock";
    public static final String INPUT_LOCK_KEY_STRING = ".inputlock";
    public static final String BACKGROUND_KEY_STRING = ".background";
    public static final String PROXY_KEY_STRING = ".proxy";
    public static final String FULLY_QUALIFIED_PROXY_KEY_STRING = ".fullyQualifiedProxy";
    public static final String DOCUMENT_TYPE_TAG = "documentType";
    public static final String ALT_TEXT_STRING = ".altText";
    public static final String TOOLBAR_ITEM_KEY_STRING = ".toolbar";
    public static final String RESOURCE_PACKAGE_KEY = "package";
    public static final String RESOURCE_CLASSES_KEY = "classes";
    private static final String LOCK_VALUE_WRITE = "WRITE";
    private static final String LOCK_VALUE_READ = "READ";
    private static final String LOCK_VALUE_NONE = "NONE";
    private static final String PROP_VALUE_TRUE = "TRUE";
    private static final String PROP_VALUE_FALSE = "FALSE";
    private static final String DEFAULT_COMBO_CONTENTS = "<No Items>";
    private static WmiDocumentType defaultDocType = null;
    private static HashMap commandMap = new HashMap();
    private static HashMap keyMap = new HashMap();
    private static boolean menuTipsEnabled = false;
    private static boolean autoRegister = true;
    private String name = null;
    private WmiResourcePackage bundle = null;
    private Integer modelLockType = null;
    private Boolean inputLockType = null;
    private Boolean backgroundCommand = null;
    private ArrayList queueableCommandList;
    private ArrayList buttonList;
    private String[] resourceValue = null;
    private boolean[] resourceLoadNeeded = null;
    private Icon[] icons = null;
    private int iconSize = 0;

    protected WmiCommand(String name, boolean replace, boolean register, WmiResourcePackage bundle) {
        boolean registerCmd;
        this.bundle = bundle;
        boolean bl = registerCmd = name != null && register;
        if (registerCmd && commandMap.containsKey(name) && !replace) {
            registerCmd = false;
        }
        this.name = name;
        if (autoRegister && registerCmd) {
            WmiCommand.registerCommand(this);
        }
        this.queueableCommandList = new ArrayList();
        this.buttonList = new ArrayList();
    }

    protected WmiCommand(String name, boolean replace, boolean register) {
        this(name, replace, register, null);
    }

    protected WmiCommand(String name, boolean replace) {
        this(name, replace, true);
    }

    protected WmiCommand(String name) {
        this(name, false);
    }

    public static WmiCommandProxy getCommandProxy(String name) {
        return WmiCommand.getCommandProxy(name, WmiMathDocumentView.getActiveDocumentView());
    }

    public static WmiCommandProxy getCommandProxy(String name, WmiMathDocumentView docView) {
        WmiDocumentType docType = docView == null ? WmiCommand.getDefaultDocumentType() : docView.getDocumentType();
        String currentDocType = docType.getDocumentType();
        while (currentDocType != null) {
            List list;
            Object obj = commandMap.get(currentDocType);
            if (obj != null && (list = (List)((HashMap)obj).get(name)) != null) {
                for (WmiCommandProxy command : list) {
                    if (command == null || !command.shouldConsumeEvent() && !command.isEnabled(docView)) continue;
                    return command;
                }
            }
            currentDocType = docType.getDocumentTagAfter(currentDocType);
        }
        return null;
    }

    public static WmiCommandProxy getCommand(String name) {
        return WmiCommand.getCommandProxy(name);
    }

    public static WmiCommand getCommandInstance(String name) {
        WmiCommandProxy cp = WmiCommand.getCommandProxy(name);
        if (cp != null) {
            return cp.getInstance();
        }
        return null;
    }

    protected static boolean isAutoRegisterEnabled() {
        return autoRegister;
    }

    public static WmiCommandProxy getCommandProxy(KeyEvent e) {
        WmiMathDocumentView docView = WmiMathDocumentView.getActiveDocumentView();
        WmiShortcutCombination keyStroke = new WmiShortcutCombination(e.getKeyChar(), e.getKeyCode(), e.getModifiersEx());
        String currentDocType = docView.getDocumentType().getDocumentType();
        while (currentDocType != null) {
            Object obj = keyMap.get(currentDocType);
            if (obj instanceof HashMap) {
                List list = (List)((HashMap)obj).get(keyStroke);
                if (list == null) {
                    WmiShortcutCombination newKeyStroke = new WmiShortcutCombination('\uffff', e.getKeyCode(), e.getModifiersEx());
                    list = (List)((HashMap)obj).get(newKeyStroke);
                }
                if (list != null) {
                    for (WmiCommandProxy command : list) {
                        if (command == null || !command.shouldConsumeEvent() && !command.isEnabled(docView)) continue;
                        command.getPriority();
                        return command;
                    }
                }
            }
            currentDocType = docView.getDocumentType().getDocumentTagAfter(currentDocType);
        }
        return null;
    }

    public static WmiCommandProxy getCommand(KeyEvent e) {
        return WmiCommand.getCommandProxy(e);
    }

    public static WmiMathDocumentView getDocumentView(ActionEvent event) {
        WmiMathDocumentView docView = null;
        WmiView view = WmiCommand.getView(event);
        if (view != null) {
            docView = view.getDocumentView();
        }
        return docView;
    }

    public static void setDefaultDocumentType(WmiDocumentType type) {
        defaultDocType = type;
    }

    public static WmiDocumentType getDefaultDocumentType() {
        if (defaultDocType == null) {
            defaultDocType = new WmiDocumentType();
        }
        return defaultDocType;
    }

    public static WmiView getView(ActionEvent event) {
        Object source;
        WmiView view = null;
        if (event != null && (source = event.getSource()) instanceof WmiView) {
            view = (WmiView)source;
        }
        return view;
    }

    public static void getViews(ActionEvent event, Collection storeViews) {
        if (event != null && storeViews != null) {
            Object source = event.getSource();
            if (source instanceof WmiView) {
                storeViews.add(source);
            } else if (source instanceof Collection) {
                for (Object item : (Collection)source) {
                    if (!(item instanceof WmiView)) continue;
                    storeViews.add(item);
                }
            }
        }
    }

    public static void invokeCommand(String name) {
        WmiCommandProxy command = WmiCommand.getCommandProxy(name);
        if (command != null) {
            ActionEvent event = new ActionEvent(command, 0, name);
            command.actionPerformed(event);
        }
    }

    public static void registerCommand(WmiCommand command) {
        WmiCommandProxy addMe = WmiCommandProxy.getProxyForCommand(command);
        WmiCommand.registerCommand(addMe);
    }

    public static void registerCommand(WmiCommandProxy command) {
        KeyStroke[] keystrokeArray;
        String docType = command.getDocumentTypeTag();
        Object docTypeObject = commandMap.get(docType);
        if (docTypeObject == null) {
            docTypeObject = new HashMap();
            commandMap.put(command.getDocumentTypeTag(), docTypeObject);
        }
        if (docTypeObject instanceof HashMap) {
            Object listObject = ((HashMap)docTypeObject).get(command.getName());
            if (listObject == null) {
                listObject = new LinkedList();
                ((HashMap)docTypeObject).put(command.getName(), listObject);
            }
            List list = (List)listObject;
            int position = 0;
            while (position < list.size() && ((WmiCommandProxy)list.get(position)).getPriority() > command.getPriority()) {
                ++position;
            }
            list.add(position, command);
        }
        if ((keystrokeArray = command.getKeyBindings()) != null) {
            int i = 0;
            while (i < keystrokeArray.length) {
                KeyStroke keystroke = keystrokeArray[i];
                if (keystroke != null) {
                    int modifiers = keystroke.getModifiers();
                    command.registerKeyBinding(docType, new WmiShortcutCombination(keystroke.getKeyChar(), keystroke.getKeyCode(), modifiers));
                    int modifiedModifiers = modifiers | command.getIgnorableModifier();
                    if (modifiedModifiers != modifiers) {
                        command.registerKeyBinding(docType, new WmiShortcutCombination(keystroke.getKeyChar(), keystroke.getKeyCode(), modifiedModifiers));
                    }
                }
                ++i;
            }
        }
    }

    public static void loadCommandPackage(String packageName) {
        Class[] commandClasses = ResourceLoader.getClasses(packageName, WmiCommand.class);
        int i = 0;
        while (i < commandClasses.length) {
            if (!Modifier.isAbstract(commandClasses[i].getModifiers())) {
                try {
                    commandClasses[i].newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static void setMenuTipsEnabled(boolean enabled) {
        menuTipsEnabled = enabled;
    }

    public static boolean getMenuTipsEnabled() {
        return menuTipsEnabled;
    }

    public static void setAutoRegister(boolean state) {
        autoRegister = state;
    }

    public final String getName() {
        return this.name;
    }

    public String getDocumentTypeTag() {
        return this.getResource(9);
    }

    public int getType() {
        return 0;
    }

    @Override
    public final void setEnabled(boolean newValue) {
        int i = 0;
        while (i < this.buttonList.size()) {
            AbstractButton btn = (AbstractButton)this.buttonList.get(i);
            btn.setEnabled(newValue);
            ++i;
        }
        super.setEnabled(newValue);
    }

    public boolean isBackgroundTask() {
        if (this.backgroundCommand == null) {
            boolean inBackground = false;
            String cmdType = this.getResource(8);
            if (cmdType != null && cmdType.toUpperCase().indexOf(PROP_VALUE_TRUE) >= 0) {
                inBackground = true;
            }
            this.backgroundCommand = new Boolean(inBackground);
        }
        return this.backgroundCommand;
    }

    public boolean isUpdateCommand() {
        return false;
    }

    public boolean isSelected() {
        return false;
    }

    public boolean isSelected(WmiMathDocumentView view) {
        return this.isSelected();
    }

    public boolean waitsForInputLock() {
        if (this.inputLockType == null) {
            boolean result = true;
            String lockType = this.getResource(12);
            if (lockType != null && lockType.equalsIgnoreCase(Boolean.FALSE.toString())) {
                result = false;
            }
            this.inputLockType = result;
        }
        return this.inputLockType;
    }

    public int lockTypeRequired() {
        if (this.modelLockType == null) {
            int lockCode = 0;
            String lockType = this.getResource(7);
            if (lockType != null) {
                if (lockType.toUpperCase().indexOf(LOCK_VALUE_WRITE) >= 0) {
                    lockCode = 1;
                } else if (lockType.toUpperCase().indexOf(LOCK_VALUE_NONE) >= 0) {
                    lockCode = -1;
                }
            }
            this.modelLockType = new Integer(lockCode);
        }
        return this.modelLockType;
    }

    @Override
    public final boolean isEnabled() {
        boolean result = true;
        WmiMathDocumentView mathView = WmiMathDocumentView.getActiveDocumentView();
        if (mathView != null) {
            result = this.isEnabled(mathView);
        }
        return result;
    }

    public boolean isInputEnabled() {
        WmiInputLock inputLock;
        boolean inputEnabled = true;
        WmiMathDocumentView docView = WmiMathDocumentView.getActiveDocumentView();
        if (docView != null && (inputLock = docView.getInputLock()) != null) {
            inputEnabled = !inputLock.isLocked();
        }
        return inputEnabled;
    }

    public abstract boolean isEnabled(WmiView var1);

    public boolean shouldConsumeEvent() {
        return true;
    }

    public JMenuItem createMenuItem() {
        JMenuItem item = null;
        String mnemonic = null;
        String itemText = this.getResource(0);
        String tipText = this.getResource(1);
        String altText = null;
        if (this.getType() == 3) {
            altText = this.getResource(10);
        }
        if (itemText != null) {
            mnemonic = WmiComponentUtil.getMnemonic(itemText);
            itemText = StringTools.removeTilde(itemText);
        }
        item = this.createMenuItem(itemText, altText);
        if (tipText != null) {
            item.setToolTipText(tipText);
        }
        item.addActionListener(this);
        KeyStroke[] accelKeyStrokes = this.getKeyBindings();
        if (accelKeyStrokes != null) {
            item.setAccelerator(accelKeyStrokes[0]);
        }
        if (mnemonic != null && mnemonic.length() == 1) {
            item.setMnemonic(mnemonic.charAt(0));
        }
        return item;
    }

    public JMenuItem createMenuItem(String itemText) {
        return this.createMenuItem(itemText, null);
    }

    public JMenuItem createMenuItem(String itemText, String altText) {
        JMenuItem item = null;
        switch (this.getType()) {
            case 0: {
                item = new WmiNormalMenuItem(itemText, this);
                break;
            }
            case 1: {
                item = new WmiToggleMenuItem(itemText);
                break;
            }
            case 3: {
                if (altText != null) {
                    item = new WmiSwitchingMenuItem(itemText, altText);
                    break;
                }
                item = new WmiSwitchingMenuItem(itemText, itemText);
                break;
            }
        }
        if (item != null && RuntimePlatform.isWindows() && RuntimeLocale.isSimplifiedChinese()) {
            Font font = item.getFont();
            item.setFont(font.deriveFont(12.0f));
        }
        return item;
    }

    public JMenuItem createMenuItem(JMenu menu) {
        return this.createMenuItem(menu, -1);
    }

    public void addMenuListeners(JMenu menu, JMenuItem item) {
        item.setEnabled(this.isEnabled());
        switch (this.getType()) {
            case 0: {
                menu.addMenuListener(new WmiMenuActivateListener(item));
                break;
            }
            case 1: {
                menu.addMenuListener(new WmiToggleMenuActivateListener(item));
                item.setSelected(this.isSelected());
                break;
            }
            case 3: {
                if (!(item instanceof WmiSwitchingMenuItem)) break;
                WmiSwitchingItemActivateListener switcher = new WmiSwitchingItemActivateListener((WmiSwitchingMenuItem)item);
                menu.addMenuListener(switcher);
                item.setText(switcher.getItemText());
                break;
            }
        }
        if (item instanceof WmiMenuItem) {
            ((WmiMenuItem)((Object)item)).setContainingMenu(menu);
        }
    }

    public final JMenuItem createMenuItem(JMenu menu, int pos) {
        JMenuItem item = this.createMenuItem();
        if (pos < 0) {
            menu.add(item);
        } else {
            menu.insert(item, pos);
        }
        this.addMenuListeners(menu, item);
        return item;
    }

    public AbstractButton createButton(int buttonIconSize) {
        return this.createButton(buttonIconSize, 24);
    }

    public AbstractButton createButton(int buttonIconSize, int preferredSize) {
        WmiToolBarButton theButton = null;
        if (this.iconSize == buttonIconSize && this.icons != null) {
            theButton = new WmiToolBarButton(this.icons);
        } else {
            String iconPath = this.getResource(2);
            if (iconPath != null) {
                theButton = new WmiToolBarButton(buttonIconSize, preferredSize, iconPath, this.getResourceDirectory());
                this.icons = new Icon[2];
                this.icons[0] = theButton.getIcon();
                this.icons[1] = theButton.getDisabledIcon();
                this.iconSize = buttonIconSize;
            } else {
                String text = this.getResource(4);
                if (text != null) {
                    int position = text.indexOf(126);
                    text = text.replaceFirst("~", "");
                    theButton = new WmiToolBarButton();
                    theButton.setText(text);
                    if (position >= 0 && position < text.length()) {
                        theButton.setMnemonic(text.charAt(position));
                    }
                }
            }
        }
        if (theButton != null) {
            theButton.setEnabled(this.isEnabled());
            theButton.setToolTipText(this.getResource(1));
            theButton.addActionListener(this);
            this.buttonList.add(theButton);
        }
        return theButton;
    }

    public final AbstractButton createSpeedbarButton(int buttonIconSize, int preferredSize) {
        WmiToolBarButton theButton = null;
        if (this.iconSize == buttonIconSize && this.icons != null) {
            theButton = new WmiToolBarButton(this.icons);
        } else {
            String iconPath = this.getResource(2);
            if (iconPath != null) {
                theButton = new WmiToolBarButton(buttonIconSize, preferredSize, iconPath, this.getResourceDirectory());
                this.icons = new Icon[2];
                this.icons[0] = theButton.getIcon();
                this.icons[1] = theButton.getDisabledIcon();
                this.iconSize = buttonIconSize;
            } else {
                return this.createButton(buttonIconSize, preferredSize);
            }
        }
        if (theButton != null) {
            theButton.setEnabled(true);
            theButton.setToolTipText(this.getResource(1));
            theButton.addActionListener(this);
            this.buttonList.add(theButton);
        }
        return theButton;
    }

    public final AbstractButton createButton(int buttonIconSize, JToolBar toolbar) {
        int pref = toolbar instanceof WmiToolBar ? ((WmiToolBar)toolbar).getPreferredButtonIconSize() : 24;
        AbstractButton button = this.createSpeedbarButton(buttonIconSize, pref);
        if (button != null && toolbar != null) {
            toolbar.add(button);
        }
        return button;
    }

    public final void detachButton(AbstractButton theButton) {
        this.buttonList.remove(theButton);
    }

    protected final KeyStroke[] getKeyBindings() {
        KeyStroke[] accelKeyStrokes = null;
        String accel = this.getResource(3);
        if (accel != null) {
            String[] accelArray = accel.split("\\s*,\\s*");
            accelKeyStrokes = new KeyStroke[accelArray.length];
            int i = 0;
            while (i < accelArray.length) {
                accelKeyStrokes[i] = KeyStroke.getKeyStroke(accelArray[i]);
                ++i;
            }
        }
        return accelKeyStrokes;
    }

    protected int getIgnorableModifier() {
        return 0;
    }

    public final void registerKeyBinding(String documentStyle, WmiShortcutCombination shortcut) {
        Object docTypeObject = keyMap.get(documentStyle);
        if (docTypeObject == null) {
            docTypeObject = new HashMap();
            keyMap.put(this.getDocumentTypeTag(), docTypeObject);
        }
        if (docTypeObject instanceof HashMap) {
            Object listObject = ((HashMap)docTypeObject).get(shortcut);
            if (listObject == null) {
                listObject = new LinkedList();
                ((HashMap)docTypeObject).put(shortcut, listObject);
            }
            List list = (List)listObject;
            int position = 0;
            while (position < list.size() && ((WmiCommand)list.get(position)).getPriority() > this.getPriority()) {
                ++position;
            }
            WmiCommandProxy addMe = WmiCommandProxy.getProxyForCommand(this);
            list.add(position, addMe);
        }
    }

    public final int getPriority() {
        int answer = 0;
        String priority = this.getResource(String.valueOf(this.name) + PRIORITY_KEY_STRING);
        if (priority != null) {
            try {
                answer = Integer.parseInt(priority);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return answer;
    }

    public final WmiComboBox createComboBox(WmiModel forModel) {
        WmiComboBox box = null;
        if (this.getType() == 2) {
            box = new WmiComboBox(this);
            box.setUI(WmiComboBoxUIFactory.createUI(1));
            Font font = box.getFont();
            box.setFont(font.deriveFont(10.0f));
            this.reloadComboBox(box, forModel);
            box.setToolTipText(this.getResource(1));
        }
        return box;
    }

    public final WmiComboBox createComboBox(WmiView forView) {
        return this.createComboBox(forView.getModel());
    }

    public final WmiComboBox createComboBox() {
        return this.createComboBox((WmiModel)null);
    }

    public final void reloadComboBox(WmiComboBox box, WmiModel forModel) {
        if (box != null) {
            boolean curSelectionIgnore = box.isIgnoreSelectionChange();
            box.setIgnoreSelectionChange(true);
            box.removeAllItems();
            this.comboBoxItemLoader(box, forModel);
            box.setIgnoreSelectionChange(curSelectionIgnore);
        }
    }

    public void comboBoxItemLoader(WmiComboBox box, WmiModel forModel) {
        if (box != null) {
            box.removeAllItems();
            box.addItem(DEFAULT_COMBO_CONTENTS);
        }
    }

    public void updateComboBoxSelection(WmiComboBox box, WmiModel model) {
    }

    public void updateComboBoxSelection(WmiComboBox box, WmiView view) {
        if (view != null) {
            this.updateComboBoxSelection(box, view.getModel());
        }
    }

    protected abstract String getResourcePath();

    public final String getResourceDirectory() {
        String imagePath = String.valueOf('/') + this.getResourcePath().replace('.', '/');
        int breakPoint = imagePath.lastIndexOf(47);
        if (breakPoint > 0) {
            imagePath = imagePath.substring(0, breakPoint);
        }
        return imagePath;
    }

    private WmiResourcePackage getResourceBundle() {
        if (this.bundle == null) {
            String resourcePath = this.getResourcePath();
            this.bundle = WmiResourcePackage.getResourcePackage(resourcePath);
        }
        return this.bundle;
    }

    public final String getResource(String key) {
        WmiResourcePackage b = this.getResourceBundle();
        return b.getStringForKey(key);
    }

    public final String getResource(int type) {
        String value = null;
        if (this.resourceValue == null) {
            this.resourceValue = new String[13];
            this.resourceLoadNeeded = new boolean[13];
            int i = 0;
            while (i < 13) {
                this.resourceLoadNeeded[i] = true;
                ++i;
            }
        } else {
            value = this.resourceValue[type];
        }
        if (this.resourceLoadNeeded[type]) {
            String suffix = null;
            switch (type) {
                case 0: {
                    suffix = MENU_ITEM_KEY_STRING;
                    break;
                }
                case 11: {
                    suffix = TOOLBAR_ITEM_KEY_STRING;
                    break;
                }
                case 1: {
                    suffix = TOOLTIP_KEY_STRING;
                    break;
                }
                case 2: {
                    suffix = ICON_KEY_STRING;
                    break;
                }
                case 3: {
                    suffix = ACCELERATOR_KEY_STRING + WmiResourcePackage.getPlatformSuffix();
                    break;
                }
                case 4: {
                    suffix = BUTTON_TEXT_KEY_STRING;
                    break;
                }
                case 5: {
                    suffix = UNDO_KEY_STRING;
                    break;
                }
                case 6: {
                    suffix = EDIT_KEY_STRING;
                    break;
                }
                case 7: {
                    suffix = LOCK_KEY_STRING;
                    break;
                }
                case 12: {
                    suffix = INPUT_LOCK_KEY_STRING;
                    break;
                }
                case 8: {
                    suffix = BACKGROUND_KEY_STRING;
                    break;
                }
                case 9: {
                    value = this.getResource(DOCUMENT_TYPE_TAG);
                    if (value == null) {
                        value = "default";
                        break;
                    }
                    value = value.trim();
                    break;
                }
                case 10: {
                    suffix = ALT_TEXT_STRING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (type != 9) {
                value = this.getResource(String.valueOf(this.name) + suffix);
            }
            this.resourceValue[type] = value;
            this.resourceLoadNeeded[type] = false;
        }
        return value;
    }

    public final void setResources(String[] resources) {
        this.resourceValue = resources;
        this.resourceLoadNeeded = new boolean[13];
    }

    public final void setResource(int type, String value) {
        if (this.resourceValue == null) {
            this.getResource(type);
        }
        this.resourceValue[type] = value;
        this.resourceLoadNeeded[type] = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean checkEnabledForEvent(Object source) {
        boolean enabledNow = false;
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            try {
                WmiView[] views = new WmiView[collection.size()];
                views = collection.toArray(views);
                int v = 0;
                while (!enabledNow && v < views.length) {
                    enabledNow = this.isEnabled(views[v]);
                    ++v;
                }
            }
            catch (ArrayStoreException arrayStoreException) {}
        } else {
            enabledNow = source instanceof WmiView ? this.isEnabled((WmiView)source) : this.isEnabled(WmiMathDocumentView.getActiveDocumentView());
        }
        if (!enabledNow) return enabledNow;
        if (!this.waitsForInputLock()) return enabledNow;
        return this.isInputEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        if (this.checkEnabledForEvent(event.getSource())) {
            WmiTaskMonitor.getInstance().executeCommand(this, event);
        }
    }

    public abstract void doCommand(ActionEvent var1) throws WmiNoReadAccessException, WmiNoWriteAccessException;

    public final WmiModel getModel(ActionEvent event) {
        WmiView view = (WmiView)event.getSource();
        WmiModel model = view.getModel();
        return model;
    }

    public static void registerCommands(WmiResourcePackage pkg) {
        try {
            pkg.instantiateClasses();
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    protected final void addQueueableCommand(String cmdName) {
        if (!this.queueableCommandList.contains(cmdName)) {
            this.queueableCommandList.add(cmdName);
        }
    }

    protected final void removeQueueableCommand(String cmdName) {
        this.queueableCommandList.remove(cmdName);
    }

    public boolean canQueue(String cmdName) {
        return this.queueableCommandList.contains(cmdName);
    }

    protected class WmiMenuActivateListener
    implements MenuListener {
        protected JMenuItem item;

        protected WmiMenuActivateListener(JMenuItem item) {
            this.item = item;
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            if (this.item.isVisible()) {
                this.item.setEnabled(WmiCommand.this.checkEnabledForEvent(e.getSource()) && WmiCommand.this.isInputEnabled());
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            if (this.item.isVisible()) {
                this.item.setEnabled(WmiCommand.this.checkEnabledForEvent(e.getSource()) && WmiCommand.this.isInputEnabled());
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            if (this.item.isVisible()) {
                this.item.setEnabled(WmiCommand.this.checkEnabledForEvent(e.getSource()) && WmiCommand.this.isInputEnabled());
            }
        }
    }

    public static class WmiShortcutCombination {
        private static final int RELEVANT_MODIFIERS = 960;
        private char shortcutChar;
        private int shortcutCode;
        private int shortcutModifiers;

        public WmiShortcutCombination(char keyChar, int keyCode, int keyModifiers) {
            this.shortcutChar = keyChar;
            this.shortcutCode = keyCode;
            this.shortcutModifiers = 0x3C0 & keyModifiers;
            if (RuntimePlatform.isMac() && keyChar == '\u007f') {
                this.shortcutChar = (char)65535;
            } else if (keyChar != '\uffff') {
                this.shortcutCode = 0;
            }
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof WmiShortcutCombination) {
                WmiShortcutCombination other = (WmiShortcutCombination)obj;
                isEqual = this.shortcutChar != '\uffff' && other.shortcutChar != '\uffff' ? this.shortcutChar == other.shortcutChar : this.shortcutCode == other.shortcutCode;
                isEqual &= this.shortcutModifiers == other.shortcutModifiers;
            }
            return isEqual;
        }

        public int hashCode() {
            int code = this.shortcutChar;
            code ^= this.shortcutCode;
            return code ^= this.shortcutModifiers;
        }
    }

    protected class WmiSwitchingItemActivateListener
    implements MenuListener {
        private WmiSwitchingMenuItem theItem = null;

        public WmiSwitchingItemActivateListener(WmiSwitchingMenuItem item) {
            this.theItem = item;
        }

        public String getItemText() {
            return WmiCommand.this.isSelected() ? this.theItem.getSelectedItemText() : this.theItem.getUnselectedItemText();
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            if (this.theItem.isVisible()) {
                this.theItem.setEnabled(WmiCommand.this.checkEnabledForEvent(e.getSource()) && WmiCommand.this.isInputEnabled());
                this.theItem.setText(this.getItemText());
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            if (this.theItem.isVisible()) {
                this.theItem.setEnabled(WmiCommand.this.checkEnabledForEvent(e.getSource()) && WmiCommand.this.isInputEnabled());
                this.theItem.setText(this.getItemText());
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            if (this.theItem.isVisible()) {
                this.theItem.setEnabled(WmiCommand.this.checkEnabledForEvent(e.getSource()) && WmiCommand.this.isInputEnabled());
                this.theItem.setText(this.getItemText());
            }
        }
    }

    protected class WmiToggleMenuActivateListener
    extends WmiMenuActivateListener
    implements MenuListener {
        protected WmiToggleMenuActivateListener(JMenuItem item) {
            super(item);
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            super.menuCanceled(e);
            if (this.item.isVisible()) {
                this.item.setSelected(WmiCommand.this.isSelected());
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            super.menuDeselected(e);
            if (this.item.isVisible()) {
                this.item.setSelected(WmiCommand.this.isSelected());
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            super.menuSelected(e);
            if (this.item.isVisible()) {
                this.item.setSelected(WmiCommand.this.isSelected());
            }
        }
    }
}

