/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WmiCommandLoader
extends Task {
    private static final String COMMAND_NAMES_KEY = "names";
    private static final String COMMAND_LOADING_CUSTOM = "customloading";
    private static final String MENU_LOADING_CUSTOM = ".menu.custom";
    private static final String separator = System.getProperty("line.separator");
    private static final int LOW_ASCII = 127;
    private static int menuCounter = 0;
    private static int itemCounter = 0;
    private String source;
    private String basedir;
    private String proxy;
    private String target;
    private String className;
    private File targetFile;
    private FileWriter writer;
    private String indent = "";

    public void execute() throws BuildException {
        System.setProperty("java.awt.headless", "true");
        try {
            String[] platforms = null;
            platforms = RuntimePlatform.isWindows() ? new String[]{"Win", "Mac", "Unix"} : (RuntimePlatform.isMac() ? new String[]{"Mac", "Win", "Unix"} : new String[]{"Unix", "Win", "Mac"});
            int i = 0;
            while (i < platforms.length) {
                RuntimePlatform.setOS(platforms[i]);
                WmiResourcePackage.setPlatformSuffix();
                this.exportAllLocalizations(platforms[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void exportAllLocalizations(String platform) throws IOException {
        Iterator it = RuntimeLocale.getSupportedLocaleIterator();
        while (it.hasNext()) {
            Locale locale = (Locale)it.next();
            RuntimeLocale.setDisplayLocale(locale);
            this.export(String.valueOf(platform) + "_" + locale.toString());
        }
    }

    private void export(String classSuffix) throws IOException {
        int classNameIndex = this.target.lastIndexOf("/");
        if (classNameIndex < 0) {
            throw new IOException("Invalid target");
        }
        this.className = String.valueOf(this.target.substring(classNameIndex + 1)) + classSuffix;
        this.targetFile = new File(String.valueOf(this.target) + classSuffix + ".java");
        boolean doMake = false;
        if (!this.targetFile.exists()) {
            doMake = true;
        } else {
            doMake = this.checkFiles(this.source);
            if (this.proxy != null) {
                doMake |= this.checkFiles(this.proxy);
            }
        }
        if (doMake) {
            File sourceFile = new File(this.source);
            String baseName = sourceFile.getName();
            int index = baseName.indexOf(46);
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            this.registerCommands();
        }
    }

    public boolean checkFiles(String base) {
        boolean doMake = false;
        File sourceFile = new File(String.valueOf(this.basedir) + "/" + base + ".properties");
        File sourceFile2 = new File(String.valueOf(this.basedir) + "/" + base + "_localized_en.properties");
        File sourceFile3 = new File(String.valueOf(this.basedir) + "/" + base + "_localized_ja.properties");
        if (sourceFile.lastModified() > this.targetFile.lastModified()) {
            doMake = true;
        } else if (sourceFile2.lastModified() > this.targetFile.lastModified()) {
            doMake = true;
        } else if (sourceFile3 != null && sourceFile3.lastModified() > this.targetFile.lastModified()) {
            doMake = true;
        }
        return doMake;
    }

    public void setSource(String theSource) {
        this.source = theSource;
    }

    public void setBaseDir(String theBaseDir) {
        this.basedir = theBaseDir;
    }

    public void setProxy(String theProxy) {
        this.proxy = theProxy;
    }

    public void setTarget(String theTarget) {
        this.target = theTarget;
    }

    public void setClassname(String theClassName) {
        this.className = theClassName;
    }

    public void registerCommands() {
        try {
            WmiResourcePackage bundle = WmiResourcePackage.getResourcePackage(this.source);
            WmiResourcePackage proxyBundle = this.proxy != null ? WmiResourcePackage.getResourcePackage(this.proxy) : null;
            int keyIndex = this.source.lastIndexOf(47);
            String key = keyIndex >= 0 ? this.source.substring(keyIndex + 1) : null;
            String packageName = bundle.getStringForKey("package");
            String classNames = bundle.getStringForKey("classes");
            String commandNames = bundle.getStringForKey(COMMAND_NAMES_KEY);
            String menuitems = key != null ? bundle.getStringForKey(String.valueOf(key) + ".menu") : null;
            this.writePreamble();
            HashMap<String, WmiCommand> completedCommands = new HashMap<String, WmiCommand>();
            if (classNames != null) {
                String[] classes = classNames.split("  *");
                int i = 0;
                while (i < classes.length) {
                    String[] pair = classes[i].split(":");
                    assert (pair.length == 2 || pair.length == 1);
                    String className = pair[0];
                    WmiCommand c = this.writeCommandLoader(packageName, className);
                    if (c != null) {
                        String commandName = c.getName();
                        String proxyName = this.getResource(bundle, commandName, ".proxy");
                        this.setIndent("        ");
                        if (proxyName == null) {
                            this.writeSetResources(bundle, proxyBundle, commandName);
                        } else {
                            this.writeSetResources(proxyBundle, proxyBundle, proxyName);
                        }
                        this.writeln("WmiCommand.registerCommand( command );");
                        completedCommands.put(commandName, c);
                        this.setIndent("");
                    }
                    ++i;
                }
            }
            MenuBuilder builder = null;
            if (key != null) {
                builder = new MenuBuilder(key, bundle, proxyBundle);
            }
            if (commandNames != null) {
                String customloading = bundle.getStringForKey(COMMAND_LOADING_CUSTOM);
                if (customloading != null && !customloading.equals(COMMAND_LOADING_CUSTOM)) {
                    this.writeln("// java code imported from the properties file:");
                    this.writeln(customloading);
                }
                String[] commandNameArray = commandNames.split("  *");
                int i = 0;
                while (i < commandNameArray.length) {
                    String commandName = commandNameArray[i];
                    if (!completedCommands.containsKey(commandName)) {
                        String proxyName = this.getResource(bundle, commandName, ".proxy");
                        if (proxyName == null) {
                            this.writeResourceLoader(bundle, proxyBundle, commandName);
                        } else {
                            this.writeResourceLoader(proxyBundle, proxyBundle, proxyName);
                        }
                    }
                    ++i;
                }
                this.flushCommandLoader(true);
            } else {
                this.flushCommandLoader(false);
            }
            if (key != null) {
                this.writeMenuPreamble(builder.menuID);
                builder.write();
                this.flushMenu();
            }
            this.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setIndent(String s) {
        this.indent = s;
    }

    private void writeln(String line) throws IOException {
        this.writer.write(this.indent);
        this.writer.write(line);
        this.writer.write(separator);
    }

    private void writeLines(String[] lines) throws IOException {
        int i = 0;
        while (i < lines.length) {
            this.writeln(lines[i]);
            ++i;
        }
    }

    private void writePreamble() throws IOException {
        this.writer = new FileWriter(this.targetFile);
        this.writeLines(new String[]{"// This is an autogenerated file -- Please do not edit directly.", "", "", "package com.maplesoft.wksload;", "", "", "import java.util.HashMap;", "import java.util.Iterator;", "import javax.swing.KeyStroke;", "import javax.swing.JMenu;", "import javax.swing.JMenuItem;", "import javax.swing.event.MenuListener;", "import javax.swing.event.MenuEvent;", "import com.maplesoft.client.BuildConstants;", "import com.maplesoft.mathdoc.controller.WmiCommand;", "import com.maplesoft.mathdoc.controller.WmiCommandProxy;", "import com.maplesoft.mathdoc.controller.WmiMenuBuilder;", "import com.maplesoft.worksheet.application.WmiWorksheet;", "", "", "public class " + this.className + " implements WmiMenuBuilder {", "", "", "    public boolean loadCommands() {", "        WmiWorksheet.progress(\"loadCommands in " + this.targetFile.getName() + "\");", "        WmiCommand command = null;", "        HashMap commandMap = new HashMap();", "         boolean register;", "        WmiCommand.setAutoRegister( false );"});
    }

    private WmiCommand writeCommandLoader(String packageName, String className) throws IOException {
        String completeNameForName = String.valueOf(packageName) + "." + className;
        try {
            if (className.indexOf("Mru") != -1) {
                throw new Exception("Force normal loading of Mru items");
            }
            Class<?> commandClass = Class.forName(completeNameForName);
            WmiCommand cmd = (WmiCommand)commandClass.newInstance();
            this.writeLines(new String[]{"        command = new WmiCommandProxy(", "            \"" + completeNameForName + "\",", "            \"" + cmd.getName() + "\",", "            \"" + cmd.getDocumentTypeTag() + "\", // doctype", "            " + cmd.getType() + ", // type", "            " + cmd.isBackgroundTask() + ", // isBackground", "            " + cmd.isUpdateCommand() + ", // isUpdate", "            " + cmd.lockTypeRequired() + ", // lockType", "            " + cmd.getIgnorableModifier() + ", // ignore", "            \"" + cmd.getResourcePath() + "\",", "            " + cmd.shouldConsumeEvent(), "        );"});
            return cmd;
        }
        catch (Exception e) {
            this.writeln("        // " + e.toString());
            className = className.trim().replaceAll("\\$", ".");
            String completeNameNew = String.valueOf(packageName) + "." + className;
            this.writeLines(new String[]{"        command = new " + completeNameNew + "();", "        commandMap.put( command.getName(), command); "});
            return null;
        }
    }

    private void flushCommandLoader(boolean success) throws IOException {
        this.writeLines(new String[]{"        if( BuildConstants.DEBUG && commandMap.size() > 0 ) { ", "            Iterator it = commandMap.keySet().iterator();", "            while( it.hasNext() ) {", "                System.out.println(\"Did not initialize resources for \" + it.next() );", "            }", "        }", "        WmiCommand.setAutoRegister( true );", "        return " + success + ";", "    }", ""});
    }

    private void writeMenuPreamble(int id) throws IOException {
        this.writeLines(new String[]{"    public void buildMenu( JMenu menu ) {", "        buildMenu" + id + "( menu );", "    }", ""});
    }

    private void flushMenu() throws IOException {
        this.writer.write(separator);
    }

    private void writeResourceLoader(WmiResourcePackage bundle, WmiResourcePackage proxyBundle, String commandName) throws IOException {
        if ((commandName = commandName.trim()).length() > 0) {
            this.writeLines(new String[]{"        command = (WmiCommand) commandMap.get(\"" + commandName + "\");", "         register = true;", "        if( command == null ) { ", "            command = WmiCommand.getCommandProxy(\"" + commandName + "\");", "             register = false;", "         }"});
            this.writeln("        if( command != null ) {");
            this.setIndent("            ");
            this.writeSetResources(bundle, proxyBundle, commandName);
            this.setIndent("");
            this.writeLines(new String[]{"            if( register ) {", "                WmiCommand.registerCommand( command );", "                if( BuildConstants.DEBUG ) {", "                    commandMap.remove(\"" + commandName + "\");", "                }", "            }", "        } else {", "            if( BuildConstants.DEBUG ) {", "                 System.out.println( \"Failed to load " + commandName + "\");", "            }", "        }"});
        }
    }

    private void writeSetResources(WmiResourcePackage bundle, WmiResourcePackage proxyBundle, String commandName) throws IOException {
        String proxyName = bundle.getStringForKey(String.valueOf(commandName) + ".proxy");
        if (proxyName != null) {
            commandName = proxyName;
            bundle = proxyBundle;
        }
        String[] resources = new String[13];
        resources[0] = this.getResource(bundle, commandName, ".menuitem");
        resources[1] = this.getResource(bundle, commandName, ".tooltip");
        resources[2] = this.getResource(bundle, commandName, ".icon");
        resources[3] = this.getResource(bundle, commandName, ".accel");
        resources[4] = this.getResource(bundle, commandName, ".button");
        resources[5] = this.getResource(bundle, commandName, ".undo");
        resources[6] = this.getResource(bundle, commandName, ".edit");
        resources[7] = this.getResource(bundle, commandName, ".lock");
        resources[8] = this.getResource(bundle, commandName, ".background");
        resources[11] = this.getResource(bundle, commandName, ".toolbar");
        resources[12] = this.getResource(bundle, commandName, ".inputlock");
        String documentStyle = this.getResource(bundle, commandName, "documentType");
        documentStyle = documentStyle == null ? "default" : documentStyle.trim();
        resources[9] = documentStyle;
        this.writeLines(new String[]{"command.setResources( new String[] {"});
        int i = 0;
        while (i < 13) {
            this.writer.write(this.indent);
            if (resources[i] != null) {
                this.writer.write("    \"");
                this.writer.write(this.encode(resources[i].trim()));
                this.writer.write("\"");
            } else {
                this.writer.write("     null");
            }
            if (i < 12) {
                this.writer.write(",");
            } else {
                this.writer.write("}");
            }
            this.writer.write(separator);
            ++i;
        }
        this.writeLines(new String[]{");"});
    }

    private void flush() throws IOException {
        this.writer.write("}");
        this.writer.write(separator);
        this.writer.close();
    }

    private String getResource(WmiResourcePackage bundle, String commandName, String resourceName) {
        return bundle.getStringForKey(String.valueOf(commandName) + resourceName);
    }

    private static void debugIndent(int level) {
        int i = 0;
        while (i < 4 * level) {
            System.out.print(' ');
            ++i;
        }
    }

    private String encode(String input) {
        StringBuffer output = new StringBuffer();
        if (input != null) {
            int length = input.length();
            int i = 0;
            while (i < length) {
                char ch = input.charAt(i);
                if (ch > '\u007f') {
                    output.append(this.toUnicode(ch));
                } else {
                    output.append(ch);
                }
                ++i;
            }
        }
        return output.toString();
    }

    private String toUnicode(char ch) {
        StringBuffer unicode = new StringBuffer();
        unicode.append("\\u");
        if (ch <= '\u0fff') {
            unicode.append("0");
        }
        if (ch <= '\u00ff') {
            unicode.append("0");
        }
        unicode.append(Integer.toHexString(ch));
        return unicode.toString();
    }

    public static interface Builder {
        public void debugPrint(int var1);

        public void write() throws IOException;
    }

    public class CustomMenuBuilder
    implements Builder {
        private String command = null;
        private String name = null;

        public CustomMenuBuilder(String key, WmiResourcePackage bundle, WmiResourcePackage proxyBundle) {
            String proxyName = bundle.getStringForKey(String.valueOf(key) + ".proxy");
            if (proxyName != null) {
                key = proxyName;
                bundle = proxyBundle;
            }
            this.name = bundle.getStringForKey(String.valueOf(key) + ".menuitem");
            if (this.name == null) {
                this.name = key;
                int index = key.lastIndexOf(46);
                if (index >= 0) {
                    this.name = key.substring(index + 1);
                }
            }
            this.command = bundle.getStringForKey(String.valueOf(key) + WmiCommandLoader.MENU_LOADING_CUSTOM);
        }

        @Override
        public void debugPrint(int indent) {
            WmiCommandLoader.debugIndent(indent);
            System.out.println(this.command);
        }

        public String getCommand() {
            return this.command;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void write() throws IOException {
        }
    }

    public class ItemBuilder
    implements Builder {
        private String name;
        private String altName;
        private String mapleCommand;
        private String helpTopic;
        private char mnemonic;
        private String key;
        private String tooltip;
        private String accelerator;
        private int itemID;

        public ItemBuilder(String key, WmiResourcePackage bundle, WmiResourcePackage proxyBundle) {
            int n = itemCounter;
            itemCounter = n + 1;
            this.itemID = n;
            this.key = key;
            String proxyName = bundle.getStringForKey(String.valueOf(key) + ".proxy");
            if (proxyName != null) {
                this.key = key = proxyName;
                bundle = proxyBundle;
            }
            this.name = bundle.getStringForKey(String.valueOf(key) + ".menuitem");
            if (this.name == null) {
                this.name = key;
                int index = key.lastIndexOf(46);
                if (index >= 0) {
                    this.name = key.substring(index + 1);
                }
            }
            String strMnemonic = WmiComponentUtil.getMnemonic(this.name);
            this.name = StringTools.removeTilde(this.name);
            if (strMnemonic != null && strMnemonic.length() == 1) {
                this.mnemonic = strMnemonic.charAt(0);
            }
            this.altName = bundle.getStringForKey(String.valueOf(key) + ".altText");
            this.mapleCommand = bundle.getStringForKey(String.valueOf(key) + ".command");
            this.helpTopic = bundle.getStringForKey(String.valueOf(key) + ".topic");
            String proxy = bundle.getStringForKey(String.valueOf(key) + ".proxy");
            if (proxy != null) {
                this.key = proxy;
            }
            this.tooltip = WmiCommandLoader.this.getResource(bundle, key, ".tooltip");
            this.accelerator = WmiCommandLoader.this.getResource(bundle, key, ".accel");
        }

        @Override
        public void debugPrint(int indent) {
            WmiCommandLoader.debugIndent(indent);
            System.out.print(String.valueOf(this.name) + " ");
            if (this.mnemonic != '\u0000') {
                System.out.print("(" + this.mnemonic + ")");
            }
            System.out.println("  [" + this.key + "]");
        }

        @Override
        public void write() throws IOException {
            if (this.mapleCommand != null) {
                WmiCommandLoader.this.writeLines(new String[]{"    private JMenuItem buildItem" + this.itemID + "( JMenu menu ) {", "        JMenuItem item = null;", "        WmiCommand command = new com.maplesoft.worksheet.controller.tools.WmiWorksheetToolsCommandWrapper(\"" + this.key + "\", \"" + this.mapleCommand + "\");", "         if( command != null ) {"});
            } else if (this.helpTopic != null) {
                WmiCommandLoader.this.writeLines(new String[]{"    private JMenuItem buildItem" + this.itemID + "( JMenu menu ) {", "        JMenuItem item = null;", "        WmiCommand command = new com.maplesoft.worksheet.controller.help.WmiWorksheetHelpQueryCommand( \"" + this.key + "\" ) {", "\t\t\tprotected String getTopicName() {", "\t\t\t\treturn \"" + this.helpTopic + "\";", "\t\t\t}", "\t\t\tprotected String getResourcePath() {", "\t\t\t\treturn com.maplesoft.worksheet.controller.tools.WmiWorksheetToolsCommand.RESOURCES;", "\t\t\t}", "\t\t };", "        if ( command != null ) {"});
            } else {
                WmiCommandLoader.this.writeLines(new String[]{"    private JMenuItem buildItem" + this.itemID + "( JMenu menu ) {", "        JMenuItem item = null;", "        WmiCommand command = WmiCommand.getCommandProxy(\"" + this.key + "\");", "         if( command != null ) {"});
            }
            if (this.altName != null) {
                WmiCommandLoader.this.writeln("             item = command.createMenuItem(\"" + WmiCommandLoader.this.encode(this.name) + "\", \"" + WmiCommandLoader.this.encode(this.altName) + "\");");
            } else {
                WmiCommandLoader.this.writeln("             item = command.createMenuItem(\"" + WmiCommandLoader.this.encode(this.name) + "\");");
            }
            WmiCommandLoader.this.writeln("             item.addActionListener( command );");
            if (this.tooltip != null) {
                WmiCommandLoader.this.writeln("             item.setToolTipText(\"" + WmiCommandLoader.this.encode(this.tooltip) + "\");");
            }
            if (this.mnemonic != '\u0000') {
                WmiCommandLoader.this.writeln("             item.setMnemonic('" + this.mnemonic + "');");
            }
            if (this.accelerator != null) {
                WmiCommandLoader.this.writeln("             item.setAccelerator( KeyStroke.getKeyStroke(\"" + this.accelerator + "\") );");
            }
            WmiCommandLoader.this.writeLines(new String[]{"             command.addMenuListeners( menu, item );", "         }", "        return item;", "    }", ""});
        }
    }

    public class MenuBuilder
    implements Builder {
        private String name;
        private char mnemonic;
        private int menuID;
        ArrayList contents;

        public MenuBuilder(String key, WmiResourcePackage bundle, WmiResourcePackage proxyBundle) {
            int n = menuCounter;
            menuCounter = n + 1;
            this.menuID = n;
            this.contents = new ArrayList();
            String keyName = key;
            String proxyName = bundle.getStringForKey(String.valueOf(key) + ".proxy");
            if (proxyName != null) {
                keyName = key = proxyName;
                bundle = proxyBundle;
            }
            this.name = bundle.getStringForKey(String.valueOf(key) + ".menuitem");
            if (this.name == null) {
                this.name = key;
                int index = key.lastIndexOf(46);
                if (index >= 0) {
                    this.name = key.substring(index + 1);
                }
            }
            String menuItems = bundle.getStringForKey(String.valueOf(key) + ".menu");
            String strMnemonic = WmiComponentUtil.getMnemonic(this.name);
            this.name = StringTools.removeTilde(this.name);
            if (strMnemonic != null && strMnemonic.length() == 1) {
                this.mnemonic = strMnemonic.charAt(0);
            }
            StringTokenizer tokens = new StringTokenizer(menuItems);
            while (tokens.hasMoreTokens()) {
                String curToken = tokens.nextToken();
                if (curToken.equals("-")) {
                    this.contents.add(new MenuSeparatorBuilder());
                    continue;
                }
                String subName = String.valueOf(keyName) + "." + curToken;
                String customMenuLoader = bundle.getStringForKey(String.valueOf(subName) + WmiCommandLoader.MENU_LOADING_CUSTOM);
                String subKeys = bundle.getStringForKey(String.valueOf(subName) + ".menu");
                if (customMenuLoader != null) {
                    this.contents.add(new CustomMenuBuilder(subName, bundle, proxyBundle));
                    continue;
                }
                if (subKeys != null) {
                    this.contents.add(new MenuBuilder(subName, bundle, proxyBundle));
                    continue;
                }
                this.contents.add(new ItemBuilder(subName, bundle, proxyBundle));
            }
        }

        @Override
        public void debugPrint(int indent) {
            WmiCommandLoader.debugIndent(indent);
            System.out.print(String.valueOf(this.name) + " ");
            if (this.mnemonic != '\u0000') {
                System.out.print("(" + this.mnemonic + ")");
            }
            System.out.println();
            int size = this.contents.size();
            int i = 0;
            while (i < size) {
                Object obj = this.contents.get(i);
                if (obj instanceof Builder) {
                    ((Builder)obj).debugPrint(indent + 1);
                }
                ++i;
            }
        }

        @Override
        public void write() throws IOException {
            Object obj;
            WmiCommandLoader.this.writeLines(new String[]{"    private void buildMenu" + this.menuID + "(final JMenu menu) {", "        menu.setText(\"" + WmiCommandLoader.this.encode(this.name) + "\");"});
            if (this.mnemonic != '\u0000') {
                WmiCommandLoader.this.writeln("        menu.setMnemonic('" + this.mnemonic + "');");
            }
            WmiCommandLoader.this.writeLines(new String[]{"        final MenuListener cml = new MenuListener() {", "            public void menuCanceled(MenuEvent e) {}", "            public void menuDeselected(MenuEvent e) {}", "            public void menuSelected(MenuEvent e) {", "                JMenuItem childItem = null;", "                JMenu childMenu = null;"});
            int size = this.contents.size();
            int i = 0;
            while (i < size) {
                obj = this.contents.get(i);
                if (obj instanceof CustomMenuBuilder) {
                    String encodedName = WmiCommandLoader.this.encode(((CustomMenuBuilder)obj).getName());
                    WmiCommandLoader.this.writeLines(new String[]{"                   childMenu = new JMenu();", "                   childMenu.setText(\"" + encodedName + "\");", "                   " + ((CustomMenuBuilder)obj).getCommand() + "( childMenu );", "                   menu.add( childMenu );"});
                } else if (obj instanceof MenuBuilder) {
                    WmiCommandLoader.this.writeLines(new String[]{"                   childMenu = new JMenu();", "                   buildMenu" + ((MenuBuilder)obj).menuID + "( childMenu );", "                   menu.add( childMenu );"});
                } else if (obj instanceof MenuSeparatorBuilder) {
                    WmiCommandLoader.this.writeln("        menu.addSeparator();");
                } else if (obj instanceof ItemBuilder) {
                    WmiCommandLoader.this.writeLines(new String[]{"                   childItem = buildItem" + ((ItemBuilder)obj).itemID + "( menu );", "                   if( childItem != null ) {", "                       menu.add( childItem );", "                   }"});
                }
                ++i;
            }
            WmiCommandLoader.this.writeLines(new String[]{"                menu.removeMenuListener(this);", "            }", "        };", "        menu.addMenuListener(cml);", "    }", ""});
            i = 0;
            while (i < size) {
                obj = this.contents.get(i);
                if (obj instanceof MenuBuilder) {
                    ((MenuBuilder)obj).write();
                } else if (obj instanceof ItemBuilder) {
                    ((ItemBuilder)obj).write();
                }
                ++i;
            }
        }
    }

    public class MenuSeparatorBuilder
    implements Builder {
        @Override
        public void debugPrint(int indent) {
            WmiCommandLoader.debugIndent(indent);
            System.out.println("[separator]");
        }

        @Override
        public void write() throws IOException {
        }
    }
}

