/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public final class WmiDocumentScroller {
    private static final int BUFFER = 2;

    private WmiDocumentScroller() {
    }

    public static void scrollVisible(WmiScrollableContainerView scrollable, Rectangle markerBounds) {
        Rectangle r = scrollable.getVisibleRect();
        boolean doScroll = false;
        int x = r.x;
        int y = r.y;
        int markerTop = WmiDocumentScroller.constrain(markerBounds.y, scrollable.getHeight());
        int markerBottom = WmiDocumentScroller.constrain(markerBounds.y + markerBounds.height, scrollable.getHeight());
        int markerLeft = WmiDocumentScroller.constrain(markerBounds.x, scrollable.getWidth());
        int markerRight = WmiDocumentScroller.constrain(markerBounds.x + markerBounds.width, scrollable.getWidth());
        if (r != null) {
            if (r.y + r.height < markerBottom - 2) {
                y = markerBottom - r.height;
                doScroll = true;
            } else if (r.y > markerTop) {
                y = markerTop;
                doScroll = true;
            }
            if (r.x + r.width < markerRight - 2) {
                x = markerRight - r.width;
                doScroll = true;
            } else if (r.x > markerLeft) {
                x = markerLeft;
                doScroll = true;
            }
        }
        if (doScroll) {
            if (scrollable instanceof WmiMathDocumentView) {
                ((WmiMathDocumentView)scrollable).setVisibleRegion(x, y);
            } else {
                SwingUtilities.invokeLater(new WmiDelayedScroll(scrollable, x, y));
            }
        }
    }

    private static int constrain(int x, int max) {
        x = Math.max(x, 0);
        x = Math.min(x, max);
        return x;
    }

    public static void scrollToTop(WmiScrollableContainerView scrollable, Rectangle markerBounds) {
        Rectangle r = scrollable.getVisibleRect();
        int x = r.x;
        int y = r.y;
        if (r != null) {
            y = markerBounds.y > scrollable.getHeight() - r.height ? scrollable.getHeight() - r.height : markerBounds.y;
            if (markerBounds.x > scrollable.getWidth() - r.width) {
                x = scrollable.getWidth() - r.width;
            }
            SwingUtilities.invokeLater(new WmiDelayedScroll(scrollable, x, y));
        }
    }

    public static Rectangle getViewBounds(WmiPositionedView view) {
        Point pt = WmiViewUtil.getAbsoluteOffset(view);
        return new Rectangle(pt.x, pt.y, view.getWidth(), view.getHeight());
    }

    private static class WmiDelayedScroll
    implements Runnable {
        private int x;
        private int y;
        private WmiScrollableContainerView scrollable;

        private WmiDelayedScroll(WmiScrollableContainerView scrollable, int x, int y) {
            this.scrollable = scrollable;
            this.x = x;
            this.y = y;
        }

        @Override
        public void run() {
            this.scrollable.setScrollPosition(this.x, this.y);
        }
    }
}

