/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class WmiKeyBinder
extends HashMap {
    public void registerBinding(char c, WmiDispatchOperation o) {
        KeyStroke stroke = KeyStroke.getKeyStroke(c);
        this.registerBinding(stroke, o);
    }

    public void registerBinding(char c, int modifiers, WmiDispatchOperation o) {
        WmiCharModCombo kcc = new WmiCharModCombo(c, modifiers);
        this.put(kcc, o);
    }

    public void registerBinding(int code, int modifiers, WmiDispatchOperation o) {
        KeyStroke stroke = KeyStroke.getKeyStroke(code, modifiers);
        this.registerBinding(stroke, o);
    }

    public void registerBinding(KeyStroke stroke, WmiDispatchOperation o) {
        this.put(stroke, o);
    }

    public void registerBindingOverRange(char start, char end, WmiDispatchOperation o) {
        char i = start;
        while (i <= end) {
            this.registerBinding(i, o);
            i = (char)(i + '\u0001');
        }
    }

    public boolean handlesKey(KeyStroke key) {
        return this.get(key) != null;
    }

    public boolean handlesKey(WmiCharModCombo key) {
        return this.get(key) != null;
    }

    public boolean dispatch(KeyEvent event, WmiView view) {
        boolean handled = false;
        KeyStroke stroke = null;
        switch (event.getKeyChar()) {
            case '\t': {
                stroke = KeyStroke.getKeyStroke(new Character('\t'), event.getModifiers());
                break;
            }
            default: {
                stroke = event.getID() == 400 ? KeyStroke.getKeyStroke(event.getKeyChar()) : (RuntimePlatform.isMac_10_2() && (event.getModifiers() & 0xFFFFFFFE) == 0 ? KeyStroke.getKeyStroke(event.getKeyChar()) : KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers()));
            }
        }
        WmiCharModCombo cmc = new WmiCharModCombo(event);
        if (this.handlesKey(stroke)) {
            handled = this.get(stroke).dispatch(event, view);
        } else if (this.handlesKey(cmc)) {
            handled = this.get(cmc).dispatch(event, view);
        }
        return handled;
    }

    @Override
    public void put(KeyStroke key, WmiDispatchOperation o) {
        super.put(key, o);
    }

    @Override
    public void put(WmiCharModCombo key, WmiDispatchOperation o) {
        super.put(key, o);
    }

    public WmiDispatchOperation get(WmiCharModCombo key) {
        return (WmiDispatchOperation)super.get(key);
    }

    public WmiDispatchOperation get(KeyStroke key) {
        return (WmiDispatchOperation)super.get(key);
    }

    private class WmiCharModCombo {
        char c;
        boolean ctrlDown;
        boolean altDown;
        boolean metaDown;
        boolean shiftDown;

        WmiCharModCombo(char c, boolean ctrl_down, boolean alt_down, boolean meta_down, boolean shift_down) {
            this.c = c;
            this.ctrlDown = ctrl_down;
            this.altDown = alt_down;
            this.metaDown = meta_down;
            this.shiftDown = shift_down;
        }

        WmiCharModCombo(char c, int modifier) {
            this.c = c;
            this.ctrlDown = (modifier & 2) != 0;
            this.altDown = (modifier & 8) != 0;
            this.metaDown = (modifier & 4) != 0;
            this.shiftDown = (modifier & 1) != 0;
        }

        WmiCharModCombo(KeyEvent event) {
            this(event.getKeyChar(), event.getModifiers());
        }

        public boolean equals(Object other) {
            boolean result = false;
            if (other instanceof WmiCharModCombo) {
                WmiCharModCombo o = (WmiCharModCombo)other;
                result = this.c == o.c && this.ctrlDown == o.ctrlDown && this.altDown == o.altDown && this.metaDown == o.metaDown && this.shiftDown == o.shiftDown;
            }
            return result;
        }

        public int hashCode() {
            int result = 17 * this.c + 11 * (this.ctrlDown ? 1 : 0) + 29 * (this.altDown ? 1 : 0) + 7 * (this.metaDown ? 1 : 0) + 5 * (this.shiftDown ? 1 : 0);
            return result;
        }
    }

    public static interface WmiDispatchOperation {
        public boolean dispatch(KeyEvent var1, WmiView var2);
    }
}

