/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;

public class WmiMathDocumentKeyListener
implements KeyListener {
    private static Set allowedWithInputLock;
    private WmiMathDocumentView rootView = null;
    private WmiView focusView = null;

    public static void addInputLockOverride(WmiCommand.WmiShortcutCombination sc) {
        if (allowedWithInputLock == null) {
            allowedWithInputLock = new HashSet();
        }
        allowedWithInputLock.add(sc);
    }

    public WmiMathDocumentKeyListener(WmiMathDocumentView newRootView) {
        this.rootView = newRootView;
    }

    public void setFocus(WmiView view) {
        this.focusView = view;
    }

    public WmiView getFocus() {
        return this.focusView;
    }

    private boolean overridesInputLock(KeyEvent e) {
        if (allowedWithInputLock != null) {
            return allowedWithInputLock.contains(new WmiCommand.WmiShortcutCombination(e.getKeyChar(), e.getKeyCode(), e.getModifiersEx()));
        }
        return false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        try {
            if (this.rootView.getInputLock().isLocked() && this.overridesInputLock(e)) {
                WmiCommandProxy cmd = WmiCommand.getCommandProxy(e);
                if (cmd != null) {
                    cmd.actionPerformed(new ActionEvent(cmd, 0, cmd.getName()));
                }
            } else {
                KeyListener listener = this.getKeyListener();
                if (listener != null && !e.isConsumed()) {
                    Object source = e.getSource();
                    e.setSource(this.focusView);
                    listener.keyTyped(e);
                    e.setSource(source);
                }
            }
        }
        catch (NullPointerException npe) {
            WmiErrorLog.log(npe);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        try {
            KeyListener listener = this.getKeyListener();
            if (listener != null && !e.isConsumed()) {
                Object source = e.getSource();
                e.setSource(this.focusView);
                listener.keyPressed(e);
                e.setSource(source);
            }
        }
        catch (NullPointerException npe) {
            WmiErrorLog.log(npe);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        try {
            KeyListener listener = this.getKeyListener();
            if (listener != null) {
                Object source = e.getSource();
                e.setSource(this.focusView);
                listener.keyReleased(e);
                e.setSource(source);
            }
        }
        catch (NullPointerException npe) {
            WmiErrorLog.log(npe);
        }
    }

    protected KeyListener getKeyListener() {
        KeyListener listener = null;
        if (this.focusView != null) {
            if (this.focusView.getModel() != null && !this.rootView.getInputLock().isLocked()) {
                WmiController controller = this.rootView.getViewFactory().getController(this.focusView);
                listener = controller != null ? controller.getKeyListener() : null;
            } else {
                this.focusView = null;
            }
        }
        return listener;
    }
}

