/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiMenuBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class WmiMenu
extends JMenu
implements Cloneable {
    public static final String LIST_DELIMITER = " ";
    public static final String ITEM_DELIMITER = ".";
    public static final String SEPERATOR_TOKEN = "-";
    protected static String MENU_BUILDER_SUFFIX;
    protected String menuKey = null;
    private WmiResourcePackage menuResourceBundle = null;
    protected String menuResourcePath = null;
    private HashMap commandMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !WmiMenu.class.desiredAssertionStatus();
        MENU_BUILDER_SUFFIX = RuntimePlatform.isMac() ? "Mac" : (RuntimePlatform.isUnix() ? "Unix" : "Win");
        Locale locale = RuntimeLocale.getDisplayLocale();
        MENU_BUILDER_SUFFIX = String.valueOf(MENU_BUILDER_SUFFIX) + "_" + locale.toString();
    }

    protected WmiResourcePackage getMenuResourceBundle() {
        if (this.menuResourceBundle == null) {
            this.menuResourceBundle = WmiResourcePackage.getResourcePackage(this.menuResourcePath);
        }
        return this.menuResourceBundle;
    }

    public WmiMenu(String key, String resources) {
        super("<>");
        this.fixMenuUI();
        this.initialize(key, resources);
    }

    public WmiMenu() {
        super("<>");
        this.fixMenuUI();
    }

    private void fixMenuUI() {
        if (RuntimePlatform.isWindows()) {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    WmiMenu.this.setOpaque(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WmiMenu.this.setOpaque(WmiMenu.this.isSelected());
                }
            });
            if (RuntimeLocale.isSimplifiedChinese()) {
                Font f = this.getFont();
                this.setFont(f.deriveFont(12.0f));
            }
        }
    }

    public void initialize(String key, String resources) {
        this.menuKey = key;
        if (resources != null && resources.length() > 0) {
            this.menuResourcePath = resources;
            String localizedName = this.getItemNameForKey(this.menuKey);
            if (localizedName != null) {
                String mnemonic = WmiComponentUtil.getMnemonic(localizedName);
                localizedName = StringTools.removeTilde(localizedName);
                this.setText(localizedName);
                if (mnemonic != null && mnemonic.length() == 1) {
                    this.setMnemonic(mnemonic.charAt(0));
                }
            }
        }
    }

    protected static void addItemToMenu(String name, WmiCommand cmd, JMenu menu) {
        JMenuItem item = null;
        if (cmd != null) {
            item = cmd.createMenuItem(menu);
            if (item != null) {
                item.setFont(WmiFontResolver.getFontForCharacter(name, item.getFont()));
                item.setText(WmiFontResolver.mapCharactersForFont(name, item.getFont(), 100));
            }
        } else {
            item = new JMenuItem(name);
            item.setEnabled(false);
            menu.add(item);
        }
    }

    protected static void buildMenu(String name, WmiMenu destMenu) {
        String itemString = destMenu.getMenuElementKeys(name);
        JPopupMenu destPopup = destMenu.getPopupMenu();
        if (itemString != null && destPopup != null) {
            StringTokenizer tokens = new StringTokenizer(itemString);
            while (tokens.hasMoreTokens()) {
                String curToken = tokens.nextToken();
                if (curToken.equals(SEPERATOR_TOKEN)) {
                    destPopup.addSeparator();
                    continue;
                }
                String subName = String.valueOf(name) + ITEM_DELIMITER + curToken;
                String subKeys = destMenu.getMenuElementKeys(subName);
                if (subKeys != null) {
                    destPopup.add(destMenu.createMenuForItem(subName));
                    continue;
                }
                WmiCommand cmd = null;
                cmd = destMenu.getProxyCommand(name, curToken);
                if (cmd == null) {
                    cmd = destMenu.getCommand(name, curToken);
                }
                destMenu.createMenuItem(cmd, destMenu);
            }
        }
    }

    protected static JMenu getSubMenu(String treeString, HashMap map) {
        JMenu theMenu = (JMenu)map.get(treeString);
        if (theMenu == null) {
            int idx = treeString.lastIndexOf(ITEM_DELIMITER);
            if (idx <= 0) {
                theMenu = new JMenu(treeString);
                map.put(treeString, theMenu);
            } else {
                String menuString = treeString.substring(idx + 1);
                String parentString = treeString.substring(0, idx);
                theMenu = new JMenu(menuString);
                map.put(treeString, theMenu);
                JMenu parentMenu = WmiMenu.getSubMenu(parentString, map);
                if (parentMenu != null) {
                    parentMenu.add(theMenu);
                }
            }
        }
        return theMenu;
    }

    public static ActionEvent createDefaultEvent(JMenuItem item, ActionEvent originalEvent) {
        String actionCommand = originalEvent.getActionCommand();
        if (actionCommand == null) {
            actionCommand = item.getActionCommand();
        }
        return new ActionEvent(item, 1001, actionCommand, originalEvent.getWhen(), originalEvent.getModifiers());
    }

    protected WmiMenuBuilder getMenuBuilder(String key) {
        String name = "com.maplesoft.wksload." + key + "Menu" + MENU_BUILDER_SUFFIX;
        WmiMenuBuilder menuBuilder = null;
        try {
            Class<?> c = Class.forName(name);
            menuBuilder = (WmiMenuBuilder)c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return menuBuilder;
    }

    protected void buildMenu(WmiMenuBuilder builder) {
        if (builder != null) {
            builder.buildMenu(this);
        } else {
            this.buildMenu();
        }
    }

    protected void setLightweightPopupEnabled(JPopupMenu popup) {
        boolean lwpe = JPopupMenu.getDefaultLightWeightPopupEnabled();
        popup.setLightWeightPopupEnabled(lwpe);
        Component comp = null;
        int i = 0;
        while (i < popup.getComponentCount()) {
            comp = popup.getComponent(i);
            if (comp instanceof JMenu) {
                this.setLightweightPopupEnabled(((JMenu)comp).getPopupMenu());
            }
            ++i;
        }
    }

    protected void buildMenu() {
        WmiMenu.buildMenu(this.menuKey, this);
    }

    protected void buildMenuFromStringArray(String[] names, WmiCommand[] commands, String root, JMenu destMenu) {
        int i;
        JMenu startMenu = destMenu != null ? destMenu : this;
        String menuRoot = root;
        if (menuRoot == null) {
            int index;
            int key = -1;
            i = 0;
            while (i < names.length) {
                if (!names[i].equals(SEPERATOR_TOKEN)) {
                    key = i;
                    break;
                }
                ++i;
            }
            if (key >= 0 && (index = names[key].indexOf(ITEM_DELIMITER)) >= 0) {
                menuRoot = names[key].substring(0, index);
            }
        }
        HashMap<String, JMenu> menuMap = new HashMap<String, JMenu>();
        menuMap.put(menuRoot, startMenu);
        i = 0;
        while (i < names.length) {
            if (names[i].equals(SEPERATOR_TOKEN)) {
                startMenu.addSeparator();
            } else {
                WmiCommand itemCmd = commands != null ? commands[i] : WmiCommand.getCommandProxy(names[i]);
                String curEntry = names[i];
                if (curEntry.length() > 0) {
                    if (!curEntry.startsWith(menuRoot)) {
                        if (itemCmd != null) {
                            itemCmd.createMenuItem(startMenu);
                        } else {
                            WmiMenu.addItemToMenu(curEntry, null, startMenu);
                        }
                    } else {
                        String curItem = null;
                        String curMenuTree = null;
                        int itemIndex = curEntry.lastIndexOf(ITEM_DELIMITER);
                        if (itemIndex < 0) {
                            if (curEntry.length() > 0) {
                                WmiMenu.addItemToMenu(curEntry, itemCmd, startMenu);
                            }
                        } else {
                            curItem = curEntry.substring(itemIndex + 1);
                            curMenuTree = curEntry.substring(0, itemIndex);
                            JMenu insMenu = WmiMenu.getSubMenu(curMenuTree, menuMap);
                            if (insMenu != null) {
                                WmiMenu.addItemToMenu(curItem, itemCmd, insMenu);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public ActionEvent createEvent(JMenuItem item, ActionEvent originalEvent) {
        return WmiMenu.createDefaultEvent(item, originalEvent);
    }

    protected WmiCommand getCommand(String parentName, String menuItem) {
        return WmiCommand.getCommandInstance(String.valueOf(parentName) + ITEM_DELIMITER + menuItem);
    }

    public String getItemNameForKey(String key) {
        return this.getMenuResourceBundle().getStringForKey(String.valueOf(key) + ".menuitem");
    }

    public String getMenuElementKeys(String key) {
        return this.getMenuResourceBundle().getStringForKey(String.valueOf(key) + ".menu");
    }

    protected String getProxiedCommandForKey(String key) {
        return this.getMenuResourceBundle().getStringForKey(String.valueOf(key) + ".proxy");
    }

    protected String getFullyQualifiedProxiedCommandForKey(String key) {
        return this.getMenuResourceBundle().getStringForKey(String.valueOf(key) + ".fullyQualifiedProxy");
    }

    protected WmiCommandProxy createProxiedCommandForFullyQualifiedKey(String key) {
        String[] pair = key.split(":");
        if (!$assertionsDisabled && pair.length != 1 && pair.length != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pair[0].length() <= 0) {
            throw new AssertionError((Object)("this should be <class>:<command name> but isn't: " + key));
        }
        WmiCommandProxy obj = null;
        try {
            if (pair.length == 1) {
                Class<?> cls = Class.forName(pair[0].trim());
                obj = (WmiCommandProxy)cls.newInstance();
            } else {
                if (!$assertionsDisabled && pair[1].length() <= 0) {
                    throw new AssertionError();
                }
                String commandName = pair[1];
                obj = new WmiCommandProxy(commandName, pair[0], this.menuResourceBundle);
            }
        }
        catch (Exception exc) {
            WmiErrorLog.log(exc);
        }
        return obj;
    }

    protected WmiCommand getProxyCommand(String parentName, String menuName) {
        WmiCommandProxy proxyCmd = null;
        String proxy = this.getProxiedCommandForKey(String.valueOf(parentName) + ITEM_DELIMITER + menuName);
        if (proxy != null) {
            proxyCmd = WmiCommand.getCommandProxy(proxy);
        }
        if (proxyCmd == null && (proxy = this.getFullyQualifiedProxiedCommandForKey(String.valueOf(parentName) + ITEM_DELIMITER + menuName)) != null) {
            proxyCmd = this.createProxiedCommandForFullyQualifiedKey(proxy);
        }
        return proxyCmd;
    }

    protected JMenu createMenuForItem(String menuKey) {
        WmiMenu newMenu = new WmiMenu(menuKey, this.menuResourcePath);
        newMenu.buildMenu();
        return newMenu;
    }

    protected void createMenuItem(WmiCommand cmd, JMenu destMenu) {
        JMenuItem cmdItem;
        if (cmd != null && destMenu != null && (cmdItem = cmd.createMenuItem(destMenu)) != null) {
            this.commandMap.put(cmdItem, cmd);
        }
    }

    protected WmiCommand getCommandForItem(JMenuItem item) {
        return (WmiCommand)this.commandMap.get(item);
    }

    protected JMenuItem getMenuItemForKey(String key) {
        String targetName = this.getItemNameForKey(key);
        return this.getMenuItemForName(targetName);
    }

    protected JMenuItem getMenuItemForName(String targetName) {
        JMenuItem foundItem = null;
        if (targetName != null) {
            int totalItems = this.getItemCount();
            int item = 0;
            while (item < totalItems) {
                String itemLabel;
                JMenuItem candidate = this.getItem(item);
                if (candidate != null && (itemLabel = candidate.getText()) != null && itemLabel.equals(targetName)) {
                    foundItem = candidate;
                    break;
                }
                ++item;
            }
        }
        return foundItem;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu popup = super.getPopupMenu();
        this.setLightweightPopupEnabled(popup);
        return popup;
    }
}

