/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class WmiMouseInputAdapter
extends MouseInputAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
        if (WmiMouseInputAdapter.isPopupTrigger(e)) {
            WmiMathDocumentView docView;
            WmiView srcView;
            Object o = e.getSource();
            WmiView wmiView = srcView = o instanceof WmiView ? (WmiView)o : null;
            if (srcView != null && (docView = srcView.getDocumentView()) != null) {
                docView.notifyPopupRequest(srcView, e);
            }
        }
    }

    public static boolean isPopupTrigger(MouseEvent e) {
        boolean popup = false;
        int id = e.getID();
        int modifiers = e.getModifiers();
        if (RuntimePlatform.isMac()) {
            if (id == 501) {
                popup = (modifiers & 2) != 0 || e.getButton() == 3;
            }
        } else if (id == 502) {
            if ((modifiers & 4) == 4) {
                popup = true;
            }
        } else {
            popup = false;
        }
        return popup;
    }

    public static boolean isCaretPlacingEvent(MouseEvent e) {
        boolean rv = false;
        rv = RuntimePlatform.isMac() ? e.getID() == 501 && !e.isShiftDown() && e.getButton() == 1 : (e.getID() == 501 || e.getID() == 500) && !e.isShiftDown() && e.getButton() == 1;
        return rv;
    }

    public static boolean isHighlightChangingEvent(MouseEvent e) {
        boolean rv = false;
        rv = RuntimePlatform.isMac() ? e.getID() == 501 && e.isShiftDown() && e.getButton() == 1 : (e.getID() == 501 || e.getID() == 500) && e.isShiftDown() && e.getButton() == 1;
        return rv;
    }

    public static boolean isConditionalCaretPlacingEvent(MouseEvent e) {
        boolean rv = WmiMouseInputAdapter.isPopupTrigger(e);
        return rv;
    }
}

