/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiControllerBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.util.WmiStartup;

public class WmiReflectingControllerBuilder
implements WmiControllerBuilder {
    protected String fullyQualifiedClassname;
    protected Class clazz;
    protected WmiController controller;
    protected static boolean checkAll;
    protected static boolean checkChosen;

    public WmiReflectingControllerBuilder(String pname, String classname) {
        this(String.valueOf(pname) + "." + classname);
    }

    public WmiReflectingControllerBuilder(String fullyQualifiedClassname) {
        this.fullyQualifiedClassname = fullyQualifiedClassname;
        if (checkAll) {
            if (!checkAll) {
                int v = (int)(System.currentTimeMillis() % 50L);
                boolean bl = checkAll = v == 1;
            }
            if (checkAll) {
                if (!checkChosen) {
                    WmiStartup.progress("* * * NOTE * * * extra check in  WmiReflectingControllerBuilder; do not use this timing");
                }
                this.loadController();
            }
            checkChosen = true;
        }
    }

    private void loadController() {
        try {
            this.clazz = Class.forName(this.fullyQualifiedClassname);
        }
        catch (ClassNotFoundException e) {
            WmiErrorLog.log(e);
        }
        catch (IllegalArgumentException e) {
            WmiErrorLog.log(e);
        }
        try {
            this.controller = (WmiController)this.clazz.newInstance();
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public WmiController createController() {
        if (this.controller == null) {
            this.loadController();
        }
        assert (this.controller != null) : "got a null pointer trying to create " + this.fullyQualifiedClassname;
        return this.controller;
    }
}

