/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiStatusListener;
import com.maplesoft.mathdoc.controller.WmiTask;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;

public class WmiTaskMonitor {
    public static final int COMMAND_REFUSED = 0;
    public static final int COMMAND_COMPLETE = 1;
    public static final int COMMAND_RUNNING = 2;
    public static final int COMMAND_DEFERRED = 3;
    protected static final int NO_QUEUE = 0;
    protected static final int FOREGROUND_QUEUE = 1;
    protected static final int BACKGROUND_QUEUE = 2;
    private static WmiTaskMonitor theMonitor = null;
    private static Vector safeReadOnlyCommands = new Vector();
    private WmiBackgroundTaskRunner backgroundTaskRunner = new WmiBackgroundTaskRunner();
    private Vector statusListeners;
    protected WmiCommandQueue foregroundCmdQueue;
    protected WmiCommandQueue backgroundCmdQueue;

    public static WmiTaskMonitor getInstance() {
        if (theMonitor == null) {
            theMonitor = new WmiTaskMonitor();
        }
        return theMonitor;
    }

    public static void registerSafeReadOnlyCommand(String commandName) {
        safeReadOnlyCommands.add(commandName);
    }

    public static boolean isSafeReadOnlyCommand(WmiCommand cmd) {
        return safeReadOnlyCommands.contains(cmd.getName());
    }

    private WmiTaskMonitor() {
        this.backgroundTaskRunner.start();
        this.statusListeners = new Vector();
        this.foregroundCmdQueue = new WmiCommandQueue();
        this.backgroundCmdQueue = new WmiCommandQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(WmiCommand cmd, ActionEvent event) {
        int cmdStatus = 0;
        int queueLoaded = this.loadCommand(cmd, event);
        if (queueLoaded != 0) {
            WmiCommandQueue queue = this.queueForType(queueLoaded);
            if (queueLoaded == 1) {
                if (!queue.isTaskExecuting()) {
                    this.performCommand(1);
                    cmdStatus = 1;
                } else {
                    cmdStatus = 3;
                }
            } else {
                WmiBackgroundTaskRunner wmiBackgroundTaskRunner = this.backgroundTaskRunner;
                synchronized (wmiBackgroundTaskRunner) {
                    this.backgroundTaskRunner.notify();
                }
                cmdStatus = 3;
            }
        }
        if (cmdStatus == 0) {
            Toolkit.getDefaultToolkit().beep();
        }
        return cmdStatus;
    }

    private WmiCommandQueue queueForType(int type) {
        WmiCommandQueue theQueue = null;
        if (type == 1) {
            theQueue = this.foregroundCmdQueue;
        } else if (type == 2) {
            theQueue = this.backgroundCmdQueue;
        }
        return theQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int queueCommand(WmiCommand cmd, ActionEvent evt, Object originalSource) {
        WmiCommandQueue queue;
        int queueLoaded = 1;
        if (cmd.isBackgroundTask()) {
            queueLoaded = 2;
        }
        WmiCommandQueue wmiCommandQueue = queue = this.queueForType(queueLoaded);
        synchronized (wmiCommandQueue) {
            WmiTask queueCmd = new WmiTask(cmd, evt, originalSource);
            queue.add(queueCmd);
        }
        return queueLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmiTask startNextCommand(int queueType) {
        WmiTask cmd = null;
        WmiCommandQueue queue = this.queueForType(queueType);
        if (queue != null) {
            WmiCommandQueue wmiCommandQueue = queue;
            synchronized (wmiCommandQueue) {
                if (queue.size() > 0) {
                    cmd = (WmiTask)queue.get(0);
                    queue.setTaskExecuting(true);
                }
            }
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WmiTask finishActiveCommand(int type) {
        WmiTask cmd = null;
        WmiCommandQueue queue = this.queueForType(type);
        if (queue != null) {
            WmiCommandQueue wmiCommandQueue = queue;
            synchronized (wmiCommandQueue) {
                if (queue.size() > 0) {
                    cmd = (WmiTask)queue.get(0);
                    if (cmd.getEvent().getSource() == null || !cmd.getEvent().getSource().equals(cmd.getOriginalSource())) {
                        cmd.getEvent().setSource(cmd.getOriginalSource());
                    }
                    queue.remove(0);
                    queue.setTaskExecuting(false);
                }
            }
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getQueuedCommandCount(int type) {
        int queueSize = -1;
        WmiCommandQueue queue = this.queueForType(type);
        if (queue != null) {
            WmiCommandQueue wmiCommandQueue = queue;
            synchronized (wmiCommandQueue) {
                queueSize = queue.size();
            }
        }
        return queueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCommand(WmiCommand theCommand, ActionEvent theEvent) {
        WmiCommandQueue queue;
        int queueLoaded = 0;
        boolean canLoadCommand = false;
        WmiCommandQueue wmiCommandQueue = queue = this.queueForType(1);
        synchronized (wmiCommandQueue) {
            if (queue.isTaskExecuting()) {
                WmiTask cmd = (WmiTask)queue.get(0);
                if (cmd != null && cmd.getCommand().canQueue(theCommand.getName())) {
                    canLoadCommand = true;
                }
            } else {
                canLoadCommand = true;
            }
            if (canLoadCommand) {
                Object originalSource = theEvent.getSource();
                ArrayList views = new ArrayList();
                WmiCommand.getViews(theEvent, views);
                if (views.isEmpty()) {
                    WmiMathDocumentView docView = WmiMathDocumentView.getActiveDocumentView();
                    theEvent.setSource(docView);
                }
                queueLoaded = this.queueCommand(theCommand, theEvent, originalSource);
            }
        }
        return queueLoaded;
    }

    /*
     * Loose catch block
     */
    public void performCommand(int queueType) {
        WmiTask cmd = null;
        while ((cmd = this.startNextCommand(queueType)) != null) {
            block26: {
                WmiMathDocumentModel taskModel;
                boolean readLockAcquired;
                block24: {
                    WmiCommand taskCommand = cmd.getCommand();
                    ActionEvent taskEvent = cmd.getEvent();
                    this.notifyTaskStart(cmd);
                    readLockAcquired = false;
                    boolean writeLockAcquired = false;
                    ArrayList allViews = new ArrayList();
                    WmiCommand.getViews(taskEvent, allViews);
                    WmiView taskView = null;
                    if (!allViews.isEmpty()) {
                        taskView = (WmiView)allViews.get(0);
                    }
                    WmiModel tempModel = taskView != null ? taskView.getModel() : null;
                    taskModel = tempModel != null ? tempModel.getDocument() : null;
                    try {
                        boolean noModelValid = taskModel != null || taskCommand.lockTypeRequired() == -1;
                        boolean readOnly = taskModel != null ? taskModel.isReadOnly() : false;
                        boolean readOnlyValid = !readOnly || taskCommand.lockTypeRequired() == -1 || taskCommand.lockTypeRequired() == 0 || WmiTaskMonitor.isSafeReadOnlyCommand(taskCommand);
                        boolean isTaskBrowseCase = taskCommand.getName().equals("Tools.Task.TaskBrowse");
                        if ((isTaskBrowseCase || noModelValid) && readOnlyValid) {
                            if (taskCommand.lockTypeRequired() == 1) {
                                writeLockAcquired = WmiModelLock.writeLock(taskModel, true);
                            } else if (taskCommand.lockTypeRequired() == 0) {
                                readLockAcquired = WmiModelLock.readLock(taskModel, true);
                            }
                            taskCommand.doCommand(taskEvent);
                        }
                    }
                    catch (WmiNoReadAccessException nraE) {
                        WmiErrorLog.log(nraE);
                        if (writeLockAcquired) {
                            WmiModelLock.writeUnlock(taskModel);
                        } else if (readLockAcquired) {
                            WmiModelLock.readUnlock(taskModel);
                        }
                        this.notifyTaskCompletion(cmd);
                        this.finishActiveCommand(queueType);
                        continue;
                    }
                    catch (WmiNoWriteAccessException nwaE) {
                        WmiErrorLog.log(nwaE);
                        continue;
                    }
                    catch (RuntimeException runE) {
                        block25: {
                            block23: {
                                WmiErrorLog.log(runE);
                                if (!writeLockAcquired) break block23;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                WmiModelLock.writeUnlock(taskModel);
                                break block25;
                            }
                            if (readLockAcquired) {
                                WmiModelLock.readUnlock(taskModel);
                            }
                        }
                        this.notifyTaskCompletion(cmd);
                        this.finishActiveCommand(queueType);
                        continue;
                    }
                    {
                        finally {
                            if (writeLockAcquired) {
                                WmiModelLock.writeUnlock(taskModel);
                            } else if (readLockAcquired) {
                                WmiModelLock.readUnlock(taskModel);
                            }
                            this.notifyTaskCompletion(cmd);
                            this.finishActiveCommand(queueType);
                        }
                    }
                    if (!writeLockAcquired) break block24;
                    WmiModelLock.writeUnlock(taskModel);
                    break block26;
                }
                if (readLockAcquired) {
                    WmiModelLock.readUnlock(taskModel);
                }
            }
            this.notifyTaskCompletion(cmd);
            this.finishActiveCommand(queueType);
        }
    }

    public void addStatusListener(WmiStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(WmiStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    protected void notifyTaskStart(WmiTask task) {
        int i = 0;
        while (i < this.statusListeners.size()) {
            WmiStatusListener listener = (WmiStatusListener)this.statusListeners.get(i);
            if (listener != null) {
                listener.processTaskStart(task);
            }
            ++i;
        }
    }

    protected void notifyTaskCompletion(WmiTask task) {
        int i = 0;
        while (i < this.statusListeners.size()) {
            WmiStatusListener listener = (WmiStatusListener)this.statusListeners.get(i);
            if (listener != null) {
                listener.processTaskCompletion(task);
            }
            ++i;
        }
    }

    private class WmiBackgroundTaskRunner
    extends Thread {
        private WmiBackgroundTaskRunner() {
            super("WMI:Background Task Runner");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean running = true;
            while (running) {
                try {
                    WmiBackgroundTaskRunner wmiBackgroundTaskRunner = this;
                    synchronized (wmiBackgroundTaskRunner) {
                        this.wait();
                    }
                }
                catch (InterruptedException ie) {
                    running = false;
                }
                if (!running) continue;
                WmiTaskMonitor.this.performCommand(2);
            }
        }
    }

    private static class WmiCommandQueue
    extends ArrayList {
        private boolean taskExecuting = false;

        private WmiCommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTaskExecuting(boolean executing) {
            WmiCommandQueue wmiCommandQueue = this;
            synchronized (wmiCommandQueue) {
                this.taskExecuting = executing;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isTaskExecuting() {
            boolean isExecuting = false;
            WmiCommandQueue wmiCommandQueue = this;
            synchronized (wmiCommandQueue) {
                isExecuting = this.taskExecuting;
            }
            return isExecuting;
        }
    }
}

