/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiTextKeyListener;
import com.maplesoft.mathdoc.controller.WmiTextMouseListener;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;

public class WmiTextController
implements WmiController {
    private WmiTextMouseListener mouseListener = null;
    private KeyListener keyListener = this.createKeyListener();

    public WmiTextController() {
        this.mouseListener = this.createMouseListener();
    }

    protected KeyListener createKeyListener() {
        return new WmiTextKeyListener();
    }

    protected WmiTextMouseListener createMouseListener() {
        return new WmiTextMouseListener();
    }

    @Override
    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this.mouseListener;
    }

    public static void updateSelection(WmiTraversableView view, int offset) throws WmiNoReadAccessException {
        WmiMathDocumentView docView = view.getDocumentView();
        if (docView != null) {
            WmiViewFactory factory = docView.getViewFactory();
            if (factory != null) {
                factory.updateSelection(view, offset);
            }
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            try {
                WmiHighlightPainter painter;
                WmiModelLock.readLock(docModel, true);
                WmiSelection selection = docView.getSelection();
                WmiHighlightPainter wmiHighlightPainter = painter = selection != null ? selection.getSelectionHighlighter() : null;
                if (painter != null) {
                    Rectangle bounds = painter.getBounds();
                    if (bounds.width <= 1) {
                        docView.setSelection(null);
                        view.setPositionMarker(offset);
                    }
                }
            }
            finally {
                WmiModelLock.readUnlock(docModel);
            }
        }
    }

    public static void resetSelection(WmiView view) {
        WmiModel model = null;
        try {
            model = view.getModel();
            WmiModelLock.readLock(model, true);
            WmiMathDocumentView docView = view.getDocumentView();
            docView.setSelection(null);
            docView.repaint();
        }
        finally {
            WmiModelLock.readUnlock(model);
        }
    }

    @Override
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }
}

