/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiDefaultKeyListener;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.view.WmiAbstractInlineWrapperView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

public class WmiTextKeyListener
extends WmiDefaultKeyListener {
    @Override
    protected boolean processChar(KeyEvent event, WmiView view) {
        WmiSelection selection;
        WmiCaret caret;
        boolean editable;
        WmiMathDocumentView docView;
        boolean success;
        block9: {
            success = false;
            WmiModel model = view.getModel();
            docView = null;
            editable = false;
            caret = null;
            selection = null;
            if (WmiModelLock.readLock(model, true)) {
                try {
                    try {
                        docView = view.getDocumentView();
                        caret = docView != null ? docView.getCaret() : null;
                        selection = docView != null ? docView.getSelection() : null;
                        boolean bl = editable = caret == null || !caret.isReadOnly();
                        if (selection != null) {
                            boolean bl2 = editable = !selection.isReadOnly();
                        }
                        if (caret != null) {
                            view = this.updateCaretBias(caret, view, event);
                        }
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.readUnlock(model);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    WmiModelLock.readUnlock(model);
                    throw throwable;
                }
                WmiModelLock.readUnlock(model);
            }
        }
        if (!(caret == null && selection == null || selection == null && view != caret.getView())) {
            this.finalKeyDispatch(event, view, caret, selection, editable);
            docView.saveLastHorizontalPosition();
            success = true;
        }
        return success;
    }

    protected boolean finalKeyDispatch(KeyEvent event, WmiView view, WmiCaret caret, WmiSelection selection, boolean editable) {
        boolean success = true;
        int offset = caret != null ? caret.getOffset() : 0;
        char ch = event.getKeyChar();
        if (ch == '\u007f') {
            WmiCommand.invokeCommand("edit.delete");
        } else if (ch == '\b') {
            WmiCommand.invokeCommand("edit.backspace");
        } else if (editable && ch == '\n') {
            if (selection == null) {
                if (event.isShiftDown()) {
                    ((WmiTextView)view).insertChar(ch, offset);
                } else {
                    this.splitParagraph((WmiTextView)view, offset);
                }
            }
        } else if (editable) {
            if (selection == null) {
                ((WmiTextView)view).insertChar(ch, offset);
            } else {
                this.replaceSelection(selection, ch);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        event.consume();
        return success;
    }

    private void replaceSelection(WmiSelection selection, char ch) {
        selection.replaceSelection(Character.toString(ch));
    }

    /*
     * Exception decompiling
     */
    private void splitParagraph(WmiTextView view, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private WmiModel splitParagraphBefore(WmiParagraphModel oldParagraph, WmiParagraphModel newParagraph, int index) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel grandparent = oldParagraph.getParent();
        int parentIndex = grandparent.indexOf(oldParagraph);
        if (parentIndex >= 0) {
            int size = oldParagraph.getChildCount();
            int i = index;
            while (i < size) {
                newParagraph.appendChild(oldParagraph.getChild(i));
                ++i;
            }
            oldParagraph.removeChildren(index, size - index);
            grandparent.addChild(newParagraph, parentIndex + 1);
        }
        return newParagraph.getChild(0);
    }

    private WmiModel splitParagraphAfter(WmiParagraphModel oldParagraph, WmiParagraphModel newParagraph, int index) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return this.splitParagraphBefore(oldParagraph, newParagraph, index + 1);
    }

    private WmiView updateCaretBias(WmiCaret caret, WmiView view, KeyEvent event) throws WmiNoReadAccessException {
        WmiView finalView = view;
        if (caret != null) {
            WmiTextView textview = (WmiTextView)finalView;
            int offSet = caret.getOffset();
            boolean rightend = textview.getEndOffset() - textview.getStartOffset() == offSet;
            boolean leftend = offSet == 0;
            char ch = event.getKeyChar();
            if (rightend && ch == '\u007f') {
                WmiPositionedView nextView = this.getRightView(textview);
                if (nextView != null && ch == '\u007f') {
                    nextView.setPositionMarker(0);
                }
            } else if (leftend) {
                WmiPositionedView nextView = this.getLeftView(textview);
                if (ch == '\b') {
                    if (nextView instanceof WmiTextView) {
                        WmiTextView textView = (WmiTextView)nextView;
                        int offset = textView.getEndOffset() - textView.getStartOffset();
                        nextView.setPositionMarker(offset);
                    } else if (nextView instanceof WmiAbstractInlineWrapperView) {
                        WmiAbstractInlineWrapperView aiv = (WmiAbstractInlineWrapperView)nextView;
                        if (aiv.stepInto()) {
                            WmiViewPosition finalPosition = aiv.getFinalPosition();
                            finalPosition.getView().setPositionMarker(finalPosition.getOffset());
                        }
                    } else if (nextView != null) {
                        while (nextView instanceof WmiCompositeView) {
                            WmiCompositeView comp;
                            int size;
                            if (WmiViewUtil.isTraversableView(nextView) || (size = (comp = (WmiCompositeView)((Object)nextView)).getChildCount()) <= 0) break;
                            nextView = (WmiPositionedView)comp.getChild(size - 1);
                        }
                        nextView.setPositionMarker(-1);
                    }
                } else if (ch != '\u007f' && ch != '\n' && nextView instanceof WmiTextView) {
                    WmiTextView textView = (WmiTextView)nextView;
                    int offset = textView.getEndOffset() - textView.getStartOffset();
                    Point rightViewPoint = WmiViewUtil.getAbsoluteOffset(textview);
                    Point leftViewPoint = WmiViewUtil.getAbsoluteOffset(nextView);
                    int leftY = leftViewPoint.y;
                    int rightY = rightViewPoint.y;
                    if (leftY == rightY) {
                        nextView.setPositionMarker(offset);
                    }
                }
            }
            finalView = caret.getView() != null ? caret.getView() : view;
        }
        return finalView;
    }

    protected WmiPositionedView getLeftView(WmiTextView view) {
        return view.getNextView(2);
    }

    protected WmiPositionedView getRightView(WmiTextView view) {
        return view.getNextView(3);
    }
}

