/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.controller.WmiTextController;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

public class WmiTextMouseListener
extends WmiMouseInputAdapter {
    private static final String SELECT_PARAGRAPH = "select.paragraph";
    private static final String SELECT_WORD = "select.word";

    @Override
    public void mousePressed(MouseEvent event) {
        Point pt = event.getPoint();
        Object source = event.getSource();
        if (source instanceof WmiTextView) {
            WmiTextView view = (WmiTextView)source;
            WmiModel model = view.getModel();
            int offset = 0;
            boolean locked = false;
            try {
                try {
                    locked = WmiModelLock.readLock(model, false);
                    if (locked) {
                        offset = view.getOffset(pt);
                        boolean shiftDown = event.isShiftDown();
                        WmiMathDocumentView docView = view.getDocumentView();
                        if (shiftDown) {
                            WmiTextController.updateSelection(view, offset);
                            event.consume();
                        } else {
                            WmiSelection docSelection = docView != null ? docView.getSelection() : null;
                            view.setPositionMarker(offset);
                            if (docView != null && docSelection != null) {
                                if (event.getButton() == 1) {
                                    docView.setSelection(null);
                                    docView.repaint();
                                } else if (WmiTextMouseListener.isPopupTrigger(event) && !docSelection.contains(view, offset)) {
                                    docView.setSelection(null);
                                    docView.repaint();
                                }
                            }
                            if (!WmiTextMouseListener.isPopupTrigger(event)) {
                                event.consume();
                            }
                        }
                        docView.saveLastHorizontalPosition();
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (locked) {
                        WmiModelLock.readUnlock(model);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(model);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getButton() == 1) {
            int count = event.getClickCount();
            if (count == 2) {
                Object source = event.getSource();
                if (source instanceof WmiTextView) {
                    this.selectWord((WmiTextView)source);
                }
                event.consume();
            } else if (count == 3) {
                Object source = event.getSource();
                if (source instanceof WmiTextView) {
                    this.selectParagraph((WmiTextView)source);
                }
                event.consume();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (event.getButton() == 1 || event.getButton() == 0) {
            block11: {
                Point pt = event.getPoint();
                Object source = event.getSource();
                if (source instanceof WmiTextView) {
                    WmiTextView view = (WmiTextView)source;
                    WmiModel model = view.getModel();
                    int offset = 0;
                    boolean locked = false;
                    try {
                        try {
                            locked = WmiModelLock.readLock(model, false);
                            if (locked) {
                                offset = view.getOffset(pt);
                                WmiTextController.updateSelection(view, offset);
                            }
                        }
                        catch (WmiNoReadAccessException e) {
                            WmiErrorLog.log(e);
                            if (locked) {
                                WmiModelLock.readUnlock(model);
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (locked) {
                            WmiModelLock.readUnlock(model);
                        }
                        throw throwable;
                    }
                    if (locked) {
                        WmiModelLock.readUnlock(model);
                    }
                }
            }
            event.consume();
        }
    }

    private void selectParagraph(WmiTextView view) {
        WmiCommandProxy command = WmiCommand.getCommandProxy(SELECT_PARAGRAPH);
        ActionEvent event = new ActionEvent(view, 0, null);
        if (command != null) {
            command.actionPerformed(event);
        }
    }

    private void selectWord(WmiTextView view) {
        WmiCommandProxy command = WmiCommand.getCommandProxy(SELECT_WORD);
        ActionEvent event = new ActionEvent(view, 0, null);
        if (command != null) {
            command.actionPerformed(event);
        }
    }
}

