/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.util.ArrayList;
import java.util.HashSet;

public class WmiMathDeleteUtil {
    private static HashSet PROMOTABLE_MODELS = new HashSet();

    static {
        PROMOTABLE_MODELS.add(WmiModelTag.MATH_SQUARE_ROOT);
        PROMOTABLE_MODELS.add(WmiModelTag.MATH_NROOT);
    }

    private WmiMathDeleteUtil() {
    }

    public static boolean isMathSelectionDelete(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiCompositeModel endWrapper;
        WmiCompositeModel startWrapper;
        boolean found = false;
        WmiSelection selection = docView.getSelection();
        WmiModel[] selectionBounds = null;
        int[] selectionOffsets = null;
        if (selection != null && selection.getModelInterval(selectionBounds = new WmiModel[2], selectionOffsets = new int[2]) && (startWrapper = WmiModelUtil.findAncestorOfTag(selectionBounds[0], WmiModelTag.MATH)) == (endWrapper = WmiModelUtil.findAncestorOfTag(selectionBounds[1], WmiModelTag.MATH)) && startWrapper != null) {
            found = true;
        }
        return found;
    }

    /*
     * Loose catch block
     */
    public static boolean deleteMathSelection(WmiMathDocumentView docView, String undo) throws WmiNoReadAccessException {
        boolean success = false;
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        try {
            try {
                WmiModelPosition pos;
                WmiModelLock.writeLock(docModel, true);
                WmiSelection selection = docView.getSelection();
                WmiModel[] models = new WmiModel[2];
                int[] offsets = new int[2];
                selection.getModelInterval(models, offsets);
                boolean deleteEnabled = true;
                if (!(models[0] == null || models[1] == null || docModel.isMutableModel(models[0]) && docModel.isMutableModel(models[1]))) {
                    deleteEnabled = false;
                }
                if (deleteEnabled && models[0] == models[1] && models[0] instanceof WmiTextModel) {
                    if (offsets[1] > offsets[0]) {
                        WmiTextModel text = (WmiTextModel)models[0];
                        text.deleteText(offsets[0], offsets[1] - offsets[0]);
                        WmiModelPosition pos2 = MathTokenizer.retokenize(text, offsets[0]);
                        docView.setPendingPosition(pos2);
                        docModel.update(undo);
                        success = true;
                    }
                } else if (deleteEnabled && !WmiMathDeleteUtil.isMultiTableCellDelete(models) && (pos = MathInsertUtil.wrapSelection(docView)) != null) {
                    int index;
                    WmiModel model = pos.getModel();
                    WmiCompositeModel parent = model.getParent();
                    int n = index = parent != null ? parent.indexOf(model) : -1;
                    if (index >= 0) {
                        WmiFontAttributeSet activeAttr = docModel.getActiveEditAttributes();
                        if (activeAttr != null) {
                            activeAttr = (WmiFontAttributeSet)activeAttr.copyAttributes();
                        }
                        WmiTextModel placeholder = new WmiTextModel(docModel, "", activeAttr);
                        parent.replaceChild(placeholder, index);
                        pos = MathTokenizer.retokenize(placeholder, 0);
                        docView.setPendingPosition(pos);
                    }
                    docModel.update(undo);
                    success = true;
                }
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(docModel);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(docModel);
            }
            catch (WmiNoUpdateAccessException e) {
                WmiErrorLog.log(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                WmiModelLock.writeUnlock(docModel);
            }
        }
        finally {
            WmiModelLock.writeUnlock(docModel);
        }
        return success;
    }

    public static boolean isMathDelete(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiMathDocumentModel docModel;
        WmiModel model;
        boolean found = false;
        WmiSelection selection = docView.getSelection();
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiPositionedView view = marker != null ? marker.getView() : null;
        WmiModel wmiModel = model = view != null ? view.getModel() : null;
        if (model != null && selection == null && (docModel = model.getDocument()).isMutableModel(model)) {
            boolean bl = found = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH) != null;
            if (found) {
                found = !WmiMathDeleteUtil.isEmptyMath(model);
            }
        }
        return found;
    }

    public static boolean isEmptyMath(WmiModel model) throws WmiNoReadAccessException {
        boolean isEmpty = false;
        if (model != null) {
            WmiCompositeModel wrapper = null;
            wrapper = model.getTag() == WmiModelTag.MATH ? (WmiCompositeModel)model : WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH);
            isEmpty = wrapper != null ? !WmiMathDeleteUtil.hasContent(wrapper) : true;
        }
        return isEmpty;
    }

    private static boolean hasContent(WmiCompositeModel model) throws WmiNoReadAccessException {
        boolean found = false;
        int size = model != null ? model.getChildCount() : 0;
        int i = 0;
        while (i < size) {
            WmiModel child = model.getChild(i);
            if (child != null && child.getTag() == WmiModelTag.MATH_ROW) {
                found = WmiMathDeleteUtil.hasContent((WmiCompositeModel)child);
            } else if (child instanceof WmiTextModel) {
                if (((WmiTextModel)child).getLength() > 0) {
                    found = true;
                }
            } else {
                found = true;
            }
            if (found) break;
            ++i;
        }
        return found;
    }

    public static boolean deleteInMath(WmiMathDocumentView docView, String undo, int direction) throws WmiNoReadAccessException {
        boolean success = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiPositionedView view = marker != null ? marker.getView() : null;
        WmiModel model = view != null ? view.getModel() : null;
        WmiSelection selection = docView.getSelection();
        if (model != null && selection == null) {
            int bias;
            int offset = marker.getOffset();
            if (view instanceof WmiTextView && offset >= 0) {
                offset += ((WmiTextView)view).getStartOffset();
            }
            WmiModelPosition pos = new WmiModelPosition(model, offset);
            int n = bias = direction > 0 ? 1 : -1;
            if (bias == 1 || !MathTokenizer.isLinebreakingMSpace(model)) {
                pos = MathInsertUtil.updateInsertionPoint(pos, bias);
            }
            if (pos != null) {
                model = pos.getModel();
                WmiCompositeModel parentPhantom = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH_PHANTOM);
                if (parentPhantom != null) {
                    pos = new WmiModelPosition(parentPhantom, 0);
                }
                pos = WmiMathDeleteUtil.expandMathFences(pos, direction);
                success = WmiMathDeleteUtil.deleteInMath(docView, pos = WmiMathDeleteUtil.expandMathString(pos, direction), true, direction);
                if (success) {
                    WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
                    WmiModelLock.writeLock(docModel, true);
                    try {
                        try {
                            docModel.update(undo);
                        }
                        catch (WmiNoUpdateAccessException e) {
                            WmiErrorLog.log(e);
                            WmiModelLock.writeUnlock(docModel);
                        }
                    }
                    finally {
                        WmiModelLock.writeUnlock(docModel);
                    }
                }
            }
        }
        return success;
    }

    private static boolean isMultiTableCellDelete(WmiModel[] models) throws WmiNoReadAccessException {
        boolean multicell = false;
        WmiCompositeModel parentCell = WmiModelUtil.findAncestorOfTag(models[0], WmiModelTag.MATH_TABLE_CELL);
        WmiCompositeModel secondCell = WmiModelUtil.findAncestorOfTag(models[1], WmiModelTag.MATH_TABLE_CELL);
        multicell = secondCell != parentCell;
        return multicell;
    }

    private static boolean deleteInMath(WmiMathDocumentView docView, WmiModelPosition pos, boolean retry, int direction) throws WmiNoReadAccessException {
        WmiMathDocumentModel doc;
        boolean success = false;
        WmiModel model = pos.getModel();
        int offset = pos.getOffset();
        WmiMathDocumentModel wmiMathDocumentModel = doc = model != null ? model.getDocument() : null;
        if (doc == null) {
            return false;
        }
        try {
            try {
                WmiModelLock.writeLock(doc, true);
                if (model instanceof WmiMathPhantomModel) {
                    success = WmiMathDeleteUtil.deleteModel(docView, model, direction);
                } else if (model instanceof WmiMathSpaceModel) {
                    success = WmiMathDeleteUtil.deleteModel(docView, model, direction);
                } else if (!(model instanceof WmiMathModel)) {
                    success = WmiMathDeleteUtil.deleteModel(docView, model, direction);
                } else if (model instanceof WmiTextModel) {
                    WmiTextModel textModel = (WmiTextModel)model;
                    success = WmiMathDeleteUtil.deleteInMathText(docView, textModel, offset, retry, direction);
                } else if (model instanceof WmiRootModel && offset == 0) {
                    success = WmiMathDeleteUtil.deleteMathRootModel(docView, model, direction);
                } else if (model.getTag() == WmiModelTag.MATH_ROW) {
                    WmiModel child;
                    WmiInlineMathModel inline = (WmiInlineMathModel)model;
                    int size = inline.getChildCount();
                    boolean deleteInline = false;
                    if (size == 0) {
                        deleteInline = true;
                    } else if (size == 1 && (child = inline.getChild(0)) instanceof WmiTextModel && ((WmiTextModel)child).getLength() == 0) {
                        deleteInline = true;
                    }
                    if (deleteInline) {
                        success = WmiMathDeleteUtil.deleteModel(docView, inline, direction);
                    } else {
                        if (offset == 0) {
                            pos = new WmiModelPosition(inline.getChild(0), 0);
                        } else if (offset == -1) {
                            pos = new WmiModelPosition(inline.getChild(inline.getChildCount() - 1), -1);
                        } else {
                            retry = false;
                        }
                        if (retry) {
                            pos = WmiMathDeleteUtil.expandMathFences(pos, direction);
                            pos = WmiMathDeleteUtil.expandMathString(pos, direction);
                            success = WmiMathDeleteUtil.deleteInMath(docView, pos, true, direction);
                        }
                    }
                } else if (model instanceof WmiMathMultiscriptModel) {
                    int leftModelIndex = 0;
                    int rightModelIndex = 0;
                    boolean scanRight = true;
                    WmiMathMultiscriptModel multi = (WmiMathMultiscriptModel)model;
                    int size = multi.getChildCount();
                    int i = 1;
                    while (i < size) {
                        WmiModel child = multi.getChild(i);
                        if (!(child instanceof WmiMathMultiscriptModel.WmiMathNoneModel)) {
                            if (child instanceof WmiMathMultiscriptModel.WmiMathPrescriptModel) {
                                scanRight = false;
                            } else if (scanRight) {
                                rightModelIndex = i;
                            } else {
                                leftModelIndex = i;
                                break;
                            }
                        }
                        ++i;
                    }
                    model = offset == 0 ? multi.getChild(leftModelIndex) : multi.getChild(rightModelIndex);
                    pos = new WmiModelPosition(model, offset);
                    success = WmiMathDeleteUtil.deleteInMath(docView, pos, true, direction);
                } else {
                    WmiModel lastModel = null;
                    while (model instanceof WmiCompositeModel) {
                        if (model == lastModel) {
                            WmiCompositeModel parent = model.getParent();
                            if (!(parent instanceof WmiMathFencedModel) || parent.getChildCount() <= 1 && model instanceof WmiInlineMathModel) break;
                            ((WmiMathFencedModel)parent).convertToInlineMath(4);
                            pos = MathInsertUtil.updateInsertionPoint(pos, direction < 0 ? -1 : 1);
                            success = WmiMathDeleteUtil.deleteInMath(docView, pos, retry, direction);
                            break;
                        }
                        lastModel = model;
                        WmiCompositeModel comp = (WmiCompositeModel)model;
                        if (comp instanceof WmiMathPhantomModel) {
                            success = WmiMathDeleteUtil.deleteModel(docView, comp, direction);
                            break;
                        }
                        if (comp instanceof WmiMathFencedModel) {
                            pos = new WmiModelPosition(comp, offset);
                            pos = WmiMathDeleteUtil.expandMathFences(pos, direction);
                            pos = WmiMathDeleteUtil.expandMathString(pos, direction);
                            model = pos.getModel();
                            continue;
                        }
                        int size = comp.getChildCount();
                        if (offset == 0) {
                            model = size > 0 ? comp.getChild(0) : null;
                            continue;
                        }
                        model = size > 0 ? comp.getChild(size - 1) : null;
                        offset = -1;
                    }
                    if (model instanceof WmiTextModel) {
                        WmiTextModel textModel = (WmiTextModel)model;
                        offset = direction > 0 ? 0 : textModel.getLength();
                        success = WmiMathDeleteUtil.deleteInMathText(docView, textModel, offset, true, direction);
                    }
                }
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(doc);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(doc);
            }
        }
        finally {
            WmiModelLock.writeUnlock(doc);
        }
        return success;
    }

    private static boolean deleteModel(WmiMathDocumentView docView, WmiModel model, int direction) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean success = false;
        WmiCompositeModel parent = model.getParent();
        WmiCompositeModel grandparent = parent != null ? parent.getParent() : null;
        int index = parent != null ? parent.indexOf(model) : -1;
        int parentIndex = grandparent != null ? grandparent.indexOf(parent) : -1;
        WmiModel reposModel = null;
        int reposOffset = direction < 0 ? -1 : 0;
        boolean tableCellDeletion = false;
        if (parent instanceof WmiMathTableModel.WmiMathTableDataModel) {
            tableCellDeletion = true;
            success = WmiMathDeleteUtil.deleteMathTableCell(docView, (WmiMathTableModel.WmiMathTableDataModel)parent, direction);
        }
        if (parent != null && parent.getTag() != WmiModelTag.MATH) {
            if (!tableCellDeletion) {
                boolean deleteParent;
                WmiModel[] replacements = WmiMathDeleteUtil.getChildrenToPromote(parent, index);
                if (parent.getDeleteHandler() != null) {
                    if (replacements != null) {
                        parent.addChildren(replacements, index + 1);
                        replacements = null;
                    }
                    WmiDeletePlaceholderModel placeholder = new WmiDeletePlaceholderModel(model);
                    parent.replaceChild(placeholder, index);
                }
                boolean bl = deleteParent = replacements == null;
                if (deleteParent) {
                    int i = 0;
                    while (i < parent.getChildCount()) {
                        WmiModel child;
                        if (i != index && (child = parent.getChild(i)).getTag() != WmiModelTag.MATH_PHANTOM) {
                            deleteParent = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (deleteParent) {
                    success = WmiMathDeleteUtil.deleteModel(docView, parent, direction);
                    reposModel = null;
                } else if (parent.getDeleteHandler() == null) {
                    int size = parent.getChildCount();
                    parent.removeChild(index);
                    if (replacements != null) {
                        parent.addChildren(replacements, index);
                    }
                    if (reposOffset < 0 && --index < 0) {
                        index = 0;
                        reposOffset = 0;
                    }
                    if (replacements != null && replacements.length > 0) {
                        reposOffset = 0;
                        reposModel = null;
                    } else if (size > index + 1) {
                        reposModel = parent.getChild(index);
                    } else if (size > 1) {
                        reposModel = parent.getChild(size - 2);
                    }
                    success = true;
                } else {
                    WmiDeleteManager manager = new WmiDeleteManager();
                    manager.mark(parent);
                    manager.update();
                    if (grandparent != null) {
                        reposModel = grandparent.getChild(parentIndex);
                        if (direction > 0) {
                            WmiModelTag parentTag = parent.getTag();
                            if (index != 0 && (parentTag == WmiModelTag.MATH_FRAC || parentTag == WmiModelTag.MATH_SUPERSCRIPT || parentTag == WmiModelTag.MATH_SUBSCRIPT || parentTag == WmiModelTag.MATH_SUB_SUP)) {
                                reposOffset = -1;
                            }
                        }
                    }
                    success = true;
                }
            }
            if (reposModel != null) {
                if (direction < 0) {
                    if (reposModel instanceof WmiTextModel) {
                        reposOffset = ((WmiTextModel)reposModel).getLength();
                    }
                    docView.setPendingPosition(new WmiModelPosition(reposModel, reposOffset));
                } else {
                    docView.setPendingPosition(new WmiModelPosition(reposModel, 0));
                }
            }
        }
        return success;
    }

    private static boolean deleteMathRootModel(WmiMathDocumentView docView, WmiModel model, int direction) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean success;
        WmiCompositeModel parent = model.getParent();
        int index = parent.indexOf(model);
        WmiTextModel destText = null;
        int destOffset = 0;
        if (index > 0) {
            WmiModel leftSibling = parent.getChild(index - 1);
            if (leftSibling instanceof WmiTextModel) {
                destText = (WmiTextModel)leftSibling;
                destOffset = -1;
            } else if (leftSibling != null) {
                destText = (WmiTextModel)WmiModelUtil.findFirstDescendantOfClass(leftSibling, WmiTextModel.class);
                destOffset = -1;
            }
        }
        if (destText == null) {
            destText = (WmiTextModel)WmiModelUtil.findFirstDescendantOfClass(model, WmiTextModel.class);
        }
        if ((success = WmiMathDeleteUtil.deleteModel(docView, model, direction)) && destText != null) {
            WmiModelPosition newCaretPosition = MathTokenizer.retokenize(destText, destOffset);
            docView.setPendingPosition(newCaretPosition);
        }
        return success;
    }

    private static boolean deleteMathTableCell(WmiMathDocumentView docView, WmiMathTableModel.WmiMathTableDataModel cell, int direction) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean success = true;
        boolean emptyRow = cell.isInEmptyRow();
        boolean emptyColumn = cell.isInEmptyColumn();
        WmiMathTableModel table = (WmiMathTableModel)WmiModelUtil.findAncestorOfTag((WmiModel)cell, WmiModelTag.MATH_TABLE);
        WmiMathTableModel.WmiMathTableRowModel row = (WmiMathTableModel.WmiMathTableRowModel)cell.getParent();
        int indexOfDataInRow = row.indexOf(cell);
        int indexOfRowInTable = table.indexOf(row);
        if (emptyColumn && row.getChildCount() > 1 && indexOfDataInRow > 0) {
            int i = 0;
            while (i < table.getChildCount()) {
                WmiMathTableModel.WmiMathTableRowModel rowModel = (WmiMathTableModel.WmiMathTableRowModel)table.getChild(i);
                rowModel.removeChild(indexOfDataInRow);
                ++i;
            }
        }
        if (emptyRow) {
            table.removeChild(indexOfRowInTable);
        }
        WmiModel reposModel = null;
        int reposOffset = 0;
        if (table.getChildCount() == 0) {
            success = WmiMathDeleteUtil.deleteModel(docView, table, direction);
        } else if (direction < 0) {
            if (emptyRow) {
                if (indexOfRowInTable > 0) {
                    reposModel = table.getChild(indexOfRowInTable - 1);
                    reposOffset = -1;
                } else {
                    reposModel = table.getChild(0);
                }
            } else if (indexOfDataInRow > 0) {
                reposModel = row.getChild(indexOfDataInRow - 1);
                reposOffset = -1;
            } else if (indexOfRowInTable > 0) {
                reposModel = table.getChild(indexOfRowInTable - 1);
                reposOffset = -1;
            } else {
                reposModel = table.getChild(0);
            }
        } else {
            int rowLimit = table.getChildCount() - 1;
            if (emptyRow) {
                if (indexOfRowInTable < rowLimit) {
                    reposModel = table.getChild(indexOfRowInTable + 1);
                } else {
                    reposModel = table.getChild(rowLimit);
                    reposOffset = -1;
                }
            } else {
                int columnLimit = row.getChildCount() - 1;
                if (indexOfDataInRow < columnLimit) {
                    reposModel = row.getChild(indexOfDataInRow + 1);
                } else if (indexOfRowInTable < rowLimit) {
                    reposModel = table.getChild(indexOfRowInTable + 1);
                } else {
                    reposModel = table.getChild(rowLimit);
                    reposOffset = -1;
                }
            }
        }
        if (reposModel != null) {
            docView.setPendingPosition(new WmiModelPosition(reposModel, reposOffset));
        }
        return success;
    }

    private static boolean deleteInMathText(WmiMathDocumentView docView, WmiTextModel textModel, int offset, boolean retry, int direction) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMathDocumentModel docModel = textModel.getDocument();
        boolean isImplicitMultiply = false;
        String text = textModel.getAllText();
        if (text.equals(" ")) {
            WmiModel previousModel = WmiModelUtil.findPreviousDescendantLeaf(docModel, textModel);
            WmiModel nextModel = WmiModelUtil.findNextDescendantLeaf(docModel, textModel);
            if (previousModel instanceof WmiNumericModel && nextModel instanceof WmiIdentifierModel) {
                isImplicitMultiply = true;
            }
        }
        boolean success = false;
        int limit = textModel.getLength();
        if (offset < 0) {
            offset = limit;
        }
        if (direction < 0) {
            if (offset > 0) {
                textModel.deleteText(--offset, 1);
                WmiMathDeleteUtil.retokenizeAndReposition(textModel, offset, isImplicitMultiply, docView);
                success = true;
            } else if (retry) {
                WmiModel model = textModel;
                WmiCompositeModel parent = model.getParent();
                while (parent != null && parent.getChildCount() == 1) {
                    model = parent;
                    parent = model.getParent();
                }
                if (parent != null && parent.getTag() == WmiModelTag.MATH_ROW) {
                    WmiModelPosition pos = new WmiModelPosition(textModel, offset);
                    pos = MathInsertUtil.updateInsertionPoint(pos, -1);
                    success = WmiMathDeleteUtil.deleteInMath(docView, pos, false, direction);
                }
            }
        } else if (offset < limit) {
            textModel.deleteText(offset, 1);
            WmiMathDeleteUtil.retokenizeAndReposition(textModel, offset, isImplicitMultiply, docView);
            success = true;
        } else if (retry) {
            WmiModelPosition pos = new WmiModelPosition(textModel, offset);
            pos = MathInsertUtil.updateInsertionPoint(pos, 1);
            success = WmiMathDeleteUtil.deleteInMath(docView, pos, false, direction);
        }
        if (!success && limit == 0) {
            success = WmiMathDeleteUtil.deleteModel(docView, textModel, direction);
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WmiModelPosition expandMathFences(WmiModelPosition pos, int direction) throws WmiNoReadAccessException {
        WmiModel model = pos.getModel();
        int offset = pos.getOffset();
        if (model instanceof WmiMathFencedModel) {
            try {
                try {
                    WmiModelLock.writeLock(model, true);
                    if (offset != 0 && direction < 0) {
                        pos = ((WmiMathFencedModel)model).convertToInlineMath(3);
                        return pos;
                    }
                    if (offset != 0 || direction <= 0) return pos;
                    pos = ((WmiMathFencedModel)model).convertToInlineMath(0);
                    return pos;
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.writeUnlock(model);
                }
                return pos;
            }
            finally {
                WmiModelLock.writeUnlock(model);
            }
        }
        WmiCompositeModel parentFence = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH_FENCED);
        if (parentFence == null) return pos;
        try {
            try {
                WmiModelLock.writeLock(model, true);
                if (offset == 0 && direction < 0) {
                    WmiModel candidate = model;
                    while (candidate != parentFence && candidate != null) {
                        WmiCompositeModel comp = candidate.getParent();
                        if (comp.getChild(0) != candidate) {
                            candidate = null;
                            break;
                        }
                        candidate = comp;
                    }
                    if (candidate == null) return pos;
                    pos = ((WmiMathFencedModel)parentFence).convertToInlineMath(1);
                    return pos;
                }
                boolean scanEndPath = false;
                if (model instanceof WmiTextModel) {
                    int length = ((WmiTextModel)model).getLength();
                    scanEndPath = offset == -1 || offset == length;
                } else {
                    boolean bl = scanEndPath = offset == -1;
                }
                if (!scanEndPath || direction <= 0) return pos;
                WmiModel candidate = model;
                while (candidate != parentFence && candidate != null) {
                    WmiCompositeModel comp = candidate.getParent();
                    if (comp.getChild(comp.getChildCount() - 1) != candidate) {
                        candidate = null;
                        break;
                    }
                    candidate = comp;
                }
                if (candidate == null) return pos;
                pos = ((WmiMathFencedModel)parentFence).convertToInlineMath(2);
                return pos;
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.writeUnlock(model);
            }
            return pos;
        }
        finally {
            WmiModelLock.writeUnlock(model);
        }
    }

    private static WmiModelPosition expandMathString(WmiModelPosition pos, int direction) throws WmiNoReadAccessException {
        WmiModel model = pos.getModel();
        int offset = pos.getOffset();
        if (model instanceof WmiMathStringModel) {
            int size = ((WmiMathStringModel)model).getLength();
            if (direction == 1 && offset == 0 || direction == -1 && offset == 1 || direction == 1 && offset == size - 1 || direction == -1 && offset == -1 || direction == -1 && offset == size) {
                try {
                    try {
                        WmiModelLock.writeLock(model, true);
                        pos = ((WmiMathStringModel)model).convertToIdentifier(offset);
                    }
                    catch (WmiNoWriteAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.writeUnlock(model);
                    }
                }
                finally {
                    WmiModelLock.writeUnlock(model);
                }
            }
        }
        return pos;
    }

    private static void retokenizeAndReposition(WmiTextModel textModel, int offset, boolean isImplicitMultiply, WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition pos = null;
        WmiMathDocumentModel docModel = textModel.getDocument();
        if (!isImplicitMultiply) {
            pos = MathTokenizer.retokenize(textModel, offset);
        } else {
            WmiModel previousModel = WmiModelUtil.findPreviousDescendantLeaf(docModel, textModel);
            pos = new WmiModelPosition(previousModel, -1);
            WmiCompositeModel parent = textModel.getParent();
            int indexInParent = parent.indexOf(textModel);
            parent.removeChild(indexInParent);
            WmiInsertGenericMathCommand.refreshSemantics(parent);
        }
        docView.setPendingPosition(pos);
    }

    private static WmiModel[] getChildrenToPromote(WmiModel fromModel, int atIndex) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] childrenToPromote = null;
        try {
            WmiCompositeModel modelToDelete;
            int kids;
            WmiModelTag indexTag;
            WmiModel indexModel = null;
            if (fromModel instanceof WmiCompositeModel) {
                indexModel = ((WmiCompositeModel)fromModel).getChild(atIndex);
            }
            if (indexModel instanceof WmiCompositeModel && PROMOTABLE_MODELS.contains(indexTag = indexModel.getTag()) && (kids = (modelToDelete = (WmiCompositeModel)indexModel).getChildCount()) > 0) {
                if (indexTag == WmiModelTag.MATH_SQUARE_ROOT || indexTag == WmiModelTag.MATH_NROOT) {
                    kids = 1;
                }
                ArrayList<WmiModel> list = new ArrayList<WmiModel>();
                int i = 0;
                while (i < kids) {
                    WmiModel child = modelToDelete.getChild(i);
                    if (child != null) {
                        list.add(child);
                    }
                    ++i;
                }
                kids = list.size();
                if (kids > 0) {
                    childrenToPromote = new WmiModel[kids];
                    list.toArray(childrenToPromote);
                }
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        return childrenToPromote;
    }
}

