/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.edit.WmiMathDocumentEditCommand;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;

public class WmiMathDocumentEditCopy
extends WmiMathDocumentEditCommand {
    public WmiMathDocumentEditCopy() {
        super("MathDoc.Edit.Copy");
    }

    public WmiMathDocumentEditCopy(String name) {
        super(name);
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        Object source = event.getSource();
        Transferable transfer = null;
        WmiMathDocumentView docView = null;
        if (source instanceof WmiView) {
            Clipboard clipboard;
            docView = ((WmiView)source).getDocumentView();
            if (docView != null) {
                WmiClipboardManager manager = docView.getClipboardManager();
                Transferable transferable = transfer = manager != null ? manager.createTransferable(false) : null;
            }
            if (transfer != null && (clipboard = this.getClipboard()) != null) {
                clipboard.setContents(transfer, null);
                success = true;
            }
        }
        if (success) {
            this.postCopy(docView);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void postCopy(WmiMathDocumentView docView) {
    }

    @Override
    public boolean isEnabled(WmiView view) {
        WmiMathDocumentView docView = null;
        if (view != null) {
            docView = view.getDocumentView();
        }
        boolean enabled = false;
        if (docView != null) {
            WmiSelection selection = docView.getSelection();
            WmiPositionMarker marker = docView.getPositionMarker();
            enabled = selection != null || marker instanceof WmiBoundsMarker;
        }
        return enabled;
    }

    protected Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }
}

