/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.edit.WmiAbstractDelete;
import com.maplesoft.mathdoc.controller.edit.WmiMathDocumentEditCopy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiPostDeletePositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiViewPath;
import java.awt.event.ActionEvent;

public class WmiMathDocumentEditCut
extends WmiMathDocumentEditCopy {
    public static final String COMMAND_NAME_MATHDOC = "MathDoc.Edit.Cut";

    protected WmiMathDocumentEditCut(String commandName) {
        super(commandName);
    }

    public WmiMathDocumentEditCut() {
        this(COMMAND_NAME_MATHDOC);
    }

    @Override
    protected void postCopy(WmiMathDocumentView docView) {
        WmiSelection selection = docView.getSelection();
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiModelPosition pos = null;
        if (selection != null && !selection.isCompoundSelection()) {
            WmiModel[] models = new WmiModel[2];
            int[] offsets = new int[2];
            selection.getModelInterval(models, offsets);
        }
        if (pos == null && marker != null) {
            pos = marker.getModelPosition();
        }
        if (pos != null) {
            try {
                docView.setPendingPositionUpdateHandler(new WmiPostDeletePositionUpdateHandler(docView, pos));
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        if (selection != null) {
            selection.deleteSelection();
        } else if (marker instanceof WmiBoundsMarker) {
            WmiPositionedView view = marker.getView();
            WmiViewPath path = new WmiViewPath(view);
            WmiViewFactory factory = docView.getViewFactory();
            WmiSelection interval = factory.createSelection(path, path);
            interval.deleteSelection();
        }
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiPositionMarker marker;
        WmiMathDocumentView docView = WmiMathDocumentEditCut.getDocumentView(event);
        boolean enabledNow = false;
        WmiSelection selection = docView != null ? docView.getSelection() : null;
        WmiPositionMarker wmiPositionMarker = marker = docView != null ? docView.getPositionMarker() : null;
        if (selection != null) {
            enabledNow = WmiAbstractDelete.isDeleteableSelection(selection, false);
        } else if (marker != null) {
            boolean bl = enabledNow = !marker.isReadOnly();
        }
        if (enabledNow) {
            super.doCommand(event);
        }
    }
}

