/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiDataActionEvent;
import com.maplesoft.mathdoc.controller.edit.WmiMathDocumentEditCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;

public class WmiMathDocumentEditPaste
extends WmiMathDocumentEditCommand {
    public static final String COMMAND_NAME = "MathDoc.Edit.Paste";

    public WmiMathDocumentEditPaste() {
        this(COMMAND_NAME);
    }

    public WmiMathDocumentEditPaste(String name) {
        super(name);
    }

    @Override
    public void doCommand(ActionEvent event) {
        Object source = event.getSource();
        WmiMathDocumentView docView = null;
        docView = source instanceof WmiView ? ((WmiView)source).getDocumentView() : WmiMathDocumentView.getActiveDocumentView();
        boolean success = false;
        if (docView != null) {
            Object data;
            Transferable t = null;
            if (event instanceof WmiDataActionEvent && (data = ((WmiDataActionEvent)event).getDataObject()) instanceof Transferable) {
                t = (Transferable)data;
            }
            if (t == null) {
                Clipboard clipboard = this.getClipboard();
                t = clipboard.getContents(null);
            }
            if (t != null) {
                WmiClipboardManager clipboardManager = docView.getClipboardManager();
                boolean bl = success = clipboardManager != null ? clipboardManager.paste(t) : false;
            }
        }
        if (!success) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public boolean isEnabled(WmiView view) {
        boolean enabledNow = false;
        if (view != null) {
            WmiMathDocumentModel doc;
            WmiMathDocumentView docView;
            WmiMathDocumentView wmiMathDocumentView = docView = view != null ? view.getDocumentView() : null;
            if (docView != null && (doc = (WmiMathDocumentModel)docView.getModel()) != null && WmiModelLock.readLock(doc, false)) {
                try {
                    try {
                        WmiPositionMarker marker = docView.getPositionMarker();
                        boolean isPlot = false;
                        enabledNow = isPlot || marker != null && !marker.isReadOnly();
                    }
                    catch (WmiNoReadAccessException readE) {
                        WmiErrorLog.log(readE);
                        WmiModelLock.readUnlock(doc);
                    }
                }
                finally {
                    WmiModelLock.readUnlock(doc);
                }
            }
        }
        return enabledNow;
    }

    protected Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }
}

