/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathModelAttributeCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public class WmiFormatMakeAtomicCommand
extends WmiFormatMathModelAttributeCommand {
    protected static final String ATOMIC = "atomic";
    protected static final String COMMA_ATOMIC = ",atomic";

    protected WmiFormatMakeAtomicCommand(String name, Class targetModel) {
        super(name, targetModel);
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        Object value = attrs.getAttribute("Typesetting:-msemantics");
        String semantics = value instanceof String ? (String)value : "";
        if ((semantics = semantics.trim()).indexOf(ATOMIC) != -1) {
            semantics = semantics.replaceFirst(COMMA_ATOMIC, "");
            semantics = semantics.replaceFirst(ATOMIC, "");
        } else {
            semantics = semantics.length() == 0 ? ATOMIC : String.valueOf(semantics) + COMMA_ATOMIC;
        }
        semantics = semantics.trim();
        attrs.addAttribute("Typesetting:-msemantics", semantics);
        return attrs;
    }

    @Override
    public boolean isSelected() {
        WmiPositionMarker marker;
        WmiPositionedView view;
        boolean selectedMeansAtomic = false;
        WmiMathDocumentView docView = WmiMathDocumentView.getActiveDocumentView();
        if (docView != null && (view = (marker = docView.getPositionMarker()).getView()) != null) {
            WmiModel model = view.getModel();
            boolean locked = WmiModelLock.readLock(model, false);
            try {
                try {
                    String semantics;
                    WmiMathAttributeSet attrs;
                    Object value;
                    WmiMathModel targetModel;
                    if (locked && (targetModel = this.getTargetModel(model)) != null && targetModel.getAttributes() instanceof WmiMathAttributeSet && (value = (attrs = (WmiMathAttributeSet)targetModel.getAttributes()).getAttribute("Typesetting:-msemantics")) instanceof String && (semantics = (String)value).indexOf(ATOMIC) >= 0) {
                        selectedMeansAtomic = true;
                    }
                }
                catch (WmiNoReadAccessException nra) {
                    WmiErrorLog.log(nra);
                    if (locked) {
                        WmiModelLock.readUnlock(model);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(model);
                }
            }
        }
        return selectedMeansAtomic;
    }

    @Override
    public int getType() {
        return 1;
    }

    public static class WmiFormatFencedMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatFencedMakeAtomicCommand() {
            super("format.mfenced.makeatomic", WmiMathFencedModel.class);
        }
    }

    public static class WmiFormatIdentifierMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatIdentifierMakeAtomicCommand() {
            super("format.mi.makeatomic", WmiIdentifierModel.class);
        }
    }

    public static class WmiFormatMultiscriptsMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatMultiscriptsMakeAtomicCommand() {
            super("format.mmultiscripts.makeatomic", WmiMathMultiscriptModel.class);
        }
    }

    public static class WmiFormatNumericMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatNumericMakeAtomicCommand() {
            super("format.mn.makeatomic", WmiNumericModel.class);
        }
    }

    public static class WmiFormatOperatorMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatOperatorMakeAtomicCommand() {
            super("format.mo.makeatomic", WmiMathOperatorModel.class);
        }
    }

    public static class WmiFormatOverMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatOverMakeAtomicCommand() {
            super("format.mover.makeatomic", WmiOverModel.class);
        }
    }

    public static class WmiFormatRationalMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatRationalMakeAtomicCommand() {
            super("format.mfrac.makeatomic", WmiFractionModel.class);
        }
    }

    public static class WmiFormatRootMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatRootMakeAtomicCommand() {
            super("format.mroot.makeatomic", WmiRootModel.class);
        }
    }

    public static class WmiFormatRowMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatRowMakeAtomicCommand() {
            super("format.mrow.makeatomic", WmiInlineMathModel.class);
        }
    }

    public static class WmiFormatSquareRootMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatSquareRootMakeAtomicCommand() {
            super("format.msqrt.makeatomic", WmiRootModel.WmiSquareRootModel.class);
        }
    }

    public static class WmiFormatStringMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatStringMakeAtomicCommand() {
            super("format.ms.makeatomic", WmiMathStringModel.class);
        }
    }

    public static class WmiFormatSubSupMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatSubSupMakeAtomicCommand() {
            super("format.subsup.makeatomic", WmiSubSupModel.class);
        }
    }

    public static class WmiFormatSubscriptMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatSubscriptMakeAtomicCommand() {
            super("format.subscript.makeatomic", WmiSubscriptModel.class);
        }
    }

    public static class WmiFormatSuperscriptMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatSuperscriptMakeAtomicCommand() {
            super("format.superscript.makeatomic", WmiSuperscriptModel.class);
        }
    }

    public static class WmiFormatTableMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatTableMakeAtomicCommand() {
            super("format.mtable.makeatomic", WmiMathTableModel.class);
        }
    }

    public static class WmiFormatUnderMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatUnderMakeAtomicCommand() {
            super("format.munder.makeatomic", WmiUnderModel.class);
        }
    }

    public static class WmiFormatUnderOverMakeAtomicCommand
    extends WmiFormatMakeAtomicCommand {
        public WmiFormatUnderOverMakeAtomicCommand() {
            super("format.munderover.makeatomic", WmiUnderOverModel.class);
        }
    }
}

