/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathCommand;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathModelAttributeCommand;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class WmiFormatMathFenceCharCommand
extends WmiFormatMathModelAttributeCommand {
    public WmiFormatMathFenceCharCommand() {
        super("format.mfence.delim", WmiMathFencedModel.class);
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        String open = (String)attrs.getAttribute("open");
        String close = (String)attrs.getAttribute("close");
        String separator = (String)attrs.getAttribute("separators");
        WmiFenceDialog modFence = new WmiFenceDialog(null, open, close, separator);
        modFence.show();
        if (modFence.wasChangeApproved()) {
            open = modFence.getOpen();
            close = modFence.getClose();
            separator = modFence.getSeparator();
            attrs.addAttribute("open", open);
            attrs.addAttribute("close", close);
            attrs.addAttribute("separators", separator);
        }
        return attrs;
    }

    public class WmiFenceDialog
    extends WmiFormatMathCommand.WmiFormatDialog {
        private static final String TITLE_KEY = "format.fence.title";
        private static final String OPEN_BRACKET_LABEL = "format.fence.open.label";
        private static final String SEPARATOR_CHAR_LABEL = "format.fence.separator.label";
        private static final String CLOSE_BRACKET_LABEL = "format.fence.close.label";
        private static final String OPEN_CHAR_LIST_KEY = "format.fence.open.characters";
        private static final String SEPARATOR_CHAR_LIST_KEY = "format.fence.separator.characters";
        private static final String CLOSE_CHAR_LIST_KEY = "format.fence.close.characters";
        private String open;
        private String close;
        private String separator;
        private WmiComboBox cbOpen;
        private WmiComboBox cbClose;
        private WmiComboBox cbSeparator;
        private String[] openChars;
        private String[] closeChars;
        private String[] sepChars;

        public WmiFenceDialog(JFrame frame, String open, String close, String separator) {
            super(frame);
            this.open = open;
            this.close = close;
            this.separator = separator;
            this.setTitle(TITLE_KEY, null);
            this.layoutDialog();
        }

        @Override
        public void addComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.mapItemLists();
            gbc.gridx = 0;
            gbc.gridy = 0;
            String bracketLeftLabel = this.mapResourceKey(OPEN_BRACKET_LABEL);
            this.getContentPane().add((Component)new JLabel(bracketLeftLabel), gbc);
            this.cbOpen = this.createFormatComboBox(this.openChars);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.getContentPane().add((Component)this.cbOpen, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            String bracketSepLabel = this.mapResourceKey(SEPARATOR_CHAR_LABEL);
            this.getContentPane().add((Component)new JLabel(bracketSepLabel), gbc);
            this.cbSeparator = this.createFormatComboBox(this.sepChars);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.getContentPane().add((Component)this.cbSeparator, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            String bracketRightLabel = this.mapResourceKey(CLOSE_BRACKET_LABEL);
            this.getContentPane().add((Component)new JLabel(bracketRightLabel), gbc);
            this.cbClose = this.createFormatComboBox(this.closeChars);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.getContentPane().add((Component)this.cbClose, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            this.getContentPane().add((Component)this.createDefaultButtonsPanel(), gbc);
        }

        private void mapItemLists() {
            this.openChars = this.mapItemList(OPEN_CHAR_LIST_KEY, this.open);
            this.closeChars = this.mapItemList(CLOSE_CHAR_LIST_KEY, this.close);
            this.sepChars = this.mapItemList(SEPARATOR_CHAR_LIST_KEY, this.separator);
        }

        public String getOpen() {
            Object item = this.cbOpen.getSelectedItem();
            return item != null ? item.toString() : "";
        }

        public String getClose() {
            Object item = this.cbClose.getSelectedItem();
            return item != null ? item.toString() : "";
        }

        public String getSeparator() {
            Object item = this.cbSeparator.getSelectedItem();
            return item != null ? item.toString() : "";
        }
    }
}

