/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathRationalCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public abstract class WmiFormatMathRationalAlignCommand
extends WmiFormatMathRationalCommand {
    private String alignmentLocation;
    private String alignmentValue;

    protected WmiFormatMathRationalAlignCommand(String name, String alignmentLocation, String alignmentValue) {
        super(name);
        this.alignmentLocation = alignmentLocation;
        this.alignmentValue = alignmentValue;
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        attrs.addAttribute(this.getAlignmentLocation(), this.getAlignmentValue());
        return attrs;
    }

    private String getAlignmentLocation() {
        return this.alignmentLocation;
    }

    private String getAlignmentValue() {
        return this.alignmentValue;
    }

    private boolean isAlignmentChecked(WmiFractionModel.WmiFractionAttributeSet attrs) {
        boolean alignment = false;
        Object val = attrs.getAttribute(this.getAlignmentLocation());
        if (val instanceof String) {
            alignment = ((String)val).equals(this.getAlignmentValue());
        }
        return alignment;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isSelected() {
        WmiPositionMarker marker;
        WmiPositionedView view;
        boolean alignmentCorrect = false;
        WmiMathDocumentView docView = WmiMathDocumentView.getActiveDocumentView();
        if (docView != null && (view = (marker = docView.getPositionMarker()).getView()) != null) {
            WmiModel model = view.getModel();
            boolean locked = false;
            try {
                try {
                    WmiFractionModel rational;
                    locked = WmiModelLock.readLock(model, false);
                    if (locked && (rational = (WmiFractionModel)this.getTargetModel(model)) != null) {
                        WmiFractionModel.WmiFractionAttributeSet attrs = (WmiFractionModel.WmiFractionAttributeSet)rational.getAttributes();
                        alignmentCorrect = this.isAlignmentChecked(attrs);
                    }
                }
                catch (WmiNoReadAccessException nra) {
                    WmiErrorLog.log(nra);
                    if (locked) {
                        WmiModelLock.readUnlock(model);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(model);
                }
            }
        }
        return alignmentCorrect;
    }

    public static class WmiFormatMathRationalDenominatorCenter
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalDenominatorCenter() {
            super("format.rational.align.dcenter", "denomalign", "center");
        }
    }

    public static class WmiFormatMathRationalDenominatorLeft
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalDenominatorLeft() {
            super("format.rational.align.dleft", "denomalign", "left");
        }
    }

    public static class WmiFormatMathRationalDenominatorRight
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalDenominatorRight() {
            super("format.rational.align.dright", "denomalign", "right");
        }
    }

    public static class WmiFormatMathRationalNumeratorCenter
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalNumeratorCenter() {
            super("format.rational.align.ncenter", "numalign", "center");
        }
    }

    public static class WmiFormatMathRationalNumeratorLeft
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalNumeratorLeft() {
            super("format.rational.align.nleft", "numalign", "left");
        }
    }

    public static class WmiFormatMathRationalNumeratorRight
    extends WmiFormatMathRationalAlignCommand {
        public WmiFormatMathRationalNumeratorRight() {
            super("format.rational.align.nright", "numalign", "right");
        }
    }
}

