/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathRationalCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public class WmiFormatMathRationalBevelCommand
extends WmiFormatMathRationalCommand {
    public WmiFormatMathRationalBevelCommand() {
        super("format.rational.bevelled");
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        boolean bevel = ((WmiFractionModel.WmiFractionAttributeSet)attrs).isBevelled();
        attrs.addAttribute("bevelled", Boolean.toString(!bevel));
        return attrs;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isSelected() {
        WmiPositionedView view;
        WmiPositionMarker marker;
        boolean selectedMeansBevelled = false;
        WmiMathDocumentView docView = WmiMathDocumentView.getActiveDocumentView();
        if (docView != null && (marker = docView.getPositionMarker()) != null && (view = marker.getView()) != null) {
            WmiModel model = view.getModel();
            boolean locked = false;
            try {
                try {
                    WmiFractionModel rational;
                    locked = WmiModelLock.readLock(model, false);
                    if (locked && (rational = (WmiFractionModel)this.getTargetModel(model)) != null) {
                        WmiFractionModel.WmiFractionAttributeSet attrs = (WmiFractionModel.WmiFractionAttributeSet)rational.getAttributes();
                        selectedMeansBevelled = attrs.isBevelled();
                    }
                }
                catch (WmiNoReadAccessException nra) {
                    WmiErrorLog.log(nra);
                    if (locked) {
                        WmiModelLock.readUnlock(model);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(model);
                }
            }
        }
        return selectedMeansBevelled;
    }
}

