/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathModelAttributeCommand;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;

public class WmiFormatMathScriptCommand
extends WmiFormatMathModelAttributeCommand {
    private int shiftModification;
    private String attributeKey;

    protected WmiFormatMathScriptCommand(String name, Class targetModel, String attributeKey, int shiftMod) {
        super(name, targetModel);
        this.attributeKey = attributeKey;
        this.shiftModification = shiftMod;
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        Object attr = attrs.getAttribute(this.attributeKey);
        if (attr instanceof String) {
            try {
                int value = Integer.parseInt((String)attr);
                attrs.addAttribute(this.attributeKey, Integer.toString(value += this.shiftModification));
            }
            catch (NumberFormatException nfe) {
                attrs.addAttribute(this.attributeKey, "0");
            }
        } else if (attr instanceof Integer) {
            int value = (Integer)attr;
            attrs.addAttribute(this.attributeKey, new Integer(value += this.shiftModification));
        }
        return attrs;
    }

    public static class WmiFormatSubSupSubscriptShiftDecreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSubSupSubscriptShiftDecreaseCommand() {
            super("format.subsup.subscript.shift.decrease", WmiSubSupModel.class, "subscriptshift", -1);
        }
    }

    public static class WmiFormatSubSupSubscriptShiftIncreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSubSupSubscriptShiftIncreaseCommand() {
            super("format.subsup.subscript.shift.increase", WmiSubSupModel.class, "subscriptshift", 1);
        }
    }

    public static class WmiFormatSubSupSuperscriptShiftDecreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSubSupSuperscriptShiftDecreaseCommand() {
            super("format.subsup.superscript.shift.decrease", WmiSubSupModel.class, "superscriptshift", -1);
        }
    }

    public static class WmiFormatSubSupSuperscriptShiftIncreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSubSupSuperscriptShiftIncreaseCommand() {
            super("format.subsup.superscript.shift.increase", WmiSubSupModel.class, "superscriptshift", 1);
        }
    }

    public static class WmiFormatSubscriptShiftDecreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSubscriptShiftDecreaseCommand() {
            super("format.subscript.shift.decrease", WmiSubscriptModel.class, "subscriptshift", -1);
        }
    }

    public static class WmiFormatSubscriptShiftIncreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSubscriptShiftIncreaseCommand() {
            super("format.subscript.shift.increase", WmiSubscriptModel.class, "subscriptshift", 1);
        }
    }

    public static class WmiFormatSuperscriptShiftDecreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSuperscriptShiftDecreaseCommand() {
            super("format.superscript.shift.decrease", WmiSuperscriptModel.class, "superscriptshift", -1);
        }
    }

    public static class WmiFormatSuperscriptShiftIncreaseCommand
    extends WmiFormatMathScriptCommand {
        public WmiFormatSuperscriptShiftIncreaseCommand() {
            super("format.superscript.shift.increase", WmiSuperscriptModel.class, "superscriptshift", 1);
        }
    }
}

