/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathCommand;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathModelAttributeCommand;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WmiFormatMathSpaceCommand
extends WmiFormatMathModelAttributeCommand {
    private static final WmiDimensionUnit ZERO_UNIT = WmiDimensionUnit.createDimension("0.0em", null);

    public WmiFormatMathSpaceCommand() {
        super("format.mspace.dimension", WmiMathSpaceModel.class);
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        WmiDimensionUnit width = (WmiDimensionUnit)attrs.getAttribute("width");
        WmiDimensionUnit height = (WmiDimensionUnit)attrs.getAttribute("height");
        WmiDimensionUnit depth = (WmiDimensionUnit)attrs.getAttribute("depth");
        WmiSpaceDialog modSpace = new WmiSpaceDialog(null, width, height, depth);
        modSpace.show();
        if (modSpace.wasChangeApproved()) {
            width = modSpace.getWidthAttr();
            height = modSpace.getHeightAttr();
            depth = modSpace.getDepthAttr();
            attrs.addAttribute("width", width);
            attrs.addAttribute("height", height);
            attrs.addAttribute("depth", depth);
        }
        return attrs;
    }

    public class WmiSpaceDialog
    extends WmiFormatMathCommand.WmiFormatDialog {
        private static final String TITLE_KEY = "format.space.title";
        private static final String SPACE_WIDTH_LABEL = "format.space.width.label";
        private static final String SPACE_HEIGHT_LABEL = "format.space.height.label";
        private static final String SPACE_DEPTH_LABEL = "format.space.depth.label";
        private static final String UNIT_NAMES = "format.space.unit.names";
        private WmiDimensionUnit widthattr;
        private WmiDimensionUnit heightattr;
        private WmiDimensionUnit depthattr;
        private JTextField tfWidthValue;
        private JTextField tfHeightValue;
        private JTextField tfDepthValue;
        private WmiComboBox cbWidthUnit;
        private WmiComboBox cbHeightUnit;
        private WmiComboBox cbDepthUnit;
        private String[] unitSuggestions;

        public WmiSpaceDialog(JFrame frame, WmiDimensionUnit widthattr, WmiDimensionUnit heightattr, WmiDimensionUnit depthattr) {
            super(frame);
            this.widthattr = widthattr;
            this.heightattr = heightattr;
            this.depthattr = depthattr;
            this.setTitle(TITLE_KEY, null);
            this.layoutDialog();
        }

        @Override
        public void addComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.unitSuggestions = this.mapItemList(UNIT_NAMES, null);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(SPACE_WIDTH_LABEL)), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.tfWidthValue = this.createUnitTextField(this.widthattr);
            this.getContentPane().add((Component)this.tfWidthValue, gbc);
            this.cbWidthUnit = this.createUnitComboBox(this.unitSuggestions, this.widthattr);
            gbc.gridx = 2;
            gbc.gridy = 0;
            this.getContentPane().add((Component)this.cbWidthUnit, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(SPACE_HEIGHT_LABEL)), gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.tfHeightValue = this.createUnitTextField(this.heightattr);
            this.getContentPane().add((Component)this.tfHeightValue, gbc);
            this.cbHeightUnit = this.createUnitComboBox(this.unitSuggestions, this.heightattr);
            gbc.gridx = 2;
            gbc.gridy = 1;
            this.getContentPane().add((Component)this.cbHeightUnit, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(SPACE_DEPTH_LABEL)), gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.tfDepthValue = this.createUnitTextField(this.depthattr);
            this.getContentPane().add((Component)this.tfDepthValue, gbc);
            this.cbDepthUnit = this.createUnitComboBox(this.unitSuggestions, this.depthattr);
            gbc.gridx = 2;
            gbc.gridy = 2;
            this.getContentPane().add((Component)this.cbDepthUnit, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 3;
            this.getContentPane().add((Component)this.createDefaultButtonsPanel(), gbc);
        }

        private JTextField createUnitTextField(WmiDimensionUnit attr) {
            JTextField tfField = new JTextField(10);
            if (attr != null) {
                String value = Float.toString(attr.getUnitsValue());
                tfField.setText(value);
            }
            return tfField;
        }

        private WmiComboBox createUnitComboBox(String[] unitSuggestions, WmiDimensionUnit attr) {
            WmiComboBox cbBox = this.createFormatComboBox(unitSuggestions);
            if (attr != null) {
                cbBox.setSelectedItem(attr.getUnit());
            }
            return cbBox;
        }

        public WmiDimensionUnit getWidthAttr() {
            return this.produceValue(this.tfWidthValue, this.cbWidthUnit);
        }

        public WmiDimensionUnit getHeightAttr() {
            return this.produceValue(this.tfHeightValue, this.cbHeightUnit);
        }

        public WmiDimensionUnit getDepthAttr() {
            return this.produceValue(this.tfDepthValue, this.cbDepthUnit);
        }

        private WmiDimensionUnit produceValue(JTextField tfValue, WmiComboBox cbUnit) {
            StringBuffer unitAttr = new StringBuffer();
            if (tfValue.getText() != null && tfValue.getText().length() > 0) {
                String valstr = tfValue.getText();
                unitAttr.append(valstr);
            }
            if (cbUnit.getSelectedItem() != null) {
                Object item = cbUnit.getSelectedItem();
                String unitsName = item instanceof String ? (String)item : "";
                unitAttr.append(unitsName);
            }
            return WmiDimensionUnit.createDimension(unitAttr.toString(), ZERO_UNIT);
        }
    }
}

