/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import java.awt.Color;

public class InsertMathStructureCommand
extends WmiInsertGenericMathCommand {
    private final Color PLACEHOLDER_COLOR = new Color(200, 0, 200);

    public InsertMathStructureCommand(String name) {
        super(name);
    }

    public InsertMathStructureCommand(String name, boolean replace) {
        super(name, replace);
    }

    protected int getReplacePlaceholderIndex() {
        return 0;
    }

    protected int getCaretPlaceHolderIndex() {
        return 1;
    }

    protected WmiModelPosition getExistingPlaceholder(WmiModel target) throws WmiNoReadAccessException {
        return null;
    }

    protected int getInsertBias() {
        return 0;
    }

    protected boolean addBrackets(WmiModel target) {
        WmiCompositeModel comp;
        WmiMathDocumentModel docModel;
        boolean ownsWrite;
        WmiModelTag tag = target != null ? target.getTag() : null;
        boolean add = true;
        if (tag == WmiModelTag.MATH_OVER || tag == WmiModelTag.MATH_UNDER || tag == WmiModelTag.MATH_UNDER_OVER || tag == WmiModelTag.MATH_SQUARE_ROOT || tag == WmiModelTag.MATH_NROOT || tag == WmiModelTag.MATH_FENCED) {
            add = false;
        } else if (tag == WmiModelTag.MATH_ACTION && ((ownsWrite = WmiModelLock.ownsWriteLock(docModel = (comp = (WmiCompositeModel)target).getDocument())) || WmiModelLock.readLock(docModel, true))) {
            try {
                try {
                    if (comp.getChildCount() == 1) {
                        add = this.addBrackets(comp.getChild(0));
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (!ownsWrite) {
                        WmiModelLock.readUnlock(docModel);
                    }
                }
            }
            finally {
                if (!ownsWrite) {
                    WmiModelLock.readUnlock(docModel);
                }
            }
        }
        return add;
    }

    @Override
    public WmiMathModel createPlaceHolder(WmiMathDocumentModel doc, WmiMathContext context) {
        WmiFontAttributeSet attributes;
        WmiIdentifierModel placeholder;
        block9: {
            placeholder = null;
            attributes = null;
            boolean ownsWriteLock = WmiModelLock.ownsWriteLock(doc);
            if (ownsWriteLock || WmiModelLock.readLock(doc, false)) {
                try {
                    try {
                        attributes = doc.getActiveEditAttributes();
                        attributes = (WmiFontAttributeSet)attributes.copyAttributes();
                        attributes.setStyle(1, false);
                        attributes.setStyle(2, true);
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        if (!ownsWriteLock) {
                            WmiModelLock.readUnlock(doc);
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (!ownsWriteLock) {
                        WmiModelLock.readUnlock(doc);
                    }
                    throw throwable;
                }
                if (!ownsWriteLock) {
                    WmiModelLock.readUnlock(doc);
                }
            }
        }
        placeholder = attributes != null ? new WmiIdentifierModel(doc, "", "", attributes, false) : new WmiIdentifierModel(doc, "", "", context, false);
        return placeholder;
    }

    @Override
    protected boolean performInsert(WmiMathDocumentView docView, WmiMathContext context) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        boolean success = false;
        WmiModelPosition pos = MathInsertUtil.wrapSelection(docView, this.getInsertBias());
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        if (pos != null) {
            WmiModel targetModel = pos.getModel();
            WmiModelPosition existingPlaceholder = this.getExistingPlaceholder(targetModel);
            if (existingPlaceholder == null) {
                WmiModelTag target;
                WmiCompositeModel insertModel = this.createCompositeInsertModel(doc, context);
                boolean addBrackets = this.addBrackets(targetModel);
                if (addBrackets && (target = this.combineTag()) == targetModel.getTag()) {
                    addBrackets = false;
                }
                pos = MathInsertUtil.performModelWrap(targetModel, insertModel, context, this.getReplacePlaceholderIndex(), this.getCaretPlaceHolderIndex(), addBrackets);
                if (this.combineTag() != null) {
                    this.combineModels(insertModel, context);
                }
            } else {
                pos = existingPlaceholder;
            }
            if (pos != null) {
                docView.setPendingPosition(pos);
                doc.update(this.getResource(5));
                success = true;
            }
        }
        if (!success) {
            doc.revertPendingUpdates();
        }
        return success;
    }

    public static boolean performInsert(WmiMathDocumentView docView, WmiMathModel insertModel, String undo) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        WmiModelPosition pos;
        boolean success = false;
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        if (undo != null) {
            doc.startUndoableEdit(undo);
        }
        if ((pos = MathInsertUtil.wrapSelection(docView, 0)) != null) {
            WmiModel model = pos.getModel();
            WmiCompositeModel parent = model.getParent();
            int index = parent.indexOf(model);
            if (index >= 0) {
                success = true;
                parent.addChild(insertModel, ++index);
                WmiModel targetModel = insertModel;
                while (targetModel instanceof WmiCompositeModel) {
                    WmiCompositeModel comp = (WmiCompositeModel)targetModel;
                    int size = comp.getChildCount();
                    if (size <= 0) break;
                    targetModel = comp.getChild(size - 1);
                }
                pos = new WmiModelPosition(targetModel, -1);
                docView.setPendingPosition(pos);
                pos = MathTokenizer.retokenize(pos);
                if (pos != null) {
                    docView.setPendingPosition(pos);
                }
            }
            doc.update(undo);
        }
        if (!success) {
            doc.revertPendingUpdates();
        }
        if (undo != null) {
            doc.endUndoableEdit();
        }
        return success;
    }

    protected WmiCompositeModel createCompositeInsertModel(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        return null;
    }

    public WmiCompositeModel createCombinedInsertModel(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException {
        return null;
    }

    protected void combineModels(WmiCompositeModel model, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelTag target;
        WmiModelTag parentTag;
        WmiModel base = model.getChild(0);
        WmiCompositeModel parent = model.getParent();
        if (parent != null && parent.getChild(0) != model) {
            parent = null;
        }
        WmiModelTag baseTag = base != null ? base.getTag() : null;
        WmiModelTag wmiModelTag = parentTag = parent != null ? parent.getTag() : null;
        if (parentTag == WmiModelTag.MATH_ROW && parent.getChildCount() == 1) {
            WmiCompositeModel ref = parent;
            if ((parent = parent.getParent()) != null && parent.indexOf(ref) != 0) {
                parent = null;
            }
            WmiModelTag wmiModelTag2 = parentTag = parent != null ? parent.getTag() : null;
        }
        if (baseTag == (target = this.combineTag())) {
            this.doInnerCombine(model, (WmiCompositeModel)base, context);
        } else if (parentTag == target) {
            this.doOuterCombine(model, parent, context);
        }
    }

    protected void doInnerCombine(WmiCompositeModel model, WmiCompositeModel base, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
    }

    protected void doOuterCombine(WmiCompositeModel model, WmiCompositeModel parent, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
    }

    protected WmiModelTag combineTag() {
        return null;
    }

    public WmiCompositeModel createSubSupModel(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException {
        WmiMathModel placeholder = this.createPlaceHolder(doc, context);
        WmiMathModel placeholder2 = this.createPlaceHolder(doc, context);
        WmiMathModel placeholder3 = this.createPlaceHolder(doc, context);
        WmiSubSupModel msup = new WmiSubSupModel(doc, placeholder, placeholder2, placeholder3, context);
        return msup;
    }

    private String getSemanticsString(WmiModel model) {
        String result = "";
        if (model instanceof WmiMathModel) {
            try {
                String temp = (String)((WmiMathModel)model).getAttributesForRead().getAttribute("Typesetting:-msemantics");
                if (temp != null) {
                    result = temp;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        return result.trim().length() != 0 ? result : "none";
    }

    protected void createSubSupModel(WmiModel reference, WmiModel base, WmiModel subscript, WmiModel superscript, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel subsup = this.createCombinedInsertModel(reference.getDocument(), context);
        WmiModel[] replacement = new WmiModel[]{base, subscript, superscript};
        StringBuffer semantics = new StringBuffer();
        semantics.append("[");
        if (reference instanceof WmiSubscriptModel) {
            semantics.append(this.getSemanticsString(reference));
            semantics.append(",");
            semantics.append(this.getSemanticsString(base.getParent()));
        } else {
            semantics.append(this.getSemanticsString(base.getParent()));
            semantics.append(",");
            semantics.append(this.getSemanticsString(reference));
        }
        semantics.append("]");
        subsup.addAttribute("Typesetting:-msemantics", semantics.toString());
        WmiCompositeModel parent = reference.getParent();
        int targetIndex = parent.indexOf(reference);
        parent.replaceChild(subsup, targetIndex);
        subsup.replaceChildren(replacement, 0, 3);
    }

    public WmiCompositeModel createUnderOverModel(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException {
        WmiMathModel placeholder = this.createPlaceHolder(doc, context);
        WmiMathModel placeholder2 = this.createPlaceHolder(doc, context);
        WmiMathModel placeholder3 = this.createPlaceHolder(doc, context);
        WmiUnderOverModel msup = new WmiUnderOverModel(doc, placeholder, placeholder2, placeholder3, context);
        return msup;
    }

    protected void createUnderModel(WmiModel reference, WmiModel base, WmiModel under, WmiModel over, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel underover = this.createCombinedInsertModel(reference.getDocument(), context);
        WmiModel[] replacement = new WmiModel[]{base, under, over};
        WmiCompositeModel parent = reference.getParent();
        int targetIndex = parent.indexOf(reference);
        parent.replaceChild(underover, targetIndex);
        underover.replaceChildren(replacement, 0, 3);
    }

    protected static void selectModel(WmiMathDocumentView docView, WmiModel model) {
        docView.setPendingPositionUpdateHandler(new ModelSelector(docView, model));
    }

    protected WmiMathModel createTablePlaceholder(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException {
        WmiIdentifierModel model = new WmiIdentifierModel(doc, "?", "?", context, false);
        model.addAttribute("foreground", this.PLACEHOLDER_COLOR);
        model.addAttribute(WmiFontAttributeSet.PLACEHOLDER_KEY, "true");
        return model;
    }

    protected static class ModelSelector
    implements WmiPositionUpdateHandler {
        private WmiMathDocumentView docView;
        private WmiModel model;

        protected ModelSelector(WmiMathDocumentView docView, WmiModel model) {
            this.docView = docView;
            this.model = model;
        }

        @Override
        public void updatePosition() throws WmiNoReadAccessException {
            if (this.model instanceof WmiTextModel) {
                WmiSearchAndSelect.selectTextModel(this.docView, (WmiTextModel)this.model);
            } else if (this.model instanceof WmiCompositeModel) {
                WmiSearchAndSelect.selectCompositeModel(this.docView, (WmiCompositeModel)this.model);
            }
        }
    }
}

