/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.InsertMathStructureCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public class WmiInsertTableRowCommand
extends InsertMathStructureCommand {
    public WmiInsertTableRowCommand() {
        super("Insert.Tablerow");
    }

    public WmiInsertTableRowCommand(String name) {
        super(name);
    }

    public WmiInsertTableRowCommand(String name, boolean replace) {
        super(name, replace);
    }

    @Override
    protected boolean performInsert(WmiMathDocumentView docView, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoUpdateAccessException {
        boolean success = false;
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            docView.setSelection(null);
            int offset = marker.getOffset();
            WmiPositionedView view = marker.getView();
            WmiModel targetModel = view.getModel();
            WmiCompositeModel tableCellModel = WmiModelUtil.findAncestorOfTag(targetModel, WmiModelTag.MATH_TABLE_CELL);
            if (tableCellModel == null) {
                WmiMathTableModel table = new WmiMathTableModel(doc);
                WmiMathTableModel.WmiMathTableRowModel row1 = new WmiMathTableModel.WmiMathTableRowModel(doc);
                WmiMathTableModel.WmiMathTableRowModel row2 = new WmiMathTableModel.WmiMathTableRowModel(doc);
                WmiMathTableModel.WmiMathTableDataModel data1 = new WmiMathTableModel.WmiMathTableDataModel(doc);
                WmiMathTableModel.WmiMathTableDataModel data2 = new WmiMathTableModel.WmiMathTableDataModel(doc);
                if (offset == 0) {
                    row1.appendChild(data2);
                    row2.appendChild(data1);
                } else {
                    row1.appendChild(data1);
                    row2.appendChild(data2);
                }
                WmiMathModel placeholder = this.createTablePlaceholder(doc, context);
                data2.appendChild(placeholder);
                table.appendChild(row1);
                table.appendChild(row2);
                WmiCompositeModel parent = targetModel.getParent();
                int targetIndex = parent.indexOf(targetModel);
                if (targetIndex >= 0) {
                    parent.replaceChild(table, targetIndex);
                    data1.appendChild(targetModel);
                    WmiInsertTableRowCommand.selectModel(docView, placeholder);
                    doc.update(this.getResource(5));
                    success = true;
                }
            } else {
                success = this.insertRow(docView, tableCellModel, context);
            }
        }
        return success;
    }

    private boolean insertRow(WmiMathDocumentView docView, WmiModel tableCellModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoUpdateAccessException {
        boolean success = true;
        WmiCompositeModel row = tableCellModel.getParent();
        WmiCompositeModel table = row.getParent();
        WmiMathDocumentModel doc = tableCellModel.getDocument();
        int tableSize = table.getChildCount();
        int rowSize = row.getChildCount();
        int rowIndex = -1;
        int i = 0;
        while (i < tableSize) {
            WmiCompositeModel child = (WmiCompositeModel)table.getChild(i);
            if (child.getChildCount() != rowSize) {
                success = false;
                break;
            }
            if (tableCellModel.getParent() == child) {
                rowIndex = i;
            }
            ++i;
        }
        if (success && rowIndex >= 0) {
            ++rowIndex;
            WmiModel[] rowContents = new WmiCompositeModel[rowSize];
            int i2 = 0;
            while (i2 < rowSize) {
                WmiMathModel placeholder = this.createTablePlaceholder(doc, context);
                rowContents[i2] = new WmiMathTableModel.WmiMathTableDataModel(doc);
                rowContents[i2].addChild(placeholder, 0);
                ++i2;
            }
            try {
                row = new WmiMathTableModel.WmiMathTableRowModel(doc, rowContents);
                table.addChild(row, rowIndex);
                WmiInsertTableRowCommand.selectModel(docView, rowContents[0].getChild(0));
                doc.update(this.getResource(5));
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
        }
        return success;
    }
}

