/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;

public class WmiInsertTokenCommand
extends WmiInsertGenericMathCommand {
    private static WmiModelTag[] INVALID_NEWLINE_PARENTS = new WmiModelTag[]{WmiModelTag.MATH_SUBSCRIPT, WmiModelTag.MATH_SUPERSCRIPT, WmiModelTag.MATH_SUB_SUP, WmiModelTag.MATH_SQUARE_ROOT, WmiModelTag.MATH_MULTISCRIPTS, WmiModelTag.MATH_FRAC, WmiModelTag.MATH_TABLE, WmiModelTag.MATH_FENCED};
    public static WmiInsertTokenCommand INSTANCE;
    public static WmiInsertTokenCommand DEFAULT_TOKEN_INSERTER;

    static {
        DEFAULT_TOKEN_INSERTER = INSTANCE = new WmiInsertTokenCommand("Insert.Token");
    }

    public WmiInsertTokenCommand(String name) {
        super(name);
    }

    public WmiInsertTokenCommand(String name, boolean replace) {
        super(name, replace);
    }

    public static final void insertAndUpdate(char character, WmiView view, String updateName) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView docView = view.getDocumentView();
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null && marker.getModelPosition() != null) {
            WmiInsertTokenCommand.insertAndUpdate(character, marker, docView.getSelection(), doc, docView, updateName);
        }
    }

    public static final void insertAndUpdate(char character, WmiPositionMarker marker, WmiSelection selection, WmiMathDocumentModel doc, WmiMathDocumentView docView, String updateName) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        boolean isSelectionOk = true;
        if (selection != null) {
            WmiModel[] endModels = new WmiModel[2];
            int[] offsets = new int[2];
            selection.getModelInterval(endModels, offsets);
            WmiCompositeModel startTableModel = WmiModelUtil.findAncestorOfTag(endModels[0], WmiModelTag.MATH_TABLE_CELL);
            WmiCompositeModel endTableModel = WmiModelUtil.findAncestorOfTag(endModels[1], WmiModelTag.MATH_TABLE_CELL);
            WmiCompositeModel startWrapper = WmiModelUtil.findAncestorOfTag(endModels[0], WmiModelTag.MATH);
            WmiCompositeModel endWrapper = WmiModelUtil.findAncestorOfTag(endModels[1], WmiModelTag.MATH);
            if (startTableModel != null && endTableModel != startTableModel) {
                isSelectionOk = false;
            } else if (endTableModel != null && endTableModel != startTableModel) {
                isSelectionOk = false;
            }
            if (startWrapper != endWrapper) {
                isSelectionOk = false;
            }
        }
        if (!marker.isReadOnly() && isSelectionOk) {
            if (updateName == null) {
                updateName = INSTANCE.getResource(5);
            }
            WmiInsertTokenCommand.insertMathToken(Character.toString(character), docView, updateName, false);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static void insertComposedText(String inputMethodText, WmiMathDocumentView docView, String updateName) {
        WmiInsertTokenCommand.insertMathToken(inputMethodText, docView, updateName, true);
    }

    public static WmiTextModel createComposedText(WmiMathDocumentView docView, String updateName) {
        return WmiInsertTokenCommand.insertMathToken("", docView, updateName, true);
    }

    public static void insertMathToken(char character, WmiMathDocumentView docView, String updateName) {
        WmiInsertTokenCommand.insertMathToken(Character.toString(character), docView, updateName, false);
    }

    /*
     * Exception decompiling
     */
    public static WmiTextModel insertMathToken(String input, WmiMathDocumentView docView, String updateName, boolean isInputMethodRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static WmiModelPosition updatePositionForSoftReturn(WmiModelPosition pos) throws WmiNoReadAccessException {
        WmiModel model = pos.getModel();
        WmiCompositeModel parent = WmiModelUtil.findAncestorOfTag(model, INVALID_NEWLINE_PARENTS);
        boolean repos = false;
        while (parent != null) {
            repos = true;
            model = parent;
            parent = WmiModelUtil.findAncestorOfTag(model, INVALID_NEWLINE_PARENTS);
        }
        if (repos) {
            pos = new WmiModelPosition(model, -1);
        }
        return pos;
    }
}

