/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class WmiMetadataManager {
    public static final int VISIBILITY_OFF = 0;
    public static final int VISIBILITY_ROLLOVER = 1;
    public static final int VISIBILITY_ON = 2;
    public static final String DOC_ATTRIBUTE_TAG = "0";
    private WmiMathDocumentModel myModel = null;
    private HashMap categoryMap = new HashMap();
    protected HashMap tagMap = new HashMap();
    private long nextTagId = 1L;
    private boolean defaultCategorySetModified;
    private int decoratorVisibility = 0;
    private boolean popupVisibility = false;

    public WmiMetadataManager(WmiMathDocumentModel model) {
        this.myModel = model;
        this.createCategory("<default>");
        this.defaultCategorySetModified = false;
    }

    public void clearAllTables() {
        this.categoryMap.clear();
        this.tagMap.clear();
        this.nextTagId = 1L;
        this.defaultCategorySetModified = false;
    }

    public synchronized String getNextTagId() {
        String id;
        while (this.tagMap.containsKey(id = Long.toString(++this.nextTagId))) {
        }
        return id;
    }

    public synchronized void resetNextTagId() {
        this.nextTagId = 1L;
    }

    public WmiMetatag createMetatag(String id, String category, String name) {
        String tagId;
        WmiMetatag tag = null;
        String string = tagId = id == null ? this.getNextTagId() : id;
        if (!this.tagMap.containsKey(tagId)) {
            tag = new WmiMetatag(tagId, category, name);
            this.tagMap.put(tagId, tag);
            try {
                this.nextTagId = Math.max((long)Integer.parseInt(tagId), this.nextTagId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tag;
    }

    public WmiMetatag createMetatag(String category, String name) {
        return this.createMetatag(null, category, name);
    }

    public WmiMetatag createMetatag() {
        return this.createMetatag(null, "<default>", "<default>");
    }

    public WmiMetatag duplicateMetatag(String tagID) {
        WmiMetatag newTag = null;
        WmiMetatag oldTag = this.findMetatag(tagID);
        if (oldTag != null) {
            newTag = this.duplicateMetatag(oldTag);
        }
        return newTag;
    }

    public WmiMetatag duplicateMetatag(WmiMetatag source) {
        WmiMetatag newTag = null;
        if (source != null) {
            newTag = source.copyTag();
            newTag.setId(this.getNextTagId());
            this.tagMap.put(newTag.getId(), newTag);
        }
        return newTag;
    }

    public WmiMetatag findMetatag(String id) {
        WmiMetatag theTag = null;
        if (id != null) {
            theTag = (WmiMetatag)this.tagMap.get(id);
        }
        return theTag;
    }

    public void deleteMetatag(WmiMetatag tagToDelete) {
        if (this.tagMap.containsKey(tagToDelete.getId())) {
            this.tagMap.remove(tagToDelete.getId());
        }
    }

    public void deleteAllMetatags() {
        this.tagMap.clear();
    }

    public void purgeUnusedTags() {
        Vector<String> usedIDs;
        block14: {
            Vector modelList = new Vector();
            usedIDs = new Vector<String>();
            boolean locked = WmiModelLock.readLock(this.myModel, true);
            if (locked) {
                try {
                    try {
                        WmiModelUtil.collectModels((WmiModel)this.myModel, WmiModelTag.METATAG_WRAPPER, modelList);
                        if (modelList.size() > 0) {
                            for (WmiMetatagWrapperModel m : modelList) {
                                usedIDs.add(m.getMetatagId());
                            }
                        }
                    }
                    catch (WmiNoReadAccessException nrae) {
                        WmiErrorLog.log(nrae);
                        WmiModelLock.readUnlock(this.myModel);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    WmiModelLock.readUnlock(this.myModel);
                    throw throwable;
                }
                WmiModelLock.readUnlock(this.myModel);
            }
        }
        if (usedIDs.size() > 0) {
            Set listIDs = this.tagMap.keySet();
            Iterator ki = listIDs.iterator();
            Vector<String> unusedTags = new Vector<String>();
            while (ki.hasNext()) {
                String id = (String)ki.next();
                if (DOC_ATTRIBUTE_TAG.equals(id) || usedIDs.contains(id)) continue;
                unusedTags.add(id);
            }
            if (unusedTags.size() > 0) {
                Iterator tag = unusedTags.iterator();
                while (tag.hasNext()) {
                    this.deleteMetatag(this.findMetatag(tag.next().toString()));
                }
            }
        } else if (!this.tagMap.containsKey(DOC_ATTRIBUTE_TAG)) {
            this.tagMap.clear();
        }
    }

    public WmiMetatagCategory createCategory(String name) {
        WmiMetatagCategory cat = null;
        if (!this.categoryMap.containsKey(name)) {
            cat = new WmiMetatagCategory(name);
            this.categoryMap.put(name, cat);
        }
        this.defaultCategorySetModified = true;
        return cat;
    }

    public boolean addMetatagCategory(WmiMetatagCategory cat) {
        boolean success = false;
        if (!this.categoryMap.containsKey(cat.getName())) {
            this.categoryMap.put(cat.getName(), cat);
            success = true;
        }
        this.defaultCategorySetModified = true;
        return success;
    }

    public WmiMetatagCategory findCategory(String name) {
        return (WmiMetatagCategory)this.categoryMap.get(name);
    }

    public Set getCategoryList() {
        return new TreeSet(this.categoryMap.keySet());
    }

    public void replaceCategoryList(HashMap newList) {
        this.categoryMap = newList;
        this.defaultCategorySetModified = true;
    }

    public HashMap getCategoryListCopy() {
        HashMap<String, WmiMetatagCategory> mapCopy = new HashMap<String, WmiMetatagCategory>();
        Iterator i = this.categoryMap.values().iterator();
        while (i.hasNext()) {
            WmiMetatagCategory c = new WmiMetatagCategory((WmiMetatagCategory)i.next());
            mapCopy.put(c.getName(), c);
        }
        return mapCopy;
    }

    public Set getMetatagIdList() {
        return new TreeSet(this.tagMap.keySet());
    }

    public boolean metadataWasModified() {
        return this.defaultCategorySetModified || !this.tagMap.isEmpty();
    }

    public int getDecoratorVisibility() {
        return this.decoratorVisibility;
    }

    public void setDecoratorVisibility(int vis) {
        if (vis < 0 || vis > 2) {
            throw new IllegalArgumentException("Invalid decorator visibility specified: " + vis);
        }
        this.decoratorVisibility = vis;
    }

    public boolean getPopupVisibility() {
        return this.popupVisibility;
    }

    public void setPopupVisibility(boolean vis) {
        this.popupVisibility = vis;
    }

    public WmiMathDocumentModel getModel() {
        return this.myModel;
    }
}

