/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.controller.metadata.WmiCategoryChangeDialog;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagAttributeTable;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagCategoriesDialog;
import com.maplesoft.mathdoc.dialog.WmiDialog;
import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.mathdoc.dialog.WmiDialogLabel;
import com.maplesoft.mathdoc.dialog.WmiDialogTextField;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WmiMetatagEditorDialog
extends WmiDialog
implements ItemListener {
    protected static final String RESOURCE_PATH = "com.maplesoft.mathdoc.controller.metadata.resources.Metadata";
    private static final int LABEL_FIELD_WIDTH = 35;
    private static final int LBL_CAT_PANEL_ROWS = 2;
    private static final int LBL_CAT_PANEL_COLS = 2;
    private static final int LBL_CAT_PANEL_TOP_MARGIN = 0;
    private static final int LBL_CAT_PANEL_LEFT_MARGIN = 0;
    private static final int LBL_CAT_PANEL_X_PADDING = 0;
    private static final int LBL_CAT_PANEL_Y_PADDING = 20;
    private WmiDialogLabel mtLabelLbl = null;
    private WmiDialogLabel mtCategoryLbl = null;
    private WmiDialogLabel mtAttributesLbl = null;
    private WmiDialogTextField mtLabelFld = null;
    private JComboBox mtCategoryCombo = null;
    private WmiMetatagAttributeTable mtAttrTable = null;
    private JScrollPane mtTablePane = null;
    private WmiDialogButton mtNewCategoryBtn = null;
    private WmiDialogButton mtAddAttributeBtn = null;
    private WmiDialogButton mtRemoveAttributeBtn = null;
    private WmiDialogButton mtCancelBtn = null;
    private WmiDialogButton mtOKBtn = null;
    private JFrame parentFrame = null;
    private WmiMetadataManager dataMgr;
    private WmiMetatag srcTag = null;
    private WmiMetatag dstTag = null;
    private boolean tagEdited = false;
    private boolean categoryComboIsUpdating = false;

    public WmiMetatagEditorDialog(JFrame frame, WmiMetadataManager mgr, WmiMetatag tag) {
        super(frame);
        this.parentFrame = frame;
        this.dataMgr = mgr;
        this.srcTag = tag;
        this.dstTag = tag.copyTag();
        this.setTitle("MTED_Title");
        this.createDialogComponents();
        this.layoutDialog();
    }

    public boolean editTag() {
        this.show();
        return this.tagEdited;
    }

    @Override
    protected void addComponents() {
        GridBagLayout lm = new GridBagLayout();
        this.getContentPane().setLayout(lm);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 8, 8);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.mtLabelLbl, c);
        c.gridx = 1;
        c.gridwidth = 5;
        this.getContentPane().add((Component)this.mtLabelFld, c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.1;
        this.getContentPane().add((Component)this.mtCategoryLbl, c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridwidth = 4;
        this.getContentPane().add((Component)this.mtCategoryCombo, c);
        c.gridx = 5;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.fill = 0;
        c.anchor = 22;
        this.getContentPane().add((Component)this.mtNewCategoryBtn, c);
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 1.0;
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 6;
        this.getContentPane().add((Component)this.mtTablePane, c);
        c.gridy = 3;
        c.insets = new Insets(11, 0, 0, 8);
        c.fill = 0;
        c.weightx = 0.1;
        c.gridx = 0;
        c.gridwidth = 5;
        c.anchor = 21;
        this.getContentPane().add((Component)this.createEditButtonPanel(), c);
        c.weightx = 0.1;
        c.gridx = 5;
        c.gridwidth = 2;
        c.anchor = 22;
        this.getContentPane().add((Component)this.createDefaultButtonsPanel(), c);
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    protected void createDialogComponents() {
        this.mtLabelLbl = this.createLabel("MTED_Label");
        this.mtCategoryLbl = this.createLabel("MTED_Category");
        this.mtAttributesLbl = this.createLabel("MTED_Attributes");
        this.mtLabelFld = new WmiDialogTextField(35);
        String tagName = this.dstTag.getName();
        if (tagName.length() == 0) {
            this.mtLabelFld.setText("<default>");
        } else {
            this.mtLabelFld.setText(this.dstTag.getName());
        }
        this.mtCategoryCombo = new JComboBox();
        this.resyncCategoriesCombo(true);
        this.mtCategoryCombo.addItemListener(this);
        this.mtAttrTable = new WmiMetatagAttributeTable(this.dstTag);
        this.mtTablePane = new JScrollPane(this.mtAttrTable, 22, 31);
        this.mtNewCategoryBtn = this.createButton("MTED_EditCategories");
        this.mtNewCategoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiMetatagEditorDialog.this.newCategoryAction();
            }
        });
        this.mtAddAttributeBtn = this.createButton("MTED_AddAttribute");
        this.mtAttrTable.setAddButton(this.mtAddAttributeBtn);
        this.mtRemoveAttributeBtn = this.createButton("MTED_RemoveAttribute");
        this.mtAttrTable.setDeleteButton(this.mtRemoveAttributeBtn);
        this.mtCancelBtn = this.createCancelButton();
        this.mtOKBtn = this.createOKButton();
    }

    private JPanel createEditButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.mtAddAttributeBtn);
        panel.add(this.mtRemoveAttributeBtn);
        return panel;
    }

    private void resyncCategoriesCombo(boolean rebuild) {
        this.categoryComboIsUpdating = true;
        String catString = this.dstTag.getCategory();
        if (rebuild) {
            this.mtCategoryCombo.removeAllItems();
            Iterator ci = this.dataMgr.getCategoryList().iterator();
            while (ci.hasNext()) {
                String cat = ci.next().toString();
                this.mtCategoryCombo.addItem(cat);
            }
        }
        boolean categoryValid = false;
        int numItems = this.mtCategoryCombo.getItemCount();
        int i = 0;
        while (i < numItems) {
            String item;
            Object o = this.mtCategoryCombo.getItemAt(i);
            if (o != null && (item = o.toString()).equals(this.dstTag.getCategory())) {
                categoryValid = true;
                break;
            }
            ++i;
        }
        if (categoryValid) {
            this.mtCategoryCombo.setSelectedItem(this.dstTag.getCategory());
        }
        this.categoryComboIsUpdating = false;
    }

    private void resyncCategoriesCombo() {
        this.resyncCategoriesCombo(false);
    }

    protected void changeCategory(String newKey) {
        boolean doSwap = false;
        String curKey = this.dstTag.getCategory();
        if (curKey == null) {
            doSwap = true;
        } else if (newKey != null && !curKey.equals(newKey)) {
            doSwap = true;
        }
        if (doSwap) {
            int action = 1;
            WmiMetatagCategory cat = this.dataMgr.findCategory(newKey);
            if (cat != null) {
                if (cat.getAttributeCount() > 0) {
                    WmiCategoryChangeDialog dlg = new WmiCategoryChangeDialog(this);
                    action = dlg.runDialog();
                }
            } else {
                action = 0;
            }
            if (action != 0) {
                this.dstTag.setCategory(cat, action);
            }
            this.resyncCategoriesCombo();
            this.mtAttrTable.reloadTable();
        }
    }

    protected void newCategoryAction() {
        WmiMetatagCategoriesDialog dlg = new WmiMetatagCategoriesDialog(this.parentFrame, this.dataMgr);
        if (dlg.editCategories()) {
            this.resyncCategoriesCombo(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object o;
        if (e.getSource() == this.mtCategoryCombo && !this.categoryComboIsUpdating && e.getID() == 701 && e.getStateChange() == 1 && (o = this.mtCategoryCombo.getSelectedItem()) != null) {
            this.changeCategory(o.toString());
        }
    }

    @Override
    protected void cancelAction() {
        this.tagEdited = false;
        super.cancelAction();
    }

    @Override
    protected void okAction() {
        this.dstTag.setName(this.mtLabelFld.getText());
        this.dstTag.setCategory(this.mtCategoryCombo.getSelectedItem().toString());
        this.mtAttrTable.unloadTable();
        this.srcTag.reloadFromTag(this.dstTag);
        this.tagEdited = true;
        super.okAction();
    }
}

