/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.components.WmiSmoothFadeContainer;
import com.maplesoft.mathdoc.model.WmiMetatag;
import java.awt.Color;
import java.awt.Container;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WmiMetatagInfoPopup
extends WmiSmoothFadeContainer {
    public WmiMetatagInfoPopup(Container host, WmiMetatag tag) {
        super(host, true, 0.0f, 0.9f);
        this.setBackground(Color.BLACK);
        JComponent contentPane = this.createContents(tag);
        contentPane.doLayout();
        this.add(contentPane);
        this.setSize(contentPane.getPreferredSize());
    }

    protected JComponent createContents(WmiMetatag tag) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setForeground(Color.WHITE);
        panel.setBackground(Color.BLACK);
        JLabel tc = this.generatePopupContent(tag);
        tc.setForeground(Color.WHITE);
        panel.add(tc);
        panel.setSize(panel.getPreferredSize());
        return panel;
    }

    protected JLabel generatePopupContent(WmiMetatag tag) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><table><small>");
        buffer.append("<tr><td><b>Category:</b></td>");
        buffer.append("<td>");
        buffer.append(this.stringToHTMLString(tag.getCategory()));
        buffer.append("</td></tr>");
        buffer.append("<tr><td><b>Name:</b></td>");
        buffer.append("<td>");
        buffer.append(this.stringToHTMLString(tag.getName()));
        buffer.append("</td></tr>");
        Set attrKeySet = tag.getAttributeKeySet();
        if (!attrKeySet.isEmpty()) {
            buffer.append("<tr><td colspan=2 height=3 align=center valign=center><hr></td></tr>");
            buffer.append("<tr><td colspan=2 align=center><b>Attributes</b></td></tr>");
            for (String key : attrKeySet) {
                String val = tag.getAttribute(key);
                buffer.append("<tr>");
                buffer.append("<td>" + this.stringToHTMLString(key) + ":</td>");
                buffer.append("<td>" + this.stringToHTMLString(val) + "</td>");
                buffer.append("</tr>");
            }
        }
        buffer.append("</small></table></html>");
        return new JLabel(buffer.toString());
    }

    protected String stringToHTMLString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("&lt;br/&gt;");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(new Integer(ci).toString());
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

