/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Point;

public class WmiMoveLeft
extends WmiNavigationCommand {
    public WmiMoveLeft() {
        super("move.left");
    }

    protected WmiMoveLeft(String name) {
        super(name);
    }

    @Override
    public boolean updatePosition(WmiViewNavigator navigator) throws WmiNoReadAccessException {
        boolean success = false;
        if (!this.isSelectionCommand() && RuntimePlatform.isMac()) {
            success = navigator.updateLeftRightSelectionEndpoint(-1);
        }
        if (!success) {
            WmiView view = navigator.getReferenceView();
            int offset = navigator.getViewOffset();
            if (WmiViewUtil.isTraversableView(view)) {
                WmiTraversableView traversable = (WmiTraversableView)view;
                int type = traversable.getTraversalType();
                if (type == 1) {
                    if (offset > 0) {
                        navigator.updatePosition(view, --offset);
                        success = true;
                    }
                } else if ((type & 4) != 0 && offset != 0) {
                    if (traversable instanceof WmiCompositeView) {
                        WmiPositionInView pinv = new WmiPositionInView(traversable, new Point(traversable.getHorizontalOffset() + traversable.getWidth(), traversable.getVerticalOffset() + traversable.getHeight()));
                        WmiViewPosition pos = WmiViewUtil.findNearestView(pinv.getView(), pinv.getPosition());
                        pos.snapToPosition(false);
                        navigator.updatePosition(pos.getView(), pos.getOffset());
                        success = true;
                    } else if ((type & 2) != 0) {
                        navigator.updatePosition(traversable, 0);
                        success = true;
                    }
                }
            }
            if (!success) {
                success = navigator.updateLeftRight(-1);
            }
            if (!success && !this.isSelectionCommand()) {
                WmiSelection selection;
                WmiMathDocumentView docView = view.getDocumentView();
                WmiSelection wmiSelection = selection = docView != null ? docView.getSelection() : null;
                if (selection != null) {
                    navigator.updatePosition(view, offset);
                    success = true;
                }
            }
        }
        return success;
    }
}

