/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public abstract class WmiMovePageCommand
extends WmiNavigationCommand {
    protected WmiMovePageCommand(String name) {
        super(name);
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException {
        WmiView view = WmiMovePageCommand.getView(event);
        if (view != null) {
            WmiMathDocumentView docView = view.getDocumentView();
            Rectangle pageBounds = docView.getVisibleRegion();
            int xPos = 0;
            int yPos = 0;
            boolean doMove = false;
            if (!RuntimePlatform.isMac() || this.isSelectionCommand()) {
                WmiPositionMarker marker = docView.getPositionMarker();
                if (marker != null) {
                    doMove = true;
                    Rectangle markerBounds = marker.getBounds();
                    xPos = markerBounds.x + markerBounds.width / 2;
                    yPos = this.getDirection() < 0 ? markerBounds.y - pageBounds.height : markerBounds.y + markerBounds.height + pageBounds.height;
                }
            } else {
                doMove = true;
                xPos = pageBounds.x;
                int n = yPos = this.getDirection() < 0 ? pageBounds.y - pageBounds.height : pageBounds.y + pageBounds.height;
            }
            if (doMove) {
                WmiCommandProxy command;
                if (yPos < 0) {
                    command = WmiCommand.getCommandProxy(this.isSelectionCommand() ? "select.document.start" : "move.document.start");
                    try {
                        ((WmiCommand)command).doCommand(event);
                    }
                    catch (WmiNoWriteAccessException e) {
                        WmiErrorLog.log(e);
                    }
                    doMove = false;
                } else if (yPos > docView.getHeight()) {
                    command = WmiCommand.getCommandProxy(this.isSelectionCommand() ? "select.document.end" : "move.document.end");
                    try {
                        ((WmiCommand)command).doCommand(event);
                    }
                    catch (WmiNoWriteAccessException e) {
                        WmiErrorLog.log(e);
                    }
                    doMove = false;
                }
                if (doMove) {
                    if (!RuntimePlatform.isMac() || this.isSelectionCommand()) {
                        this.moveTo(docView, xPos, yPos);
                    } else {
                        docView.setScrollPosition(xPos, yPos, true);
                    }
                }
            }
        }
    }

    private void moveTo(WmiMathDocumentView docView, int xPos, int yPos) throws WmiNoReadAccessException {
        WmiViewPosition pos = WmiViewUtil.findNearestView(docView, new Point(xPos, yPos));
        WmiViewNavigator navigator = new WmiViewNavigator(pos.getView(), pos.getOffset(), this.isSelectionCommand());
        navigator.updateMarker();
    }

    protected abstract int getDirection();

    @Override
    public boolean updatePosition(WmiViewNavigator navigator) throws WmiNoReadAccessException {
        return false;
    }
}

