/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import java.awt.event.ActionEvent;

public class WmiMoveToBaselineCommand
extends WmiNavigationCommand {
    private static final String DEFAULT_NAME = "move.math.baseline";

    protected WmiMoveToBaselineCommand(String name) {
        super(name);
    }

    public WmiMoveToBaselineCommand() {
        this(DEFAULT_NAME);
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException {
        WmiView view = WmiMoveToBaselineCommand.getView(event);
        if (view != null && this.isEnabled(view)) {
            WmiModel basePosition;
            WmiMathDocumentView docView = view.getDocumentView();
            WmiMathCaret caret = (WmiMathCaret)docView.getPositionMarker();
            WmiModel targetPosition = basePosition = caret.getModelPosition().getModel();
            WmiCompositeModel parent = basePosition.getParent();
            if (!(parent instanceof WmiMathWrapperModel)) {
                WmiCompositeModel grandParent = parent.getParent();
                while (!(grandParent instanceof WmiMathWrapperModel)) {
                    targetPosition = parent;
                    parent = targetPosition.getParent();
                    grandParent = parent.getParent();
                }
            }
            int index = 1 + parent.indexOf(targetPosition);
            int finalIndex = 0;
            if (index >= parent.getChildCount()) {
                --index;
                finalIndex = -1;
            }
            WmiModel nextModel = parent.getChild(index);
            while (index > 1 && parent.getChild(index - 1) instanceof WmiInlineMathModel) {
                parent = (WmiCompositeModel)parent.getChild(index - 1);
                index = parent.getChildCount() - 1;
                nextModel = parent.getChild(index);
            }
            if (nextModel == basePosition) {
                finalIndex = -1;
            }
            WmiModelPosition pos = new WmiModelPosition(nextModel, finalIndex);
            docView.updatePosition(pos, 1);
        }
    }

    @Override
    public boolean isEnabled(WmiView view) {
        boolean enabled = false;
        if (view != null) {
            WmiMathDocumentView docView = view.getDocumentView();
            WmiPositionMarker marker = docView.getPositionMarker();
            enabled = marker instanceof WmiMathCaret;
        }
        return enabled;
    }

    @Override
    public boolean updatePosition(WmiViewNavigator navigator) {
        return false;
    }
}

