/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.util.RuntimePlatform;

public abstract class WmiMoveWordCommand
extends WmiNavigationCommand {
    protected WmiMoveWordCommand(String name) {
        super(name);
    }

    protected boolean isWordSeparator(char c) {
        boolean separator = false;
        if (Character.isWhitespace(c)) {
            separator = true;
        } else if (RuntimePlatform.isMac()) {
            int charType = Character.getType(c);
            separator = charType == 8 || charType == 23 || charType == 21 || charType == 22 || charType == 24;
        }
        return separator;
    }

    public boolean[] findWordSeparators(String text) {
        boolean UNKNOWN = false;
        boolean WORD = true;
        int NUMBER = 2;
        int WORD_WHITESPACE = 3;
        int NUMBER_WHITESPACE = 4;
        int OTHER_WHITESPACE = 6;
        int OTHER = 7;
        int POST_DECIMAL = 10;
        int tlen = text.length() + 1;
        boolean[] breaks = new boolean[tlen];
        if (tlen > 0) {
            int state = 0;
            int i = 0;
            while (i < tlen) {
                char ch;
                char c = ch = i < text.length() ? (char)text.charAt(i) : (char)' ';
                if (state == 3) {
                    if (Character.isWhitespace(ch)) {
                        breaks[i] = false;
                    } else {
                        state = 0;
                    }
                } else if (state == 4 || state == 6) {
                    if (Character.isWhitespace(ch)) {
                        breaks[i] = false;
                    } else {
                        state = 0;
                    }
                } else if (state == 2) {
                    if (Character.isDigit(ch)) {
                        breaks[i] = false;
                    } else if (ch == '.') {
                        breaks[i] = false;
                        state = 10;
                    } else if (Character.isWhitespace(ch)) {
                        breaks[i] = false;
                        state = 4;
                    } else {
                        state = 0;
                    }
                } else if (state == 10) {
                    if (Character.isDigit(ch)) {
                        breaks[i] = false;
                    } else if (Character.isWhitespace(ch)) {
                        breaks[i] = false;
                        state = 4;
                    } else {
                        state = 0;
                    }
                } else if (state == 1) {
                    if (Character.isWhitespace(ch)) {
                        breaks[i] = false;
                        state = 3;
                    } else if (ch != '-') {
                        breaks[i] = false;
                    } else {
                        state = 6;
                    }
                } else if (state == 7) {
                    if (Character.isWhitespace(ch)) {
                        breaks[i] = false;
                        state = 6;
                    } else {
                        state = 0;
                    }
                }
                if (state == 0) {
                    breaks[i] = true;
                    state = Character.isLetter(ch) ? 1 : (Character.isDigit(ch) ? 2 : 7);
                }
                ++i;
            }
        }
        char c = text.charAt(text.length() - 1);
        breaks[breaks.length - 1] = Character.isWhitespace(c);
        return breaks;
    }

    private boolean moveByWordTextPC(WmiViewNavigator navigator, int offset, int direction) throws WmiNoReadAccessException {
        int viewOffset;
        int directionMovement = direction == 3 ? 1 : -1;
        int directionLook = direction == 3 ? 0 : -1;
        boolean success = false;
        WmiView view = navigator.getReferenceView();
        int currentOffset = viewOffset = navigator.getViewOffset();
        if (view instanceof WmiTextView) {
            WmiTextView textView = (WmiTextView)view;
            String text = textView.getText();
            if (direction == 3 && currentOffset >= text.length() || direction == 2 && currentOffset == 0) {
                navigator.updateLeftRight(directionMovement);
                if (navigator.getReferenceView() == view) {
                    navigator.updatePosition(view, direction == 3 ? -1 : 0);
                    success = true;
                }
                if (WmiViewUtil.findAncestorOfClass(view = navigator.getReferenceView(), WmiMathInlineView.class) != null) {
                    success = true;
                } else if (view instanceof WmiTextView) {
                    textView = (WmiTextView)view;
                    text = textView.getText();
                    currentOffset = direction == 3 ? 0 : -1;
                    success = true;
                }
            }
            currentOffset += directionMovement;
            while (!success) {
                char lastChar;
                char curChar;
                if (direction == 3 && currentOffset >= text.length()) {
                    navigator.updateLeftRight(directionMovement);
                    if (navigator.getReferenceView() == view) {
                        navigator.updatePosition(view, direction == 3 ? -1 : 0);
                        success = true;
                        continue;
                    }
                    view = navigator.getReferenceView();
                    if (WmiViewUtil.findAncestorOfClass(view, WmiMathInlineView.class) != null) {
                        success = true;
                        continue;
                    }
                    if (view instanceof WmiTextView) {
                        textView = (WmiTextView)view;
                        text = textView.getText();
                        currentOffset = direction == 3 ? 0 : -1;
                        success = true;
                        continue;
                    }
                }
                if (direction == 3) {
                    if (currentOffset <= 0) continue;
                    curChar = text.charAt(currentOffset);
                    lastChar = text.charAt(currentOffset - 1);
                    if (Character.isLetterOrDigit(curChar) && !Character.isLetterOrDigit(lastChar) || this.isPunctuation(curChar) && !this.isPunctuation(lastChar)) {
                        navigator.updatePosition(view, currentOffset);
                        success = true;
                        continue;
                    }
                    ++currentOffset;
                    continue;
                }
                if (currentOffset == 0) {
                    navigator.updatePosition(view, currentOffset);
                    success = true;
                    continue;
                }
                curChar = text.charAt(currentOffset);
                lastChar = text.charAt(currentOffset - 1);
                if (Character.isLetterOrDigit(curChar) && !Character.isLetterOrDigit(lastChar) || this.isPunctuation(curChar) && !this.isPunctuation(lastChar)) {
                    navigator.updatePosition(view, currentOffset);
                    success = true;
                    continue;
                }
                --currentOffset;
            }
        }
        return success;
    }

    private boolean isPunctuation(char c) {
        return !Character.isLetterOrDigit(c) && !Character.isWhitespace(c);
    }

    private boolean moveByWordTextMac(WmiViewNavigator navigator, int offset, int direction) throws WmiNoReadAccessException {
        int viewOffset;
        int directionMovement = direction == 3 ? 1 : -1;
        int directionLook = direction == 3 ? 0 : -1;
        boolean success = false;
        WmiView view = navigator.getReferenceView();
        int currentOffset = viewOffset = navigator.getViewOffset();
        if (view instanceof WmiTextView) {
            WmiTextView textView = (WmiTextView)view;
            String text = textView.getText();
            if (direction == 3 && currentOffset >= text.length() || direction == 2 && currentOffset == 0) {
                navigator.updateLeftRight(directionMovement);
                if (navigator.getReferenceView() == view) {
                    navigator.updatePosition(view, direction == 3 ? -1 : 0);
                    success = true;
                }
                if (WmiViewUtil.findAncestorOfClass(view = navigator.getReferenceView(), WmiMathInlineView.class) != null) {
                    success = true;
                } else if (view instanceof WmiTextView) {
                    textView = (WmiTextView)view;
                    text = textView.getText();
                    currentOffset = direction == 3 ? 0 : -1;
                    success = true;
                }
            }
            while (!success) {
                if (Character.isLetterOrDigit(text.charAt(currentOffset + directionLook))) break;
                if ((direction != 3 || (currentOffset += directionMovement) < text.length()) && (direction != 2 || currentOffset > 0)) continue;
                navigator.updateLeftRight(directionMovement);
                view = navigator.getReferenceView();
                if (WmiViewUtil.findAncestorOfClass(view, WmiMathInlineView.class) != null) {
                    success = true;
                    continue;
                }
                if (!(view instanceof WmiTextView)) continue;
                textView = (WmiTextView)view;
                text = textView.getText();
                int n = currentOffset = direction == 3 ? 0 : text.length() - 1;
            }
            while (!success) {
                if (direction == 3 && currentOffset >= text.length() || direction == 2 && currentOffset == 0) {
                    navigator.updatePosition(view, direction == 3 ? -1 : 0);
                    success = true;
                    break;
                }
                if (Character.isLetterOrDigit(text.charAt(currentOffset + directionLook))) {
                    currentOffset += directionMovement;
                    continue;
                }
                if (text.charAt(currentOffset + directionLook) == '.') {
                    if (currentOffset + directionLook - 1 >= 0 && currentOffset + directionLook + 1 < text.length() && Character.isDigit(text.charAt(currentOffset + directionLook - 1)) && Character.isDigit(text.charAt(currentOffset + directionLook + 1))) {
                        currentOffset += directionMovement;
                        continue;
                    }
                    navigator.updatePosition(view, currentOffset);
                    success = true;
                    continue;
                }
                navigator.updatePosition(view, currentOffset);
                success = true;
            }
        }
        return success;
    }

    private boolean moveByWordMath(WmiViewNavigator navigator, int offset, int direction) throws WmiNoReadAccessException {
        WmiView nextView;
        WmiMathTextView textReference;
        boolean success = false;
        WmiView reference = navigator.getReferenceView();
        WmiMathInlineView mathView = (WmiMathInlineView)WmiViewUtil.findAncestorOfClass(reference, WmiMathInlineView.class);
        if (direction == 3) {
            if (reference instanceof WmiMathTextView) {
                textReference = (WmiMathTextView)reference;
                if (navigator.getViewOffset() != -1 && navigator.getViewOffset() != textReference.getLength()) {
                    navigator.updatePosition(textReference, -1);
                    success = true;
                }
            }
            if (!success) {
                nextView = WmiViewUtil.findNextDescendantOfClass(mathView, reference, WmiMathTextView.class);
                if (nextView != null) {
                    navigator.updatePosition(nextView, -1);
                    success = true;
                } else {
                    nextView = WmiViewUtil.findNextDescendantOfClass(mathView.getDocumentView(), mathView, WmiView.class);
                    if (nextView != null) {
                        navigator.updatePosition(nextView, 0);
                        success = true;
                    }
                }
            }
        }
        if (direction == 2) {
            if (reference instanceof WmiMathTextView) {
                textReference = (WmiMathTextView)reference;
                if (navigator.getViewOffset() != 0) {
                    navigator.updatePosition(textReference, 0);
                    success = true;
                }
            }
            if (!success) {
                nextView = WmiViewUtil.findPreviousDescendantOfClass(mathView, reference, WmiMathTextView.class);
                if (nextView != null) {
                    navigator.updatePosition(nextView, 0);
                    success = true;
                } else {
                    nextView = WmiViewUtil.findPreviousDescendantOfClass(mathView.getDocumentView(), mathView, WmiView.class);
                    if (nextView != null) {
                        navigator.updatePosition(nextView, -1);
                        success = true;
                    }
                }
            }
        }
        return success;
    }

    protected boolean moveByWord(WmiViewNavigator navigator, int offset, int direction) throws WmiNoReadAccessException {
        WmiView reference = navigator.getReferenceView();
        if (WmiViewUtil.findAncestorOfClass(reference, WmiMathInlineView.class) == null) {
            if (RuntimePlatform.isMac()) {
                return this.moveByWordTextMac(navigator, offset, direction);
            }
            return this.moveByWordTextPC(navigator, offset, direction);
        }
        return this.moveByWordMath(navigator, offset, direction);
    }

    protected boolean moveByLine(WmiViewNavigator navigator, int direction) throws WmiNoReadAccessException {
        boolean success = true;
        if (direction == 3 && navigator.updateRow(1)) {
            navigator.updateOffset(0);
            this.updatePosition(navigator);
        } else if (direction == 2 && navigator.updateRow(-1)) {
            String text = navigator.getText();
            navigator.updateOffset(text.length());
            this.updatePosition(navigator);
        } else {
            success = false;
        }
        return success;
    }

    protected boolean moveByModel(WmiViewNavigator navigator, int direction) throws WmiNoReadAccessException {
        boolean success = false;
        WmiView view = navigator.getReferenceView();
        int viewOffset = navigator.getViewOffset();
        int length = WmiViewNavigator.getWidth(view);
        if (direction == 3 && viewOffset < length - 1) {
            navigator.updatePosition(view, length - 1);
            success = true;
        } else if (direction == 2 && viewOffset > 0) {
            navigator.updatePosition(view, 0);
            success = true;
        } else {
            WmiPositionedView next = null;
            if (WmiViewUtil.isTraversableView(view)) {
                next = ((WmiTraversableView)view).getNextView(direction);
            }
            while (next == null) {
                WmiCompositeView parent = view.getParentView();
                if (!WmiViewUtil.isTraversableView(parent)) break;
                next = ((WmiTraversableView)((Object)parent)).getNextView(direction);
                view = parent;
            }
            if (next != null) {
                if (this.isMath(next)) {
                    int pos = direction == 2 ? 0 : WmiViewNavigator.getWidth(next) - 1;
                    navigator.updatePosition(next, pos);
                    success = true;
                }
            } else {
                success = this.moveByLine(navigator, direction);
            }
        }
        return success;
    }

    protected void emergeFrom2dMath(WmiViewNavigator navigator, int offset) {
        WmiView reference = navigator.getReferenceView();
        while (reference instanceof WmiMathTextView || reference instanceof WmiMathInlineView) {
            reference = WmiViewUtil.findAncestorOfClass(reference, WmiInlineView.class);
        }
        if (reference != null && reference != navigator.getReferenceView()) {
            navigator.updatePosition(reference, offset);
        }
    }

    protected boolean isMath(WmiView view) {
        boolean math = false;
        if (view != null && view.getModel() instanceof WmiMathModel) {
            math = true;
        }
        return math;
    }

    @Override
    public boolean updatePosition(WmiViewNavigator navigator) throws WmiNoReadAccessException {
        boolean success = false;
        WmiView view = navigator.getReferenceView();
        int dir = this.getDirection();
        this.isMath(view);
        if (!success) {
            String text;
            int offset = navigator.getOffset();
            if (dir == 2) {
                if (offset > 0) {
                    success = this.moveByWord(navigator, offset, dir);
                }
            } else if (dir == 3 && offset < (text = navigator.getText()).length()) {
                success = this.moveByWord(navigator, offset, dir);
            }
            if (!success) {
                success = this.moveByLine(navigator, dir);
            }
        }
        return success;
    }

    protected abstract int getDirection();
}

