/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;

public abstract class WmiNavigationCommand
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.navigation.resources.Navigation";
    private boolean justRepeated = false;

    protected WmiNavigationCommand(String name) {
        super(name);
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException {
        WmiPositionMarker marker;
        WmiMathDocumentView docView = WmiNavigationCommand.getDocumentView(event);
        int recordedOffset = -1;
        boolean commandPerformed = false;
        WmiPositionedView view = null;
        int offset = 0;
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            view = marker.getView();
            offset = marker.getOffset();
        }
        if (view != null) {
            WmiPositionedView recordedView = view;
            recordedOffset = offset;
            WmiViewNavigator navigator = new WmiViewNavigator(view, offset, this.isSelectionCommand());
            if (this.updatePosition(navigator)) {
                commandPerformed = true;
                Rectangle oldBounds = null;
                boolean selectionValid = false;
                if (this.isSelectionCommand()) {
                    WmiSelection selection = docView.getSelection();
                    if (selection != null) {
                        oldBounds = selection.getSelectionHighlighter().getBounds();
                        selectionValid = selection.isValid();
                    }
                } else {
                    WmiCaret caret = docView.getCaret();
                    oldBounds = caret != null ? caret.getBounds() : null;
                }
                navigator.updateMarker();
                WmiPositionMarker marker2 = docView.getPositionMarker();
                WmiPositionedView newView = marker2.getView();
                int newOffset = marker2.getOffset();
                if (!this.justRepeated) {
                    boolean noRepeatNecessary = false;
                    boolean forceRepeat = false;
                    Rectangle newBounds = null;
                    if (this.isSelectionCommand()) {
                        boolean newSelectionValid = false;
                        WmiSelection selection = docView.getSelection();
                        if (selection != null) {
                            newBounds = selection.getSelectionHighlighter().getBounds();
                            newSelectionValid = selection.isValid();
                        }
                        if (selectionValid != newSelectionValid && oldBounds == null && newBounds != null || newBounds == null && oldBounds != null) {
                            noRepeatNecessary = true;
                        } else if (!selectionValid && !newSelectionValid) {
                            forceRepeat = true;
                        }
                    } else {
                        WmiCaret caret = docView.getCaret();
                        Rectangle rectangle = newBounds = caret != null ? caret.getBounds() : null;
                    }
                    if (!noRepeatNecessary && (forceRepeat || this.isRepeatNecessary(navigator, oldBounds, newBounds, recordedView, newView, recordedOffset, newOffset, this.isSelectionCommand()))) {
                        this.justRepeated = true;
                        this.addQueueableCommand(this.getName());
                        this.actionPerformed(new ActionEvent(navigator.getReferenceView(), event.getID(), event.getActionCommand()));
                    }
                } else {
                    this.justRepeated = false;
                }
            }
        }
        if (commandPerformed) {
            if (this.shouldSaveHorizontalPosition()) {
                docView.saveLastHorizontalPosition();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean shouldSaveHorizontalPosition() {
        return true;
    }

    private boolean isRepeatNecessary(WmiViewNavigator navigator, Rectangle oldBounds, Rectangle newBounds, WmiView recordedView, WmiView newView, int recordedOffset, int newOffset, boolean isSelection) throws WmiNoReadAccessException {
        boolean repeatNavigation = navigator.viewRepeatable();
        repeatNavigation = (repeatNavigation &= oldBounds != null && newBounds != null) && newBounds.equals(oldBounds);
        return repeatNavigation;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        return view != null;
    }

    protected boolean baselineMatch(WmiPositionedView left, WmiPositionedView right) {
        boolean match = false;
        while (left instanceof WmiCompositeView) {
            left = (WmiPositionedView)((WmiCompositeView)((Object)left)).getChild(((WmiCompositeView)((Object)left)).getChildCount() - 1);
        }
        while (right instanceof WmiCompositeView) {
            right = (WmiPositionedView)((WmiCompositeView)((Object)right)).getChild(0);
        }
        if (left instanceof WmiTextView && right instanceof WmiTextView) {
            if (this.isSelectionCommand()) {
                match = true;
            } else {
                Point pt1 = WmiViewUtil.getAbsoluteOffset(left);
                Point pt2 = WmiViewUtil.getAbsoluteOffset(right);
                if (pt1 != null && pt2 != null) {
                    int y2;
                    int y1 = pt1.y + ((WmiTextView)left).getAdjustedBaseline();
                    match = y1 == (y2 = pt2.y + ((WmiTextView)right).getAdjustedBaseline());
                }
            }
        }
        return match;
    }

    public abstract boolean updatePosition(WmiViewNavigator var1) throws WmiNoReadAccessException;

    public boolean isSelectionCommand() {
        return false;
    }
}

