/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiView;

public abstract class WmiSelectPlaceholder
extends WmiSearchAndSelect {
    public static final String EMPTY_PLACEHOLDER = "%?";

    protected WmiSelectPlaceholder(String name) {
        super(name);
    }

    @Override
    protected WmiModel searchForSelection(WmiView currentView, int currentOffset, int[] offsets) throws WmiNoReadAccessException {
        WmiModel selection = this.searchForPercentQuestionMarkPlaceholder(currentView, currentOffset, offsets);
        if (selection == null) {
            selection = this.searchForStylePlaceholder(currentView, currentOffset, offsets);
        }
        return selection;
    }

    protected WmiTextModel searchForPercentQuestionMarkPlaceholder(WmiView currentView, int currentOffset, int[] offsets) throws WmiNoReadAccessException {
        WmiTextModel selection = null;
        WmiModel model = currentView.getModel();
        boolean scanForwards = this.scanForwards();
        int directionShift = scanForwards ? 1 : -1;
        WmiCompositeModel parent = model.getParent();
        if (parent != null) {
            int searchIndex = parent.indexOfInTraversalOrder(model);
            int length = parent.getChildCount();
            do {
                if (model instanceof WmiTextModel) {
                    WmiTextModel textModel = (WmiTextModel)model;
                    String text = textModel.getText();
                    int currentPosition = -1;
                    currentPosition = this.searchAndUpdateCurrentPosition(text, currentOffset, scanForwards);
                    if (this.isInOffsetRange(currentPosition, currentOffset, scanForwards)) {
                        int modOffset = (scanForwards ? 0 : -3) + currentOffset;
                        currentPosition = this.searchAndUpdateCurrentPosition(text, modOffset, scanForwards);
                    }
                    if (currentPosition > -1) {
                        selection = textModel;
                        offsets[0] = currentPosition;
                        offsets[1] = 2;
                    }
                }
                if (selection != null) continue;
                model = parent.getChildInTraversalOrder(searchIndex += directionShift);
                if (!scanForwards) {
                    if (!(model instanceof WmiTextModel)) continue;
                    currentOffset = ((WmiTextModel)model).getText().length();
                    continue;
                }
                currentOffset = 0;
            } while (selection == null && searchIndex >= 0 && searchIndex < length);
        }
        return selection;
    }

    protected WmiModel searchForStylePlaceholder(WmiView currentView, int currentOffset, int[] offsets) throws WmiNoReadAccessException {
        WmiModel selection = null;
        WmiModel model = currentView.getModel();
        WmiCompositeModel paragraph = WmiModelUtil.findAncestorOfClass(model, WmiParagraphModel.class);
        if (paragraph != null) {
            WmiModel foundModel = null;
            foundModel = this.scanForwards() ? WmiModelUtil.findNextTraversalOrderedModel(paragraph, model, "placeholder", "true") : WmiModelUtil.findPreviousTraversalOrderedModel(paragraph, model, "placeholder", "true");
            if (foundModel instanceof WmiTextModel) {
                selection = (WmiTextModel)foundModel;
                offsets[0] = 0;
                offsets[1] = ((WmiTextModel)selection).getText().length();
            } else if (foundModel instanceof WmiCompositeModel) {
                selection = (WmiCompositeModel)foundModel;
                offsets[0] = 0;
                offsets[1] = 0;
            }
        }
        return selection;
    }

    protected abstract boolean scanForwards();

    private boolean isInOffsetRange(int currentPosition, int currentOffset, boolean scanForwards) {
        int offsetBottom = currentOffset;
        int offsetTop = currentOffset + 2;
        if (!scanForwards) {
            offsetBottom = currentOffset - 2;
            offsetTop = currentOffset;
        }
        return currentPosition >= offsetBottom && currentPosition <= offsetTop;
    }

    private int searchAndUpdateCurrentPosition(String text, int currentOffset, boolean scanForwards) {
        int currentPosition = -1;
        currentPosition = scanForwards ? text.indexOf(EMPTY_PLACEHOLDER, currentOffset) : text.lastIndexOf(EMPTY_PLACEHOLDER, currentOffset);
        return currentPosition;
    }
}

