/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.view.palettes;

import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;

public class WmiPaletteButtonDnDManager {
    public static final String PALETTE_BUTTON_MIME_TYPE = "application/x-java-serialized-object;class=java.io.Serializable";
    public static final Transferable PALETTE_BUTTON_TRANSFERABLE = new PaletteButtonTransferable();
    public static final DataFlavor PALETTE_BUTTON_FLAVOR = new DataFlavor("application/x-java-serialized-object;class=java.io.Serializable", "Maple Palette Button");
    public static AbstractButton dragButton = null;
    public static WmiMathDocumentView dragSourceView = null;
    public PaletteButtonDragListener dragListener = null;

    public WmiPaletteButtonDnDManager() {
        this.dragListener = new PaletteButtonDragListener();
    }

    public WmiPaletteButtonDnDManager(PaletteButtonDragListener dragListener) {
        this.dragListener = dragListener;
    }

    public void installDragGestureListener(AbstractButton b) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(b, 1, this.dragListener);
        dragSource.addDragSourceListener(this.dragListener);
    }

    public boolean handleButtonDrop(WmiMathDocumentView view) {
        boolean success = false;
        if (view == dragSourceView && dragButton != null) {
            ButtonModel model = dragButton.getModel();
            boolean isEnabled = model.isEnabled();
            model.setEnabled(true);
            this.selectPlaceHolder(view);
            dragButton.doClick(0);
            model.setEnabled(isEnabled);
            success = true;
        }
        dragButton = null;
        dragSourceView = null;
        return success;
    }

    public void handleDragOver(WmiMathDocumentView docView) {
        this.selectPlaceHolder(docView);
    }

    private void selectPlaceHolder(WmiMathDocumentView docView) {
        block10: {
            WmiModel docModel = docView.getModel();
            boolean locked = false;
            try {
                try {
                    WmiModel placeholder;
                    if (!WmiModelLock.ownsWriteLock(docModel)) {
                        locked = WmiModelLock.readLock(docModel, true);
                    }
                    if ((placeholder = this.getPlaceholderModel(docView)) instanceof WmiTextModel) {
                        WmiSearchAndSelect.selectTextModel(docView, (WmiTextModel)placeholder);
                        break block10;
                    }
                    if (placeholder instanceof WmiCompositeModel) {
                        WmiSearchAndSelect.selectCompositeModel(docView, (WmiCompositeModel)placeholder);
                        break block10;
                    }
                    docView.setSelection(null);
                    docView.repaint();
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    if (locked) {
                        WmiModelLock.readUnlock(docModel);
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(docModel);
                }
            }
        }
    }

    private WmiModel getPlaceholderModel(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiPositionedView markerView = marker.getView();
        WmiModel markerModel = markerView.getModel();
        WmiModel placeholder = null;
        while (markerModel != null && markerModel != docView.getModel()) {
            WmiAttributeSet attribs = markerModel.getAttributes();
            if ("true".equals(attribs.getAttribute("placeholder"))) {
                placeholder = markerModel;
                break;
            }
            markerModel = markerModel.getParent();
        }
        return placeholder;
    }

    public static AbstractButton getDragButton() {
        return dragButton;
    }

    public static class PaletteButtonDragListener
    implements DragGestureListener,
    DragSourceListener {
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            Component c = dsde.getDragSourceContext().getComponent();
            if (c instanceof AbstractButton) {
                ButtonModel model = ((AbstractButton)c).getModel();
                boolean isEnabled = model.isEnabled();
                model.setEnabled(false);
                model.setSelected(false);
                model.setArmed(false);
                model.setPressed(false);
                model.setEnabled(isEnabled);
                model.setRollover(false);
                c.repaint();
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private static class PaletteButtonTransferable
    implements Transferable {
        private PaletteButtonTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return flavor == PALETTE_BUTTON_FLAVOR && dragButton != null ? "Palette Button" : null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PALETTE_BUTTON_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == PALETTE_BUTTON_FLAVOR;
        }
    }
}

