/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.view.palettes;

import com.maplesoft.mathdoc.components.dockingtools.WmiConfigurablePalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockableCardButtonPane;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class WmiPaletteManager {
    public static final String ERR_STRING_PROPERTY = "error.missingresource";
    public static final String MISSING_RESOURCE_TITLE_PROPERTY = "error.missingresource.title";
    public static final String FILE_NAME_PATTERN = "_RESOURCENAME_";
    public static final String KEY_NAME_PATTERN = "_RESOURCEKEY_";
    public static final String DOCK_MENU_NAME_PROPERTY = "menu.dock.name";
    public static final String PALETTE_POPUP_MENU_NAME_PROPERTY = "menu.popup.palette.name";
    public static final String PALETTE_COUNT_PROPERTY = "palette.count";
    public static final String PALETTE_PATH_PROPERTY = "palette.path";
    public static final String PALETTE_PREFIX = "palette";
    public static final String RESOURCE_SUFFIX = ".resource";
    public static final String PALETTE_MENU_NAME_PROPERTY = "palette.menuname";
    public static final String PALETTE_BUTTON_HIGHLIGHT_PROPERTY = "palette.selected.highlight";
    public static final String PALETTE_BUTTON_HIGHLIGHT_COLOR_PROPERTY = "palette.selected.color";
    public static final String PALETTE_BUTTON_UNHIGHLIGHT_COLOR_PROPERTY = "palette.deselected.color";
    public static final String DEFAULT_HIGHLIGHT_DISABLED = "false";
    public static final String DEFAULT_HIGHLIGHT_COLOR = "0 0 255";
    public static final String DEFAULT_UNHIGHLIGHT_COLOR = "0 0 0";
    public static final String[] DIRECTIONS_PROPERTY_NAMES = new String[]{"direction.name.north", "direction.name.south", "direction.name.east", "direction.name.west"};
    public static String DIRECTION_COMMAND_SEPARATOR = "-";
    public static String DIRECTION_COMMAND_SEPARATOR_PROPERTY = "direction.command.separator";
    public static final String[] INTERNAL_DIRECTIONS = new String[]{"North", "South", "East", "West"};
    public String[] DIRECTIONS = new String[DIRECTIONS_PROPERTY_NAMES.length];
    public HashMap directionToIndex = new HashMap();
    public WmiResourcePackage manifest;
    public int numPalettes = -1;
    public String palettePath;
    protected Vector paletteNameList = null;
    public WmiConfigurablePalette[] palettes = null;
    public HashMap paletteToViewCommands = new HashMap();
    public HashMap paletteToMainViewCommands = new HashMap();
    public HashMap paletteMapForHost = new HashMap();
    public HashMap paletteToName = new HashMap();
    public String dockMenuName = null;
    public String paletteMenuName = null;

    public WmiPaletteManager() {
        this("", "");
    }

    public WmiPaletteManager(String manifestPath, String errorMessagePath) {
        this.manifest = WmiResourcePackage.getResourcePackage(manifestPath);
        int i = 0;
        while (i < DIRECTIONS_PROPERTY_NAMES.length) {
            this.DIRECTIONS[i] = this.manifest.getStringForKey(DIRECTIONS_PROPERTY_NAMES[i]);
            this.directionToIndex.put(this.DIRECTIONS[i], new Integer(i));
            ++i;
        }
        DIRECTION_COMMAND_SEPARATOR = this.manifest.getStringForKey(DIRECTION_COMMAND_SEPARATOR_PROPERTY);
        this.configurePaletteHighlights();
    }

    public int getNumberOfPalettes() {
        if (this.numPalettes < 0) {
            try {
                this.numPalettes = Integer.parseInt(this.manifest.getStringForKey(PALETTE_COUNT_PROPERTY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.numPalettes;
    }

    public int getDirectionIndex(String direction) {
        int index = 0;
        if (this.directionToIndex.containsKey(direction)) {
            index = (Integer)this.directionToIndex.get(direction);
        }
        return index;
    }

    public void disposePalettes() {
        this.paletteToViewCommands = new HashMap();
        this.paletteToMainViewCommands = new HashMap();
        this.paletteMapForHost = new HashMap();
    }

    public String getDockMenuName() {
        if (this.dockMenuName == null) {
            this.dockMenuName = this.manifest.getStringForKey(DOCK_MENU_NAME_PROPERTY);
        }
        return this.dockMenuName;
    }

    public String getPaletteMenuName() {
        if (this.paletteMenuName == null) {
            this.paletteMenuName = this.manifest.getStringForKey(PALETTE_POPUP_MENU_NAME_PROPERTY);
        }
        return this.paletteMenuName;
    }

    public String getPalettePath() {
        this.palettePath = this.palettePath == null ? this.manifest.getStringForKey(PALETTE_PATH_PROPERTY) : this.palettePath;
        return this.palettePath;
    }

    public List getPaletteNames() {
        if (this.paletteNameList == null) {
            this.paletteNameList = new Vector();
            int num = this.getNumberOfPalettes();
            int i = 0;
            while (i < num) {
                String name = this.manifest.getStringForKey(PALETTE_PREFIX + i + RESOURCE_SUFFIX);
                this.paletteNameList.add(name);
                ++i;
            }
        }
        return this.paletteNameList;
    }

    public List getPaletteMenuDisplayNames() {
        int numberPalettes = this.getNumberOfPalettes();
        List snames = this.getPaletteNames();
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < numberPalettes) {
            WmiResourcePackage paletteBundle = WmiResourcePackage.getResourcePackage(String.valueOf(this.getPalettePath()) + snames.get(i));
            names.add(paletteBundle.getStringForKey(PALETTE_MENU_NAME_PROPERTY));
            ++i;
        }
        return names;
    }

    public Iterator getPalettesForHost(WmiDockingHost host) {
        Iterator<Object> paletteIt = null;
        HashMap nameToPalettes = (HashMap)this.paletteMapForHost.get(host);
        if (nameToPalettes == null) {
            List paletteResourceNames = this.getPaletteNames();
            Iterator iter = paletteResourceNames.iterator();
            while (iter.hasNext()) {
                this.createPalette(iter.next().toString(), host);
            }
            nameToPalettes = (HashMap)this.paletteMapForHost.get(host);
        }
        paletteIt = nameToPalettes != null ? nameToPalettes.values().iterator() : new ArrayList(0).iterator();
        return paletteIt;
    }

    public WmiConfigurablePalette createPalette(String paletteName, WmiDockingHost host) {
        String fullName = String.valueOf(this.getPalettePath()) + paletteName;
        WmiConfigurablePalette palette = null;
        HashMap nameToPalettes = null;
        if (this.paletteMapForHost.containsKey(host)) {
            nameToPalettes = (HashMap)this.paletteMapForHost.get(host);
        } else {
            nameToPalettes = new HashMap();
            this.paletteMapForHost.put(host, nameToPalettes);
        }
        if (nameToPalettes.containsKey(fullName)) {
            palette = (WmiConfigurablePalette)nameToPalettes.get(fullName);
        }
        return palette;
    }

    public void releasePaletteHost(WmiDockingHost host) {
        this.paletteMapForHost.remove(host);
    }

    public void configurePaletteHighlights() {
        String enabled = DEFAULT_HIGHLIGHT_DISABLED;
        String highlight = DEFAULT_HIGHLIGHT_COLOR;
        String unhighlight = DEFAULT_UNHIGHLIGHT_COLOR;
        try {
            enabled = this.manifest.getStringForKey(PALETTE_BUTTON_HIGHLIGHT_PROPERTY);
            highlight = this.manifest.getStringForKey(PALETTE_BUTTON_HIGHLIGHT_COLOR_PROPERTY);
            unhighlight = this.manifest.getStringForKey(PALETTE_BUTTON_UNHIGHLIGHT_COLOR_PROPERTY);
        }
        catch (Exception e1) {
            enabled = DEFAULT_HIGHLIGHT_DISABLED;
            highlight = DEFAULT_HIGHLIGHT_COLOR;
            unhighlight = DEFAULT_UNHIGHLIGHT_COLOR;
        }
        enabled = enabled == null ? DEFAULT_HIGHLIGHT_DISABLED : enabled;
        WmiDockableCardButtonPane.setButtonHighlightEnabled(!enabled.equals(DEFAULT_HIGHLIGHT_DISABLED));
        Color high = this.getColorFromString(highlight);
        high = high == null ? this.getColorFromString(DEFAULT_HIGHLIGHT_COLOR) : high;
        WmiDockableCardButtonPane.setButtonHighlightColor(high);
        Color unhigh = this.getColorFromString(unhighlight);
        unhigh = unhigh == null ? this.getColorFromString(DEFAULT_UNHIGHLIGHT_COLOR) : unhigh;
        WmiDockableCardButtonPane.setButtonUnHighlightColor(unhigh);
    }

    private Color getColorFromString(String color) {
        Color ccolor = null;
        try {
            StringTokenizer tok = new StringTokenizer(color);
            int r = Integer.parseInt(tok.nextToken());
            int g = Integer.parseInt(tok.nextToken());
            int b = Integer.parseInt(tok.nextToken());
            ccolor = new Color(r, g, b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ccolor;
    }
}

