/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.mathdoc.dialog.WmiDialogCheckBox;
import com.maplesoft.mathdoc.dialog.WmiDialogColorSelectButton;
import com.maplesoft.mathdoc.dialog.WmiDialogGroupPanel;
import com.maplesoft.mathdoc.dialog.WmiDialogLabel;
import com.maplesoft.mathdoc.dialog.WmiDialogLocalization;
import com.maplesoft.mathdoc.dialog.WmiDialogRadioButton;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.View;

public abstract class WmiDialog
extends JDialog {
    private static final String DEFAULT_RESOURCE_PATH = "com.maplesoft.mathdoc.dialog.resources.Dialog";
    protected static final String OK_KEY = "OK";
    protected static final String CANCEL_KEY = "Cancel";
    protected static final String CLOSE_KEY = "Close";
    private static WmiResourcePackage defaultResources = null;
    protected WmiDialogButton cancelButton = null;
    protected WmiDialogButton okButton = null;
    protected WmiResourcePackage dialogResources = null;

    public WmiDialog(Frame frame) {
        super(frame);
        this.initializeDialog();
    }

    public WmiDialog(JDialog dialog) {
        super(dialog);
        this.initializeDialog();
    }

    protected void initializeDialog() {
        this.getRootPane().setBorder(this.createDialogBorder());
    }

    private static String getStringForKey(WmiResourcePackage bundle, String key, Object arg) {
        String value = null;
        value = arg instanceof String ? bundle.getStringForKey(key, (String)arg) : (arg instanceof String[] ? bundle.getStringForKey(key, (String[])arg) : (arg != null ? bundle.getStringForKey(key, arg.toString()) : bundle.getStringForKey(key)));
        return value;
    }

    private static Border createMacDialogBorder(Color clr) {
        return BorderFactory.createMatteBorder(14, 12, 12, 12, clr);
    }

    private static Border createNonMacDialogBorder(Color clr) {
        return BorderFactory.createMatteBorder(8, 8, 4, 8, clr);
    }

    public static Border createDialogBorder(Color clr) {
        return RuntimePlatform.isMac() ? WmiDialog.createMacDialogBorder(clr) : WmiDialog.createNonMacDialogBorder(clr);
    }

    protected Border createDialogBorder() {
        return WmiDialog.createDialogBorder(this.getRootPane().getBackground());
    }

    public static String mapResource(WmiResourcePackage bundle, String key) {
        return WmiDialog.mapResource(bundle, key, null);
    }

    public static String mapResource(WmiResourcePackage bundle, String key, Object arg) {
        String value = null;
        if (bundle != null) {
            value = WmiDialog.getStringForKey(bundle, key, arg);
        }
        if (value == null) {
            if (defaultResources == null) {
                defaultResources = WmiResourcePackage.getResourcePackage(DEFAULT_RESOURCE_PATH);
            }
            value = WmiDialog.getStringForKey(defaultResources, key, arg);
        }
        if (value == null) {
            value = new String(key);
        }
        return value;
    }

    protected static void applyTextSizeConstraint(JLabel l, int minWidth, int maxWidth) {
        Dimension dim = l.getPreferredSize();
        if (dim.getWidth() > (double)maxWidth) {
            View view = (View)l.getClientProperty("html");
            if (view != null) {
                view.setSize(maxWidth, 100.0f);
                int h = (int)view.getPreferredSpan(1);
                l.setPreferredSize(new Dimension(maxWidth, h));
            } else {
                WmiFontMetrics fm = WmiFontResolver.getFontMetrics(l.getFont());
                int fontHeight = fm.getFontProperty(5) + fm.getFontProperty(0) * 2;
                int lines = Math.round((float)Math.ceil(dim.getWidth() / (double)maxWidth)) + 3;
                Dimension max = new Dimension(maxWidth, fontHeight * lines);
                if (dim.getHeight() < max.getHeight()) {
                    l.setPreferredSize(max);
                }
            }
        } else if (RuntimePlatform.isMac() && dim.width < minWidth) {
            dim.width = minWidth;
            l.setPreferredSize(dim);
        }
    }

    protected void cancelAction() {
        this.dispose();
    }

    protected JPanel createDefaultButtonsPanel() {
        return this.createDefaultButtonsPanel(null, null);
    }

    protected JPanel createDefaultButtonsPanel(String okButtonName, String cancelButtonName) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        if (this.okButton == null) {
            this.okButton = this.createOKButton();
        }
        if (okButtonName != null) {
            this.okButton.setText(okButtonName);
        }
        if (this.cancelButton == null) {
            this.cancelButton = this.createCancelButton();
        }
        if (cancelButtonName != null) {
            this.cancelButton.setText(cancelButtonName);
        }
        if (okButtonName == null && cancelButtonName == null) {
            Dimension dOk = this.okButton.getPreferredSize();
            Dimension dCancel = this.cancelButton.getPreferredSize();
            Dimension dBoth = dOk.width > dCancel.width ? dOk : dCancel;
            this.okButton.setSize(dBoth);
            this.okButton.setPreferredSize(dBoth);
            this.okButton.setMinimumSize(dBoth);
            this.okButton.setMaximumSize(dBoth);
            this.cancelButton.setSize(dBoth);
            this.cancelButton.setPreferredSize(dBoth);
            this.cancelButton.setMinimumSize(dBoth);
            this.cancelButton.setMaximumSize(dBoth);
        }
        if (RuntimePlatform.isMac()) {
            buttonPanel.add(this.cancelButton);
        } else {
            buttonPanel.add(this.okButton);
        }
        if (RuntimePlatform.isMac()) {
            buttonPanel.add(this.okButton);
        } else {
            buttonPanel.add(this.cancelButton);
        }
        return buttonPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutDialog() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setModal(this.makeModal());
            this.setResizable(this.makeResizable());
            this.addComponents();
            this.pack();
        }
    }

    protected void okAction() {
        this.dispose();
    }

    protected WmiDialogButton createButton(String key) {
        WmiDialogButton b = new WmiDialogButton(this.mapResourceKey(key));
        WmiDialogLocalization.installLocalization(b, this.dialogResources, key);
        return b;
    }

    protected WmiDialogButton createCancelButton() {
        return this.createCancelButton(CANCEL_KEY);
    }

    protected WmiDialogButton createCancelButton(String key) {
        this.cancelButton = this.createButton(key);
        this.cancelButton.activateHotKey("ESCAPE");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiDialog.this.cancelAction();
            }
        });
        return this.cancelButton;
    }

    protected WmiDialogColorSelectButton createColorButton(String key) {
        WmiDialogColorSelectButton csb = new WmiDialogColorSelectButton(this.mapResourceKey(key));
        WmiDialogLocalization.installLocalization(csb, this.dialogResources, key);
        return csb;
    }

    protected WmiDialogButton createOKButton() {
        return this.createOKButton(OK_KEY);
    }

    protected WmiDialogButton createOKButton(String key) {
        this.okButton = this.createButton(key);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiDialog.this.okAction();
            }
        });
        return this.okButton;
    }

    protected WmiDialogCheckBox createCheckbox(String key, boolean isChecked) {
        WmiDialogCheckBox cb = new WmiDialogCheckBox(this.mapResourceKey(key), isChecked);
        WmiDialogLocalization.installLocalization(cb, this.dialogResources, key);
        return cb;
    }

    protected JComboBox createComboBox(String[] items) {
        int i = 0;
        while (i < items.length) {
            items[i] = this.mapResourceKey(items[i]);
            ++i;
        }
        return new JComboBox<String>(items);
    }

    protected WmiDialogGroupPanel createGroupPanel(Component[] items, boolean horizontal, String titleKey) {
        WmiDialogGroupPanel panel = new WmiDialogGroupPanel(items, horizontal);
        if (titleKey != null) {
            panel.setBorder(this.createTitledBorder(titleKey));
        }
        WmiDialogLocalization.installLocalization(panel, this.dialogResources, titleKey);
        return panel;
    }

    protected WmiDialogLabel createLabel(String key) {
        WmiDialogLabel label = new WmiDialogLabel(this.mapResourceKey(key));
        WmiDialogLocalization.installLocalization(label, this.dialogResources, key);
        return label;
    }

    protected WmiDialogLabel createLabel(String key, String arg) {
        WmiDialogLabel label = new WmiDialogLabel(this.mapResourceKey(key), arg);
        WmiDialogLocalization.installLocalization(label, this.dialogResources, key);
        return label;
    }

    protected WmiDialogRadioButton createRadioButton(String key) {
        WmiDialogRadioButton b = new WmiDialogRadioButton(this.mapResourceKey(key));
        WmiDialogLocalization.installLocalization(b, this.dialogResources, key);
        return b;
    }

    protected Border createTitledBorder(String key) {
        String title = this.mapResourceKey(key);
        AbstractBorder border = null;
        if (RuntimePlatform.isMac()) {
            Border emptyBorder = BorderFactory.createEmptyBorder(0, 16, 4, 16);
            TitledBorder textBorder = BorderFactory.createTitledBorder(title);
            border = BorderFactory.createCompoundBorder(textBorder, emptyBorder);
        } else {
            border = BorderFactory.createTitledBorder(title);
        }
        return border;
    }

    protected String getResourcePath() {
        return DEFAULT_RESOURCE_PATH;
    }

    protected boolean makeModal() {
        return true;
    }

    protected boolean makeResizable() {
        return false;
    }

    protected String mapResourceKey(String key) {
        return this.mapResourceKey(key, null);
    }

    protected String mapResourceKey(String key, Object arg) {
        String file;
        if (this.dialogResources == null && (file = this.getResourcePath()) != null) {
            this.dialogResources = WmiResourcePackage.getResourcePackage(file);
        }
        return WmiDialog.mapResource(this.dialogResources, key, arg);
    }

    public void setTitle(String key, String arg) {
        String text = this.mapResourceKey(key);
        if (text.indexOf("%") != -1) {
            text = StringTools.replace(text, "%1", arg);
        }
        super.setTitle(text);
    }

    @Override
    public void setTitle(String key) {
        super.setTitle(this.mapResourceKey(key));
    }

    @Override
    public void pack() {
        super.pack();
        Dimension dlgSize = this.getSize();
        Container parent = this.getParent();
        if (parent != null && parent.isVisible()) {
            Point p = parent.getLocationOnScreen();
            Dimension d = parent.getSize();
            p.translate(d.width / 2, d.height / 2);
            this.setLocation(p.x - dlgSize.width / 2, p.y - dlgSize.height / 2);
        } else {
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gDevice = gEnv.getDefaultScreenDevice();
            GraphicsConfiguration gConfig = gDevice.getDefaultConfiguration();
            Rectangle bounds = gConfig.getBounds();
            this.setLocation((int)bounds.getCenterX() - dlgSize.width / 2, (int)bounds.getCenterY() - dlgSize.height / 2);
        }
    }

    protected abstract void addComponents();

    private class WmiFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private FocusTraversalPolicy policy = null;

        private WmiFocusTraversalPolicy(FocusTraversalPolicy policy) {
            this.policy = policy;
        }

        protected void selectComponent(Component c) {
            JTextField tmpC;
            if (c instanceof JTextField && (tmpC = (JTextField)c).isEditable() && tmpC.isEnabled()) {
                tmpC.selectAll();
            }
        }

        @Override
        public Component getComponentAfter(Container root, Component comp) {
            Component c = this.policy.getComponentAfter(root, comp);
            this.selectComponent(c);
            return c;
        }

        @Override
        public Component getComponentBefore(Container root, Component comp) {
            Component c = this.policy.getComponentBefore(root, comp);
            this.selectComponent(c);
            return c;
        }

        @Override
        public Component getDefaultComponent(Container root) {
            Component c = this.policy.getDefaultComponent(root);
            this.selectComponent(c);
            return c;
        }

        @Override
        public Component getFirstComponent(Container root) {
            Component c = this.policy.getFirstComponent(root);
            this.selectComponent(c);
            return c;
        }

        @Override
        public Component getInitialComponent(Window window) {
            Component c = this.policy.getInitialComponent(window);
            this.selectComponent(c);
            return c;
        }

        @Override
        public Component getLastComponent(Container root) {
            Component c = this.policy.getLastComponent(root);
            this.selectComponent(c);
            return c;
        }
    }
}

