/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class WmiDialogLocalization {
    private static final String PACKAGE_NAME = "__wmi_package_name";
    private static final String RESOURCE_KEY = "__wmi_res_key";
    private static final String ENGLISH_VALUE = "__wmi_en_value";
    private static final String LOCALIZED_VALUE = "__wmi_loc_value";

    public static void installLocalization(JComponent c, WmiResourcePackage pack, String key) {
        if (WmiResourcePackage.isDebugEnabled()) {
            c.putClientProperty(PACKAGE_NAME, pack.getPackageName());
            c.putClientProperty(RESOURCE_KEY, key);
            c.putClientProperty(ENGLISH_VALUE, pack.getEnglishLocalizedString(key));
            c.putClientProperty(LOCALIZED_VALUE, pack.getStringForKey(key));
            c.addMouseListener(new LocalizationUtilPopupListener());
        }
    }

    private static void showTranslationDialog(JComponent component, String packageName, String key, String english, String loc) {
        StringBuffer buffy = new StringBuffer();
        buffy.append("<html><table><tr><td align=right>Resource:</td><td align=left><b>");
        buffy.append(packageName);
        buffy.append("</b></td></tr><tr><td align=right>Key:</td><td align=left><b>");
        buffy.append(key);
        buffy.append("</b></td></tr><tr><td align=right>English:</td><td align=left><b>");
        buffy.append(english);
        buffy.append("</td></tr><tr><td align=right>Localized:</td><td align=left><b>");
        buffy.append(loc);
        buffy.append("</b></td></tr></table></html>");
        JOptionPane.showMessageDialog(component, buffy.toString());
    }

    private static class LocalizationUtilPopupListener
    extends MouseAdapter {
        private LocalizationUtilPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3 && e.getSource() instanceof JComponent) {
                final JComponent comp = (JComponent)e.getSource();
                final String name = (String)comp.getClientProperty(WmiDialogLocalization.PACKAGE_NAME);
                final String key = (String)comp.getClientProperty(WmiDialogLocalization.RESOURCE_KEY);
                final String english = (String)comp.getClientProperty(WmiDialogLocalization.ENGLISH_VALUE);
                final String loc = (String)comp.getClientProperty(WmiDialogLocalization.LOCALIZED_VALUE);
                JMenu popup = new JMenu();
                popup.add("Localization Properties").setEnabled(false);
                popup.addSeparator();
                if (name != null) {
                    popup.add("P: " + name).setEnabled(false);
                }
                if (key != null) {
                    popup.add("K: " + key).setEnabled(false);
                }
                if (english != null) {
                    popup.add("E: " + english).setEnabled(false);
                }
                if (loc != null) {
                    popup.add("L: " + loc).setEnabled(false);
                }
                popup.addSeparator();
                JMenuItem detailsItem = popup.add("Details...");
                detailsItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WmiDialogLocalization.showTranslationDialog(comp, name, key, english, loc);
                    }
                });
                popup.getPopupMenu().show(comp, e.getX(), e.getY());
            }
        }
    }
}

