/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiFileChooser;
import com.maplesoft.mathdoc.dialog.WmiMessageDialog;
import com.maplesoft.mathdoc.io.WmiFileFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class WmiFileWriteChooser
extends WmiFileChooser {
    protected static final String DIALOG_RESOURCES = "com.maplesoft.mathdoc.dialog.resources.Dialog";
    protected JFrame parentFrame = null;

    protected WmiFileWriteChooser(String title, JFrame parent) {
        super(title);
        this.parentFrame = parent;
    }

    protected WmiFileWriteChooser(String title) {
        this(title, (JFrame)null);
    }

    protected File appendExtension(File file, String extension) {
        String currentExt = WmiFileFilter.getFileExtension(file);
        if (currentExt == null || !currentExt.equals(extension)) {
            String filename = String.valueOf(file.getAbsolutePath()) + "." + extension;
            file = new File(filename);
            this.setSelectedFile(file);
        }
        return file;
    }

    protected boolean canWrite(File file, boolean warnWrite, boolean warnReplace) {
        File directory = file.getParentFile();
        if (directory != null) {
            while (!directory.exists() && directory.getParentFile() != null) {
                directory = directory.getParentFile();
            }
            if (!directory.exists()) {
                if (warnWrite) {
                    WmiMessageDialog dlg = new WmiMessageDialog(this.getResourcePath(), this.parentFrame);
                    dlg.setTitle("File_Write");
                    dlg.setMessage("No_Write_Permission");
                    dlg.setMessageType(102);
                    dlg.show();
                }
                return false;
            }
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                if (warnWrite) {
                    WmiMessageDialog dlg = new WmiMessageDialog(this.getResourcePath(), this.parentFrame);
                    dlg.setTitle("File_Write");
                    dlg.setMessage("Read_Only");
                    dlg.setMessageType(102);
                    dlg.show();
                }
                return false;
            }
            if (warnReplace) {
                WmiMessageDialog dlg = new WmiMessageDialog(this.getResourcePath(), this.parentFrame);
                dlg.setTitle("File_Save");
                dlg.setMessage("Overwrite", file.getName());
                dlg.setMessageType(105);
                dlg.setOptionType(1);
                if (dlg.showDialog() != 0) {
                    return false;
                }
            }
        }
        if ((directory = file.getParentFile()) != null && !directory.exists()) {
            try {
                directory.mkdirs();
            }
            catch (Exception dlg) {
                // empty catch block
            }
        }
        try {
            boolean clean = !file.exists();
            FileWriter testWriter = new FileWriter(file.getAbsolutePath(), file.exists());
            testWriter.flush();
            testWriter.close();
            if (clean) {
                file.delete();
            }
        }
        catch (IOException ioE) {
            if (warnWrite) {
                WmiMessageDialog dlg = new WmiMessageDialog(this.getResourcePath(), this.parentFrame);
                dlg.setTitle("File_Write");
                dlg.setMessage("Failed_Write", file.getName());
                dlg.setMessageType(102);
                dlg.show();
            }
            return false;
        }
        return true;
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName != null && propertyName.equals("SelectedFileChangedProperty") && newValue instanceof File && WmiFileWriteChooser.isWindowsShortcut((File)newValue)) {
            FileChooserUI uiObject = this.getUI();
            if (uiObject instanceof BasicFileChooserUI) {
                ((BasicFileChooserUI)uiObject).setFileName(null);
            }
            return;
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public String getResourcePath() {
        return DIALOG_RESOURCES;
    }
}

