/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiDialog;
import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WmiMessageDialog
extends WmiDialog {
    protected static final String DONT_SAVE = "DONT_SAVE";
    protected static final String DONT_SAVE_MAC_KEY = "DONT_SAVE.key.mac";
    protected static final String NO = "NO";
    protected static final String YES = "YES";
    protected static final String SAVE = "SAVE";
    protected static final String YES_ALL = "YES_TO_ALL";
    protected static final String HTML_PREFIX = "<html>";
    protected static final String HTML_SUFFIX = "</html>";
    protected static final int MAX_LABEL_WIDTH = 350;
    protected static final int MIN_LABEL_WIDTH = 300;
    public static final int MESSAGE_PLAIN = 101;
    public static final int MESSAGE_ERROR = 102;
    public static final int MESSAGE_INFORMATION = 103;
    public static final int MESSAGE_QUESTION = 104;
    public static final int MESSAGE_WARNING = 105;
    public static final int OPTION_OK = 0;
    public static final int OPTION_OK_CANCEL = 1;
    public static final int OPTION_YES_NO = 2;
    public static final int OPTION_YES_NO_CANCEL = 3;
    public static final int OPTION_YES_YESALL_NO_CANCEL = 4;
    public static final int OPTION_SAVE_DONTSAVE_CANCEL = 5;
    public static final int OPTION_SAVE_CANCEL = 6;
    public static final int RETURN_CLOSED = -1;
    public static final int RETURN_OK = 0;
    public static final int RETURN_CANCEL = 1;
    public static final int RETURN_YES = 2;
    public static final int RETURN_NO = 3;
    public static final int RETURN_YES_TO_ALL = 4;
    public static final int RETURN_OK_CHECKED = 5;
    public static final int RETURN_OK_UNCHECKED = 6;
    private WmiDialogButton noButton = null;
    private WmiDialogButton yesButton = null;
    private WmiDialogButton yesToAllButton = null;
    private JPanel supplimentalPanel = null;
    protected String message = "";
    protected int messageType = 101;
    protected int optionType = 0;
    protected String resourcePath = null;
    protected int returnValue = -1;
    private boolean layoutDone = false;
    protected boolean buttonHotKeys = true;

    public WmiMessageDialog(String resourceFile) {
        this(resourceFile, null);
    }

    public WmiMessageDialog(String resourceFile, JFrame frame) {
        super(frame);
        this.resourcePath = resourceFile;
    }

    public static void addHTMLMarkup(StringBuffer message) {
        int index = -1;
        int start = 0;
        while ((index = message.indexOf("\n", start)) != -1) {
            message.replace(index, index + 1, "<br>");
            start = index;
        }
        if (message.indexOf(HTML_PREFIX) == -1) {
            message.insert(0, HTML_PREFIX);
        }
        if (message.indexOf(HTML_SUFFIX) == -1) {
            message.append(HTML_SUFFIX);
        }
    }

    @Override
    protected void initializeDialog() {
        super.initializeDialog();
        if (!RuntimePlatform.isMac()) {
            this.getRootPane().setBorder(null);
        }
    }

    protected void addListeners() {
        if (this.yesToAllButton != null) {
            this.yesToAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WmiMessageDialog.this.returnValue = 4;
                    WmiMessageDialog.this.dispose();
                }
            });
        }
        if (this.yesButton != null) {
            this.yesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WmiMessageDialog.this.returnValue = 2;
                    WmiMessageDialog.this.dispose();
                }
            });
        }
        if (this.noButton != null) {
            this.noButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WmiMessageDialog.this.returnValue = 3;
                    WmiMessageDialog.this.dispose();
                }
            });
        }
    }

    protected JPanel createButtonPanel() {
        Component[] components = this.initializeButtons();
        JPanel b = new JPanel();
        int hspace = RuntimePlatform.isMac() ? 12 : 5;
        b.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.insets = new Insets(0, 0, 0, hspace);
        b.add(Box.createHorizontalGlue(), g);
        int i = 0;
        while (i < components.length - 1) {
            ++g.gridx;
            b.add(components[i], g);
            ++i;
        }
        ++g.gridx;
        g.insets = new Insets(0, 0, 0, 0);
        b.add(components[components.length - 1], g);
        if (RuntimePlatform.isMac()) {
            final Component focusButton = components[components.length - 1];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    focusButton.requestFocus();
                }
            });
        }
        return b;
    }

    protected Component[] initializeButtons() {
        Component[] components = null;
        if (RuntimePlatform.isMac()) {
            switch (this.optionType) {
                case 6: {
                    components = new Component[3];
                    this.yesButton = this.createButton(SAVE);
                    components[2] = this.yesButton;
                    components[1] = this.createCancelButton();
                    components[0] = Box.createHorizontalGlue();
                    break;
                }
                case 5: {
                    String noSaveKey;
                    components = new Component[5];
                    this.yesButton = this.createButton(SAVE);
                    components[4] = this.yesButton;
                    components[3] = this.createCancelButton();
                    components[2] = Box.createHorizontalStrut(12);
                    this.noButton = this.createButton(DONT_SAVE);
                    components[1] = this.noButton;
                    if (RuntimePlatform.isMac() && (noSaveKey = this.mapResourceKey(DONT_SAVE_MAC_KEY)) != null && this.buttonHotKeys) {
                        this.noButton.activateHotKey(noSaveKey);
                    }
                    components[0] = Box.createHorizontalStrut(54);
                    break;
                }
                case 2: {
                    components = new Component[3];
                    this.yesButton = this.createButton(YES);
                    components[2] = this.yesButton;
                    this.noButton = this.createButton(NO);
                    components[1] = this.noButton;
                    components[0] = Box.createHorizontalGlue();
                    break;
                }
                case 3: {
                    components = new Component[4];
                    this.yesButton = this.createButton(YES);
                    components[3] = this.yesButton;
                    this.noButton = this.createButton(NO);
                    components[2] = this.noButton;
                    this.cancelButton = this.createCancelButton();
                    components[1] = this.cancelButton;
                    components[0] = Box.createHorizontalGlue();
                    break;
                }
                case 4: {
                    components = new Component[5];
                    this.yesButton = this.createButton(YES);
                    components[4] = this.yesButton;
                    this.yesToAllButton = this.createButton(YES_ALL);
                    components[3] = this.yesToAllButton;
                    this.noButton = this.createButton(NO);
                    components[2] = this.noButton;
                    components[1] = this.createCancelButton();
                    components[0] = Box.createHorizontalGlue();
                    break;
                }
                case 1: {
                    components = new Component[3];
                    components[2] = this.createOKButton();
                    components[1] = this.createCancelButton();
                    components[0] = Box.createHorizontalGlue();
                    break;
                }
                case 0: {
                    components = new Component[]{this.createOKButton()};
                }
            }
        } else {
            switch (this.optionType) {
                case 6: {
                    components = new Component[2];
                    this.yesButton = this.createButton(SAVE);
                    components[0] = this.yesButton;
                    this.cancelButton = this.createCancelButton();
                    components[1] = this.cancelButton;
                    if (!this.buttonHotKeys) break;
                    this.yesButton.activateHotKey("S");
                    this.cancelButton.activateHotKey("C");
                    break;
                }
                case 2: {
                    components = new Component[2];
                    this.yesButton = this.createButton(YES);
                    components[0] = this.yesButton;
                    this.noButton = this.createButton(NO);
                    components[1] = this.noButton;
                    if (!this.buttonHotKeys) break;
                    this.yesButton.activateHotKey("Y");
                    this.noButton.activateHotKey("N");
                    break;
                }
                case 3: 
                case 5: {
                    components = new Component[3];
                    this.yesButton = this.createButton(YES);
                    components[0] = this.yesButton;
                    this.noButton = this.createButton(NO);
                    components[1] = this.noButton;
                    this.cancelButton = this.createCancelButton();
                    components[2] = this.cancelButton;
                    if (!this.buttonHotKeys) break;
                    this.yesButton.activateHotKey("Y");
                    this.noButton.activateHotKey("N");
                    this.cancelButton.activateHotKey("C");
                    break;
                }
                case 4: {
                    components = new Component[4];
                    this.yesButton = this.createButton(YES);
                    components[0] = this.yesButton;
                    this.yesToAllButton = this.createButton(YES_ALL);
                    components[1] = this.yesToAllButton;
                    this.noButton = this.createButton(NO);
                    components[2] = this.noButton;
                    this.cancelButton = this.createCancelButton();
                    components[3] = this.cancelButton;
                    if (!this.buttonHotKeys) break;
                    this.yesButton.activateHotKey("Y");
                    this.yesToAllButton.activateHotKey("A");
                    this.noButton.activateHotKey("N");
                    this.cancelButton.activateHotKey("C");
                    break;
                }
                case 1: {
                    components = new Component[2];
                    this.yesButton = this.createOKButton();
                    components[0] = this.yesButton;
                    this.cancelButton = this.createCancelButton();
                    components[1] = this.cancelButton;
                    if (!this.buttonHotKeys) break;
                    this.yesButton.activateHotKey("O");
                    this.cancelButton.activateHotKey("C");
                    break;
                }
                case 0: {
                    components = new Component[1];
                    this.yesButton = this.createOKButton();
                    components[0] = this.yesButton;
                    if (!this.buttonHotKeys) break;
                    this.yesButton.activateHotKey("O");
                }
            }
        }
        return components;
    }

    public void setMessage(String messageKey) {
        this.setMessage(messageKey, null);
    }

    public void setMessage(String messageKey, Object arg) {
        this.message = this.mapResourceKey(messageKey, arg);
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public void setOptionType(int optionType) {
        this.optionType = optionType;
    }

    public int showDialog() {
        this.show();
        return this.returnValue;
    }

    protected JComponent createMessage() {
        StringBuffer sb = new StringBuffer(this.message);
        WmiMessageDialog.addHTMLMarkup(sb);
        JLabel messageLabel = new JLabel(sb.toString());
        if (this.optionType == 5 && RuntimePlatform.isMac()) {
            Font f = messageLabel.getFont();
            Font bold = f.deriveFont(1, 13.0f);
            messageLabel.setFont(bold);
        }
        WmiMessageDialog.applyTextSizeConstraint(messageLabel, 300, 350);
        messageLabel.setVerticalAlignment(1);
        return messageLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addComponents() {
        JPanel components = this.createButtonPanel();
        JComponent messageLabel = this.createMessage();
        String iconIdentifier = "OptionPane.plainIcon";
        switch (this.messageType) {
            case 102: {
                iconIdentifier = "OptionPane.errorIcon";
                break;
            }
            case 103: {
                iconIdentifier = "OptionPane.informationIcon";
                break;
            }
            case 104: {
                iconIdentifier = "OptionPane.questionIcon";
                break;
            }
            case 105: {
                iconIdentifier = "OptionPane.warningIcon";
            }
        }
        JLabel icon = new JLabel(UIManager.getIcon(iconIdentifier));
        this.addListeners();
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        int y = 0;
        Object object = this.getTreeLock();
        synchronized (object) {
            c.anchor = 18;
            c.gridheight = -1;
            gridbag.setConstraints(icon, c);
            panel.add(icon);
            c.gridheight = 1;
            c.gridx = 1;
            c.anchor = RuntimePlatform.isMac() ? 18 : 17;
            c.insets = new Insets(0, 10, 0, 0);
            gridbag.setConstraints(messageLabel, c);
            panel.add(messageLabel);
            ++y;
            if (this.supplimentalPanel != null) {
                c.gridx = 1;
                c.gridy = y++;
                c.insets = new Insets(15, 10, 0, 0);
                c.anchor = 17;
                panel.add((Component)this.supplimentalPanel, c);
            }
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = y;
            c.insets = new Insets(15, 0, 0, 0);
            c.anchor = RuntimePlatform.isMac() ? 13 : 10;
            gridbag.setConstraints(components, c);
            panel.add(components);
            ++y;
            Container pane = this.getContentPane();
            gridbag = new GridBagLayout();
            c = new GridBagConstraints();
            pane.setLayout(gridbag);
            if (!RuntimePlatform.isMac()) {
                c.insets = new Insets(10, 15, 10, 15);
            }
            gridbag.setConstraints(panel, c);
            pane.add(panel);
        }
        switch (this.optionType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.getRootPane().setDefaultButton(this.yesButton);
                break;
            }
            case 0: 
            case 1: {
                this.getRootPane().setDefaultButton(this.okButton);
            }
        }
    }

    @Override
    protected void cancelAction() {
        this.returnValue = 1;
        super.cancelAction();
    }

    @Override
    protected String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    protected void okAction() {
        this.returnValue = 0;
        super.okAction();
    }

    protected void setSupplimentaryPanel(JPanel p) {
        this.supplimentalPanel = p;
    }

    @Override
    public void show() {
        if (!this.layoutDone) {
            this.layoutDialog();
            this.layoutDone = true;
        }
        super.show();
    }
}

