/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.util.ResourceLoader;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;

public class FontIndexer {
    private static final int TABLE_SIZE = 256;
    private String fontName;
    private String fontPath;
    private Font referenceFont;
    private static FontIndexer overrideIndexer = new FontIndexer(null, null);
    private char[][] data = new char[256][];

    protected FontIndexer(String name, String path) {
        this.fontName = name;
        this.fontPath = path;
        this.initialize();
    }

    protected void initialize() {
        char[] data = this.getInitializerTable();
        if (data != null) {
            int size = data.length;
            int i = 0;
            while (i < size) {
                this.put(data[i], data[i + 1]);
                i += 2;
            }
        }
        if (this.fontPath != null) {
            try {
                this.referenceFont = ResourceLoader.getResourceAsFont(this.fontPath);
            }
            catch (FontFormatException ffe) {
                WmiErrorLog.log(ffe);
            }
            catch (IOException ie) {
                WmiErrorLog.log(ie);
            }
        }
    }

    protected char[] getInitializerTable() {
        return null;
    }

    public void put(char ch, char value) {
        int index1 = ch >> 8;
        int index2 = ch & 0xFF;
        char[] subset = this.data[index1];
        if (subset == null) {
            this.data[index1] = new char[256];
            subset = this.data[index1];
        }
        subset[index2] = value;
        if (this.forceMapping() && overrideIndexer != null && overrideIndexer != this) {
            overrideIndexer.put(ch, value);
        }
    }

    public char get(char ch) {
        char value = '\u0000';
        int index1 = ch >> 8;
        int index2 = ch & 0xFF;
        char[] subset = this.data[index1];
        if (subset != null) {
            value = subset[index2];
        }
        return value;
    }

    public char get(char ch, int style) {
        return this.get(ch);
    }

    public String getName() {
        return this.fontName;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public Font getFont(int style, int size) {
        return this.referenceFont != null ? this.referenceFont.deriveFont(style, size) : null;
    }

    protected boolean forceMapping() {
        return false;
    }

    public static int getForceMappingIndex(String str) {
        int pos = -1;
        if (overrideIndexer != null) {
            int length = str.length();
            int i = 0;
            while (i < length) {
                char ch = str.charAt(i);
                if (overrideIndexer.get(ch) != '\u0000') {
                    pos = i;
                    break;
                }
                ++i;
            }
        }
        return pos;
    }
}

