/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WmiSharedGlyphVector
extends GlyphVector {
    private Font font;
    private FontRenderContext frc;
    private int[] glyphs;
    private float[] horizontalOffset;
    private int base;
    private int length;

    public WmiSharedGlyphVector(Font font, String contents, FontRenderContext frc) {
        this.font = font;
        this.frc = frc;
        WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
        this.length = contents.length();
        this.base = 0;
        this.glyphs = new int[this.length];
        this.horizontalOffset = new float[this.length + 1];
        int i = 0;
        while (i < this.length) {
            char ch = contents.charAt(i);
            this.glyphs[i] = metrics.getCharacterProperty(6, ch, frc);
            this.horizontalOffset[i + 1] = this.horizontalOffset[i] + metrics.getPreciseCharacterProperty(2, ch, frc);
            ++i;
        }
    }

    public WmiSharedGlyphVector(WmiSharedGlyphVector source, int offset) {
        this.font = source.font;
        this.frc = source.frc;
        this.glyphs = source.glyphs;
        this.horizontalOffset = source.horizontalOffset;
        this.base = source.base + offset;
        this.length = source.length - offset;
    }

    public WmiSharedGlyphVector splitVector(int offset, int consume) {
        WmiSharedGlyphVector fragment = new WmiSharedGlyphVector(this, offset + consume);
        this.length = offset;
        return fragment;
    }

    public WmiSharedGlyphVector(WmiSharedGlyphVector v, int start, int length) {
        this.font = v.getFont();
        this.frc = v.getFontRenderContext();
        this.glyphs = v.glyphs;
        this.horizontalOffset = v.horizontalOffset;
        this.base = v.base + start;
        this.length = length;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    @Override
    public void performDefaultLayout() {
    }

    @Override
    public int getNumGlyphs() {
        return this.length;
    }

    @Override
    public int getGlyphCode(int index) {
        return this.glyphs[this.base + index];
    }

    @Override
    public int[] getGlyphCodes(int start, int length, int[] store) {
        if (store == null) {
            store = new int[length];
        }
        int i = 0;
        while (i < length) {
            store[i] = this.glyphs[this.base + start + i];
            ++i;
        }
        return store;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public Rectangle2D getVisualBounds() {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public Shape getOutline() {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public Shape getOutline(float arg0, float arg1) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public Shape getGlyphOutline(int arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public Point2D getGlyphPosition(int index) {
        return new Point2D.Float(this.horizontalOffset[this.base + index] - this.horizontalOffset[this.base], 0.0f);
    }

    @Override
    public void setGlyphPosition(int index, Point2D pt) {
        WmiErrorLog.log(new Exception("Not implemented"));
    }

    @Override
    public AffineTransform getGlyphTransform(int arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public void setGlyphTransform(int arg0, AffineTransform arg1) {
        WmiErrorLog.log(new Exception("Not implemented"));
    }

    @Override
    public float[] getGlyphPositions(int start, int length, float[] store) {
        if (store == null) {
            store = new float[2 * length];
        }
        int i = 0;
        while (i < length) {
            store[2 * i] = this.horizontalOffset[this.base + start + i] - this.horizontalOffset[this.base];
            store[2 * i + 1] = 0.0f;
            ++i;
        }
        return store;
    }

    @Override
    public Shape getGlyphLogicalBounds(int arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public Shape getGlyphVisualBounds(int arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public GlyphMetrics getGlyphMetrics(int arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return null;
    }

    @Override
    public boolean equals(GlyphVector arg0) {
        WmiErrorLog.log(new Exception("Not implemented"));
        return false;
    }

    public float getHorizontalOffset(int index) {
        return this.base != 0 ? this.horizontalOffset[this.base + index] - this.horizontalOffset[this.base] : this.horizontalOffset[index];
    }
}

