/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.FontIndexer;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiLocalizedFontResolver;
import com.maplesoft.mathdoc.font.WmiSharedGlyphVector;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.math.WmiMathGlyphView;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringTools;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import java.util.LinkedList;

public class WmiTextLayout {
    private Font font;
    private GlyphVector glyphs;
    private WmiTextLayout next = null;
    private String contents;
    private FontRenderContext frc = null;
    private int contentsLengthFromThisToEnd;
    private int widthFromThisToEnd;
    private short baseline;
    private short height;
    private short preKernAdjust;
    private short postKernAdjust;
    private boolean layoutChainContainsTabs = false;
    private int horizontalOffset = -1;
    private int mglyphColor = 0;
    private static final float ANTIALIAS_THRESHOLD = 16.0f;

    private WmiTextLayout() {
    }

    public static WmiTextLayout createTextLayout(char character, Font font, WmiMathDocumentView document) {
        return WmiTextLayout.createTextLayout(Character.toString(character), font, document, true, 0);
    }

    public static WmiTextLayout createTextLayout(char character, Font font, WmiMathDocumentView document, boolean isMath) {
        return WmiTextLayout.createTextLayout(Character.toString(character), font, document, isMath, 0);
    }

    public static WmiTextLayout createTextLayout(String contents, Font font, WmiMathDocumentView document) {
        return WmiTextLayout.createTextLayout(contents, font, document, true, 0);
    }

    public static WmiTextLayout createTextLayout(String contents, Font font, WmiMathDocumentView document, boolean isMath) {
        return WmiTextLayout.createTextLayout(contents, font, document, isMath, 0);
    }

    public static WmiTextLayout createTextLayout(String contents, Font font, WmiMathDocumentView document, boolean isMathLayout, int width) {
        WmiTextLayout first;
        WmiTextLayout curLayout2 = first = new WmiTextLayout();
        int renderLimit = WmiTextLayout.updateNewLayout(curLayout2, contents, font, document, isMathLayout, width);
        boolean isMathChar = contents != null && contents.length() > 0 && WmiMathEntityNameMapper.isMathEntity(contents.charAt(0));
        LinkedList<WmiTextLayout> layoutStack = null;
        while (contents.length() > 0) {
            if ((renderLimit = curLayout2.checkForTabs(curLayout2.contents, renderLimit)) == 0 || isMathChar) {
                WmiTextLayout.resolveFontAtFirstChar(curLayout2, isMathChar);
                if (contents.length() == 1) break;
                contents = contents.substring(1);
            } else {
                if (renderLimit < 0) {
                    if (!WmiTextLayout.startsWithTab(contents)) {
                        curLayout2.glyphs = new WmiSharedGlyphVector(curLayout2.font, contents, curLayout2.frc);
                        break;
                    }
                    curLayout2.contents = contents;
                    break;
                }
                curLayout2.glyphs = new WmiSharedGlyphVector(curLayout2.font, contents.substring(0, renderLimit), curLayout2.frc);
                curLayout2.contents = contents.substring(0, renderLimit);
                contents = contents.substring(renderLimit);
            }
            if (layoutStack == null) {
                layoutStack = new LinkedList<WmiTextLayout>();
                layoutStack.addFirst(curLayout2);
            }
            curLayout2 = curLayout2.next = new WmiTextLayout();
            layoutStack.addFirst(curLayout2);
            renderLimit = WmiTextLayout.updateNewLayout(curLayout2, contents, font, document, isMathLayout, 0);
            boolean bl = isMathChar = contents != null && contents.length() > 0 && WmiMathEntityNameMapper.isMathEntity(contents.charAt(0));
        }
        if (curLayout2.glyphs == null) {
            curLayout2.glyphs = new WmiSharedGlyphVector(font, contents, first.frc);
        }
        if (layoutStack == null) {
            WmiTextLayout.calculateMetrics(first);
        } else {
            for (WmiTextLayout curLayout2 : layoutStack) {
                WmiTextLayout.calculateMetrics(curLayout2);
            }
        }
        return first;
    }

    public static WmiTextLayout createTextLayout(WmiAbstractMathTokenModel token, Font font, WmiMathDocumentView document, boolean isMathLayout) throws WmiNoReadAccessException {
        WmiTextLayout first;
        WmiTextLayout curLayout2 = first = new WmiTextLayout();
        ArrayList glyphIndices = token.getGlyphIndices();
        String text = token.getText();
        int previousIndex = 0;
        LinkedList<WmiTextLayout> layoutStack = null;
        int i = 0;
        while (i < glyphIndices.size() + 1) {
            int glyphIndex = text.length();
            if (i < glyphIndices.size()) {
                glyphIndex = (Integer)glyphIndices.get(i);
            }
            String contents = text.substring(previousIndex, glyphIndex);
            int renderLimit = WmiTextLayout.updateNewLayout(curLayout2, contents, font, document, isMathLayout, 0);
            if (layoutStack == null) {
                layoutStack = new LinkedList<WmiTextLayout>();
            }
            layoutStack.addFirst(curLayout2);
            boolean isMathChar = contents != null && contents.length() > 0 && WmiMathEntityNameMapper.isMathEntity(contents.charAt(0));
            while (contents.length() > 0) {
                if ((renderLimit = curLayout2.checkForTabs(curLayout2.contents, renderLimit)) == 0 || isMathChar) {
                    WmiTextLayout.resolveFontAtFirstChar(curLayout2, isMathChar);
                    if (contents.length() == 1) break;
                    contents = contents.substring(1);
                    continue;
                }
                if (renderLimit < 0) {
                    if (!WmiTextLayout.startsWithTab(contents)) {
                        curLayout2.glyphs = new WmiSharedGlyphVector(curLayout2.font, contents, curLayout2.frc);
                        break;
                    }
                    curLayout2.contents = contents;
                    break;
                }
                curLayout2.glyphs = new WmiSharedGlyphVector(curLayout2.font, contents.substring(0, renderLimit), curLayout2.frc);
                curLayout2.contents = contents.substring(0, renderLimit);
                contents = contents.substring(renderLimit);
            }
            if (curLayout2.glyphs == null) {
                curLayout2.glyphs = new WmiSharedGlyphVector(font, contents, first.frc);
            }
            if (i < glyphIndices.size()) {
                curLayout2 = curLayout2.next = new WmiTextLayout();
                WmiMathGlyphModel glyph = token.getGlyph(i);
                WmiMathGlyphModel.WmiMathGlyphAttributeSet attrs = (WmiMathGlyphModel.WmiMathGlyphAttributeSet)glyph.getAttributesForRead();
                String fontName = attrs.getFontFamily();
                Font f = new Font(fontName, 0, document.getZoomFactor() * WmiMathGlyphView.DEFAULT_FONT_SIZE / 100);
                WmiTextLayout.updateNewLayout(curLayout2, " ", f, document, isMathLayout, 0);
                int[] indexList = new int[]{attrs.getIndex()};
                curLayout2.glyphs = f.createGlyphVector(curLayout2.frc, indexList);
                GlyphMetrics metrics = curLayout2.glyphs.getGlyphMetrics(0);
                if (f.getName().equals("") || metrics.getBounds2D().getWidth() <= 0.0) {
                    WmiTextLayout.updateNewLayout(curLayout2, attrs.getAlt(), f, document, isMathLayout, 0);
                    curLayout2.glyphs = new WmiSharedGlyphVector(font, attrs.getAlt(), first.frc);
                }
                curLayout2.mglyphColor = attrs.getForeground();
                curLayout2 = curLayout2.next = new WmiTextLayout();
            }
            previousIndex = glyphIndex;
            ++i;
        }
        if (layoutStack == null) {
            WmiTextLayout.calculateMetrics(first);
        } else {
            for (WmiTextLayout curLayout2 : layoutStack) {
                WmiTextLayout.calculateMetrics(curLayout2);
            }
        }
        return first;
    }

    public WmiTextLayout splitLayout(int index, int consume) {
        WmiTextLayout fragment = null;
        int limit = this.contents.length();
        WmiTextLayout segment = this;
        while (segment != null && index >= limit) {
            if ((segment = segment.getNext()) == null) continue;
            index -= limit;
            if (segment.contents == null) continue;
            limit = segment.contents.length();
        }
        if (segment != null) {
            fragment = new WmiTextLayout();
            if (index + consume > limit) {
                consume = limit - index;
            }
            fragment.contents = segment.contents.substring(index + consume);
            segment.contents = segment.contents.substring(0, index);
            fragment.font = segment.font;
            fragment.frc = segment.frc;
            GlyphVector glyphs = segment.getGlyphs();
            fragment.glyphs = glyphs instanceof WmiSharedGlyphVector ? ((WmiSharedGlyphVector)glyphs).splitVector(index, consume) : new WmiSharedGlyphVector(fragment.font, fragment.contents, fragment.frc);
            fragment.next = segment.next;
            segment.next = null;
            WmiTextLayout tabby = fragment;
            int tabOffset = 0;
            while (tabby != null) {
                if (tabby.containsTabs()) {
                    tabby.setHorizontalOffset(tabOffset);
                }
                tabOffset += tabby.getSegmentWidth();
                tabby = tabby.getNext();
            }
            WmiTextLayout.calculateMetrics(fragment);
            WmiTextLayout.calculateMetrics(this);
            WmiTextLayout.updateContentLength(segment);
            WmiTextLayout.updateContentLength(fragment);
            WmiTextLayout.updateContentLength(this);
        }
        return fragment;
    }

    private static void updateContentLength(WmiTextLayout layout) {
        WmiTextLayout fragment = layout;
        int length = 0;
        while (fragment != null) {
            length += fragment.contents.length();
            fragment = fragment.getNext();
        }
        fragment = layout;
        while (fragment != null) {
            fragment.contentsLengthFromThisToEnd = length;
            length -= fragment.contents.length();
            fragment = fragment.getNext();
        }
    }

    private static int updateNewLayout(WmiTextLayout layout, String contents, Font font, WmiMathDocumentView document, boolean isMathLayout, int width) {
        WmiLocalizedFontResolver lfr;
        layout.contentsLengthFromThisToEnd = contents.length();
        layout.font = font;
        layout.widthFromThisToEnd = width;
        int mapLimit = isMathLayout ? FontIndexer.getForceMappingIndex(contents) : -1;
        int renderLimit = mapLimit == -1 ? WmiFontResolver.canDisplayUpTo(font, contents) : WmiFontResolver.canDisplayUpTo(font, contents.substring(0, mapLimit));
        if (mapLimit >= 0 && (mapLimit < renderLimit || renderLimit < 0)) {
            renderLimit = mapLimit;
        }
        if ((lfr = WmiLocalizedFontResolver.getInstance()) != null) {
            int continuousMapUntil = lfr.getContinuousRunIndex(contents);
            layout.font = lfr.mapFont(layout.font, contents);
            if (continuousMapUntil != -1 && (renderLimit == -1 || continuousMapUntil < renderLimit)) {
                renderLimit = continuousMapUntil;
            }
        }
        if (document != null && document.isPrintView()) {
            layout.frc = WmiFontMetrics.getPrintContext();
        } else {
            layout.frc = WmiFontMetrics.getScreenContext();
            if (!RuntimePlatform.isMac() && contents != null && layout.frc.isAntiAliased() && layout.getFont().getSize2D() <= 16.0f && contents.indexOf(8722) >= 0) {
                layout.frc = new FontRenderContext(layout.frc.getTransform(), false, true);
            }
        }
        layout.contents = contents;
        return renderLimit;
    }

    private static void calculateMetrics(WmiTextLayout curLayout) {
        curLayout.widthFromThisToEnd = curLayout.getSegmentWidth();
        WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(curLayout.getMappedFont(0));
        curLayout.baseline = (short)(metrics.getFontProperty(3, curLayout.frc) + metrics.getFontProperty(0, curLayout.frc));
        curLayout.height = (short)(curLayout.baseline + metrics.getFontProperty(4, curLayout.frc));
        if (curLayout.next != null) {
            WmiTextLayout.calculateMetrics(curLayout.next);
            curLayout.widthFromThisToEnd += curLayout.next.getWidth();
        }
    }

    private static void resolveFontAtFirstChar(WmiTextLayout layout, boolean isMathChar) {
        Font sfont = layout.font;
        String mappedLocalizedFont = null;
        char c = layout.contents.charAt(0);
        if (!isMathChar && StringTools.isCJKCharacter(c)) {
            mappedLocalizedFont = RuntimePlatform.isMac() && layout.font.getFamily().equals("Hiragino Mincho Pro") ? "Hiragino Mincho Pro" : WmiFontResolver.getCJKFontForText(layout.contents);
        }
        sfont = mappedLocalizedFont != null ? new Font(mappedLocalizedFont, layout.font.getStyle(), layout.font.getSize()) : WmiFontResolver.getFontForCharacter(layout.contents, layout.font);
        c = WmiFontResolver.mapCharacterForFont(c, sfont);
        String tempContents = Character.toString(c);
        layout.glyphs = new WmiSharedGlyphVector(sfont, tempContents, layout.frc);
        layout.contents = tempContents;
        layout.font = sfont;
    }

    private static boolean startsWithTab(String s) {
        return s != null && s.length() > 0 && s.charAt(0) == '\t';
    }

    private int checkForTabs(String contents, int renderLimit) {
        if (WmiTextLayout.startsWithTab(contents)) {
            renderLimit = -1;
            int i = 1;
            while (i < contents.length()) {
                if (contents.charAt(i) != '\t') {
                    renderLimit = i;
                    break;
                }
                ++i;
            }
            this.layoutChainContainsTabs = true;
        } else {
            int tabIndex = contents.indexOf(9);
            if (tabIndex >= 0) {
                renderLimit = tabIndex;
                this.layoutChainContainsTabs = true;
            }
        }
        return renderLimit;
    }

    private boolean isTabLayout() {
        return WmiTextLayout.startsWithTab(this.contents);
    }

    public boolean containsTabs() {
        return this.layoutChainContainsTabs;
    }

    public void setHorizontalOffset(int x) {
        this.horizontalOffset = x;
        if (this.next != null) {
            this.next.setHorizontalOffset(x + this.getSegmentWidth());
        }
    }

    public int getTabWidth() {
        return 72;
    }

    private int getWidthOfTabCount(int c) {
        if (c == 0) {
            return 0;
        }
        int tabWidth = this.getTabWidth();
        int tabRemainder = tabWidth - this.horizontalOffset % tabWidth;
        return (c - 1) * tabWidth + tabRemainder;
    }

    public void applyKerningAdjustment(boolean pre, boolean post) {
        if (this.contents.length() > 0) {
            this.preKernAdjust = pre ? this.computePreKernAdjustment() : (short)0;
            this.postKernAdjust = post ? this.computePostKernAdjustment() : (short)0;
        }
    }

    public short computePreKernAdjustment() {
        short adjustment = 0;
        if (this.contents.length() > 0) {
            Font adjustedFont = this.getMappedFont(0);
            char ch = this.getMappedCharacter(0);
            WmiFontMetrics adjustedMetrics = WmiFontResolver.getFontMetrics(adjustedFont);
            adjustment = (short)Math.round(adjustedMetrics.getCharacterProperty(1, ch, this.frc));
        }
        return adjustment;
    }

    public short computePostKernAdjustment() {
        short adjustment = 0;
        if (this.contents.length() > 0) {
            int pos = this.contents.length() - 1;
            Font adjustedFont = this.getMappedFont(pos);
            char ch = this.getMappedCharacter(pos);
            WmiFontMetrics adjustedMetrics = WmiFontResolver.getFontMetrics(adjustedFont);
            adjustment = (short)Math.round(adjustedMetrics.getCharacterProperty(3, ch, this.frc));
        }
        return adjustment;
    }

    public int computeSpaceAbove() {
        int maxCharAscent = 0;
        int maxFontAscent = 0;
        WmiTextLayout segment = this;
        Font f = null;
        WmiFontMetrics m = null;
        while (segment != null) {
            int size;
            String str = segment.contents;
            int n = size = str != null ? str.length() : 0;
            if (size > 0) {
                f = segment.getMappedFont(0);
                m = WmiFontResolver.getFontMetrics(f);
            }
            int i = 0;
            while (i < size) {
                int charAscent = Math.round(m.getCharacterProperty(4, str.charAt(i), this.frc));
                if (charAscent > maxCharAscent) {
                    maxCharAscent = charAscent;
                }
                ++i;
            }
            int fontAscent = m.getFontProperty(3, this.frc);
            if (fontAscent > maxFontAscent) {
                maxFontAscent = fontAscent;
            }
            segment = segment.getNext();
        }
        return maxFontAscent - maxCharAscent;
    }

    public int computeSpaceBelow() {
        int maxCharDescent = 0;
        int maxFontDescent = 0;
        WmiTextLayout segment = this;
        Font f = null;
        WmiFontMetrics m = null;
        while (segment != null) {
            int size;
            String str = segment.contents;
            int n = size = str != null ? str.length() : 0;
            if (size > 0) {
                f = segment.getMappedFont(0);
                m = WmiFontResolver.getFontMetrics(f);
            }
            int i = 0;
            while (i < size) {
                int charDescent = m.getCharacterProperty(5, str.charAt(i), this.frc);
                if (charDescent > maxCharDescent) {
                    maxCharDescent = charDescent;
                }
                ++i;
            }
            int fontDescent = m.getFontProperty(4);
            if (fontDescent > maxFontDescent) {
                maxFontDescent = fontDescent;
            }
            segment = segment.getNext();
        }
        return maxFontDescent - maxCharDescent;
    }

    public void draw(Graphics g, int x, int y) {
        this.draw(g, x, y, this.preKernAdjust);
    }

    public void draw(Graphics g, int x, int y, int adjust) {
        WmiTextLayout layout = this.next;
        this.drawThis(g, x, y, adjust);
        x = x + adjust + this.getSegmentWidth();
        while (layout != null) {
            layout.drawThis(g, x, y, 0);
            x += layout.getSegmentWidth();
            layout = layout.getNext();
        }
    }

    private void drawThis(Graphics g, int x, int y, int adjust) {
        if (this.glyphs instanceof WmiSharedGlyphVector) {
            this.glyphs = this.font.createGlyphVector(this.frc, this.contents);
        }
        Color originalColor = g.getColor();
        if (this.mglyphColor != 0) {
            g.setColor(new Color(this.mglyphColor));
        }
        ((Graphics2D)g).drawGlyphVector(this.glyphs, x + adjust, y);
        if (this.mglyphColor != 0) {
            g.setColor(originalColor);
        }
    }

    public Font getMappedFont(int index) {
        Font f = null;
        int limit = this.contents.length();
        WmiTextLayout layout = this;
        while (layout != null && index > limit) {
            layout = layout.getNext();
            index -= limit;
            limit = this.contents.length();
        }
        if (layout != null) {
            f = layout.getGlyphs().getFont();
        }
        return f;
    }

    public char getMappedCharacter(int index) {
        char ch = '\uffff';
        int limit = this.contents.length();
        WmiTextLayout layout = this;
        while (layout != null && index > limit) {
            layout = layout.getNext();
            index -= limit;
            limit = layout.contents.length();
        }
        if (layout != null) {
            ch = layout.getContents().charAt(index);
        }
        return ch;
    }

    public void drawAsString(Graphics g, int x, int y) {
        this.drawAsString(g, x, y, this.preKernAdjust);
    }

    public void drawAsString(Graphics g, int x, int y, int adjust) {
        this.drawThisAsString(g, x, y, adjust);
        WmiTextLayout layout = this.next;
        x += this.getSegmentWidth() + adjust;
        while (layout != null) {
            layout.drawThisAsString(g, x, y, 0);
            x += layout.getSegmentWidth();
            layout = layout.getNext();
        }
    }

    private void drawThisAsString(Graphics g, int x, int y, int adjust) {
        Font saveFont = g.getFont();
        g.setFont(this.getMappedFont(0));
        g.drawString(this.contents, x + adjust, y);
        g.setFont(saveFont);
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int getCaretPosition(int charIndex, boolean before) {
        return WmiTextLayout.getCaretPositionFromHead(this, charIndex, before);
    }

    private static int getCaretPositionFromHead(WmiTextLayout head, int charIndex, boolean before) {
        if (!before) {
            ++charIndex;
        }
        int index = 0;
        WmiTextLayout layout = head;
        boolean done = layout == null;
        while (!done) {
            index += layout.getPreKernAdjust();
            int limit = layout.contents.length();
            if (charIndex < 0) {
                done = true;
                continue;
            }
            if (charIndex <= limit) {
                done = true;
                if (layout.isTabLayout()) {
                    index += layout.getWidthOfTabCount(charIndex);
                    continue;
                }
                index += WmiTextLayout.getHorizontalOffset(charIndex, layout.getGlyphs());
                continue;
            }
            if (layout.getNext() != null) {
                index += layout.getSegmentWidth();
                charIndex -= limit;
                layout = layout.getNext();
                continue;
            }
            done = true;
            index += layout.getWidth();
        }
        return index;
    }

    public static int getHorizontalOffset(int charIndex, GlyphVector glyphs) {
        int offset = 0;
        offset = glyphs instanceof WmiSharedGlyphVector ? (int)((WmiSharedGlyphVector)glyphs).getHorizontalOffset(charIndex) : (int)glyphs.getGlyphPosition(charIndex).getX();
        return offset;
    }

    public int getHeight() {
        return this.height;
    }

    public int getIndex(Point hit) {
        return WmiTextLayout.getIndexFromHead(this, hit);
    }

    private static int getIndexFromHead(WmiTextLayout head, Point hit) {
        int index = 0;
        boolean done = false;
        WmiTextLayout layout = head;
        Point originalHit = (Point)hit.clone();
        while (!done) {
            int limit = layout.contents.length();
            int segmentWidth = layout.getSegmentWidth();
            int target = (int)hit.getX() - layout.getPreKernAdjust();
            if (target < segmentWidth) {
                done = true;
                int additionalOffset = limit;
                int leading = layout.isTabLayout() ? 0 : WmiTextLayout.getHorizontalOffset(0, layout.getGlyphs());
                int i = 0;
                while (i < limit) {
                    int trailing;
                    int n = trailing = layout.isTabLayout() ? layout.getWidthOfTabCount(i + 1) : WmiTextLayout.getHorizontalOffset(i + 1, layout.getGlyphs());
                    if (leading > target) {
                        additionalOffset = i;
                        break;
                    }
                    if (trailing > target && (leading + trailing) / 2 > target) {
                        additionalOffset = i;
                        break;
                    }
                    leading = trailing;
                    ++i;
                }
                index += additionalOffset;
                continue;
            }
            if (layout.getNext() != null) {
                hit.translate(-segmentWidth, 0);
                index += limit;
                layout = layout.getNext();
                continue;
            }
            done = true;
            index += limit;
        }
        hit.x = originalHit.x;
        hit.y = originalHit.y;
        return index;
    }

    public int getWidth() {
        int result = this.widthFromThisToEnd + this.preKernAdjust + this.postKernAdjust;
        return result;
    }

    public int getSegmentWidth() {
        int localWidth = this.isTabLayout() ? this.getWidthOfTabCount(this.contents.length()) : WmiTextLayout.getHorizontalOffset(this.contents.length(), this.glyphs);
        return localWidth;
    }

    public Font getFont() {
        return this.font;
    }

    public int getTextLength() {
        return this.contentsLengthFromThisToEnd;
    }

    private GlyphVector getGlyphs() {
        return this.glyphs;
    }

    private WmiTextLayout getNext() {
        return this.next;
    }

    private String getContents() {
        return this.contents;
    }

    private int getPreKernAdjust() {
        return this.preKernAdjust;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }
}

