/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font.tests;

import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class WmiFontMetricInspector {
    GlobalPropertiesPanel fontProperties;
    CharacterPropertiesPanel charProperties;
    FontMetricsPropertiesPanel jfontProperties;
    LineMetricsPropertiesPanel lmetricsProperties;
    GlyphVectorBoundsPropertiesPanel gboundsProperties;
    GlyphMetricsPropertiesPanel gmProperties;
    Bounds2DAndPixelPropertiesPanel pixProperties;
    Font activeFont;
    JComboBox cbfont;
    JComboBox cbsize;
    JTextField tfCharacter;
    JTextField tfsample;
    JScrollBar sbcharScroller;

    public static void main(String[] argc) {
        WmiFontMetricInspector instance = new WmiFontMetricInspector();
        instance.run();
    }

    public void run() {
        JFrame frame = this.buildInterface();
        frame.setVisible(true);
    }

    public JFrame buildInterface() {
        final JFrame frame = new JFrame("Inspect Font Metrics");
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        mainPanel.setLayout(new GridBagLayout());
        int gwidth = 4;
        String[] fontNames = WmiFontResolver.getAvailableFontFamilyNames();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        this.cbfont = new JComboBox<String>(fontNames);
        mainPanel.add((Component)this.cbfont, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 0.1;
        Integer[] sizes = new Integer[]{new Integer(4), new Integer(8), new Integer(12), new Integer(14), new Integer(18), new Integer(24), new Integer(32), new Integer(72)};
        gbc.fill = 2;
        this.cbsize = new JComboBox<Integer>(sizes);
        mainPanel.add((Component)this.cbsize, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weighty = 0.1;
        this.tfCharacter = new JTextField("M");
        mainPanel.add((Component)this.tfCharacter, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weighty = 0.1;
        gbc.fill = 1;
        this.sbcharScroller = new JScrollBar(0, 77, 1, 0, 65535);
        mainPanel.add((Component)this.sbcharScroller, gbc);
        this.sbcharScroller.addAdjustmentListener(new ChangeChar());
        this.cbfont.addActionListener(new ChangeFont());
        this.cbsize.addActionListener(new ChangeFont());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = gwidth;
        gbc.weighty = 0.7;
        this.tfsample = new JTextField("abcdefghijklmnopqrstuvwxyz");
        mainPanel.add((Component)this.tfsample, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = gwidth / 2;
        gbc.weighty = 0.2;
        this.fontProperties = new GlobalPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.fontProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = gwidth / 2;
        gbc.weighty = 0.2;
        this.jfontProperties = new FontMetricsPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.jfontProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = gwidth / 2;
        this.charProperties = new CharacterPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.charProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = gwidth / 2;
        gbc.weighty = 0.2;
        this.lmetricsProperties = new LineMetricsPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.lmetricsProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = gwidth / 2;
        gbc.weighty = 0.2;
        this.gboundsProperties = new GlyphVectorBoundsPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.gboundsProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = gwidth / 2;
        gbc.weighty = 0.2;
        this.gmProperties = new GlyphMetricsPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.gmProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = gwidth / 2;
        gbc.weighty = 0.2;
        this.pixProperties = new Bounds2DAndPixelPropertiesPanel();
        gbc.fill = 1;
        mainPanel.add((Component)this.pixProperties, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = gwidth;
        mainPanel.add((Component)new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(frame.getWidth(), 1);
            }
        }, gbc);
        frame.getContentPane().add((Component)mainPanel, "Center");
        frame.setSize(640, 480);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        return frame;
    }

    public void updateFont() {
        String fontName = (String)this.cbfont.getSelectedItem();
        int size = (Integer)this.cbsize.getSelectedItem();
        this.activeFont = WmiFontResolver.getFont(fontName, 0, size);
        this.tfsample.setFont(this.activeFont);
        this.tfCharacter.setFont(this.activeFont);
        WmiFontMetrics fm = WmiFontResolver.getFontMetrics(this.activeFont);
        this.fontProperties.update(fm);
        this.charProperties.update(fm);
        this.jfontProperties.update(this.activeFont);
        this.lmetricsProperties.update(this.activeFont);
        this.gboundsProperties.update(this.activeFont);
        this.gmProperties.update(this.activeFont);
        this.pixProperties.update(this.activeFont);
        this.tfsample.invalidate();
        this.tfsample.validate();
    }

    public class Bounds2DAndPixelPropertiesPanel
    extends JPanel {
        JTextField tfpixboundWidth;
        JTextField tfpixboundHeight;
        JTextField tfpixboundOrigin;
        JTextField tfboundWidth;
        JTextField tfboundHeight;
        JTextField tfboundOrigin;

        public Bounds2DAndPixelPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            JLabel lglobal = new JLabel("Pixel Bounds and Metric Bounds for character");
            this.add((Component)lglobal, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.add((Component)new JLabel("Pixel Bound Width"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.tfpixboundWidth = new JTextField(2);
            this.add((Component)this.tfpixboundWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            this.add((Component)new JLabel("Pixel Bound Height"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.tfpixboundHeight = new JTextField(2);
            this.add((Component)this.tfpixboundHeight, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            this.add((Component)new JLabel("Pixel Bound Origin"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            this.tfpixboundOrigin = new JTextField(6);
            this.add((Component)this.tfpixboundOrigin, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            this.add((Component)new JLabel("Bound Width"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.tfboundWidth = new JTextField(2);
            this.add((Component)this.tfboundWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            this.add((Component)new JLabel("Bound Height"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tfboundHeight = new JTextField(2);
            this.add((Component)this.tfboundHeight, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            this.add((Component)new JLabel("Bound Origin"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 6;
            this.tfboundOrigin = new JTextField(6);
            this.add((Component)this.tfboundOrigin, gbc);
        }

        public void update(Font thefont) {
            FontRenderContext context = ((Graphics2D)this.getGraphics()).getFontRenderContext();
            GlyphVector vec = WmiFontMetricInspector.this.activeFont.createGlyphVector(context, WmiFontMetricInspector.this.tfCharacter.getText());
            GlyphMetrics gm = vec.getGlyphMetrics(0);
            Rectangle2D rbound = gm.getBounds2D();
            Rectangle pbound = vec.getGlyphPixelBounds(0, context, 0.0f, 0.0f);
            this.tfpixboundWidth.setText("" + (int)((RectangularShape)pbound).getWidth());
            this.tfpixboundHeight.setText("" + (int)((RectangularShape)pbound).getHeight());
            this.tfpixboundOrigin.setText((int)((RectangularShape)pbound).getX() + ", " + (int)((RectangularShape)pbound).getY());
            this.tfboundWidth.setText("" + (int)rbound.getWidth());
            this.tfboundHeight.setText("" + (int)rbound.getHeight());
            this.tfboundOrigin.setText((int)rbound.getX() + ", " + (int)rbound.getY());
        }
    }

    public class ChangeChar
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            char val = (char)e.getValue();
            WmiFontMetricInspector.this.tfCharacter.setText("" + val);
            ((JScrollBar)e.getSource()).setToolTipText(this.getTip(val));
            WmiFontMetricInspector.this.updateFont();
        }

        public String getTip(char val) {
            String hex = Integer.toHexString(val);
            StringBuffer tip = new StringBuffer();
            if (val >= '\u0000' && val <= '\u007f') {
                tip.append("Basic Latin");
            } else if (val >= '\u0370' && val <= '\u03ff') {
                tip.append("Greek");
            } else if (val >= '\u2200' && val <= '\u22ff') {
                tip.append("Mathematical Operators");
            } else if (val >= '\u2300' && val <= '\u23ff') {
                tip.append("Miscellaneous Technical");
            } else if (val >= '\u2400' && val <= '\u243f') {
                tip.append("Control Pictures");
            } else {
                tip.append("No Tip");
            }
            tip.append("(");
            tip.append(hex);
            tip.append(")");
            return tip.toString();
        }
    }

    public class ChangeFont
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            WmiFontMetricInspector.this.updateFont();
        }
    }

    public class CharacterPropertiesPanel
    extends JPanel {
        JTextField tfcharacterWidth;
        JTextField tfpreKern;
        JTextField tfadvance;
        JTextField tfpostKern;
        JTextField tfcascent;
        JTextField tfcdescent;

        public CharacterPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            JLabel lcharacterProperties = new JLabel("Character Properties (WmiFontMetrics)");
            this.add((Component)lcharacterProperties, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            JLabel lcharacterWidth = new JLabel("Character Width");
            this.add((Component)lcharacterWidth, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.tfcharacterWidth = new JTextField(2);
            this.add((Component)this.tfcharacterWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            JLabel lpreKern = new JLabel("Character Prekern");
            this.add((Component)lpreKern, gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.tfpreKern = new JTextField(2);
            this.add((Component)this.tfpreKern, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            JLabel ladvance = new JLabel("Character Advance");
            this.add((Component)ladvance, gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            this.tfadvance = new JTextField(2);
            this.add((Component)this.tfadvance, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            JLabel lpostKern = new JLabel("Character Postkern");
            this.add((Component)lpostKern, gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.tfpostKern = new JTextField(2);
            this.add((Component)this.tfpostKern, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            JLabel lcascent = new JLabel("Character Ascent");
            this.add((Component)lcascent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tfcascent = new JTextField(2);
            this.add((Component)this.tfcascent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            JLabel lcdescent = new JLabel("Character Descent");
            this.add((Component)lcdescent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 6;
            this.tfcdescent = new JTextField(2);
            this.add((Component)this.tfcdescent, gbc);
        }

        public void update(WmiFontMetrics metrics) {
            char tchar = WmiFontMetricInspector.this.tfCharacter.getText().substring(0, 1).charAt(0);
            this.tfcharacterWidth.setText(Integer.toString(metrics.getCharacterProperty(0, tchar, WmiFontMetrics.getScreenContext())));
            this.tfpreKern.setText(Integer.toString(metrics.getCharacterProperty(1, tchar, WmiFontMetrics.getScreenContext())));
            this.tfadvance.setText(Integer.toString(metrics.getCharacterProperty(2, tchar, WmiFontMetrics.getScreenContext())));
            this.tfpostKern.setText(Integer.toString(metrics.getCharacterProperty(3, tchar, WmiFontMetrics.getScreenContext())));
            this.tfcascent.setText(Integer.toString(metrics.getCharacterProperty(4, tchar, WmiFontMetrics.getScreenContext())));
            this.tfcdescent.setText(Integer.toString(metrics.getCharacterProperty(5, tchar, WmiFontMetrics.getScreenContext())));
        }
    }

    public class FontMetricsPropertiesPanel
    extends JPanel {
        JTextField tflineLeader;
        JTextField tfmaxAdvance;
        JTextField tfmaxWidth;
        JTextField tfmaxAscent;
        JTextField tfmaxDescent;
        JTextField tffontHeight;
        JTextField tfbaseline;

        public FontMetricsPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            JLabel lglobal = new JLabel("Font Properties (java.awt.FontMetrics)");
            this.add((Component)lglobal, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            JLabel llineLeader = new JLabel("Line Leader(getLeading())");
            this.add((Component)llineLeader, gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.tflineLeader = new JTextField(2);
            this.add((Component)this.tflineLeader, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            JLabel lmaxAdvance = new JLabel("Max Advance");
            this.add((Component)lmaxAdvance, gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            this.tfmaxAdvance = new JTextField(2);
            this.add((Component)this.tfmaxAdvance, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            JLabel lmaxAscent = new JLabel("Maximum Ascent(getMaxAscent())");
            this.add((Component)lmaxAscent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.tfmaxAscent = new JTextField(2);
            this.add((Component)this.tfmaxAscent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            JLabel lmaxDescent = new JLabel("Maximum Descent(getMaxDescent())");
            this.add((Component)lmaxDescent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tfmaxDescent = new JTextField(2);
            this.add((Component)this.tfmaxDescent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            JLabel lfontHeight = new JLabel("Font Height(getHeight())");
            this.add((Component)lfontHeight, gbc);
            gbc.gridx = 1;
            gbc.gridy = 6;
            this.tffontHeight = new JTextField(2);
            this.add((Component)this.tffontHeight, gbc);
        }

        public void update(Font thefont) {
            FontMetrics metrics = this.getGraphics().getFontMetrics(thefont);
            this.tflineLeader.setText("" + metrics.getLeading());
            this.tfmaxAdvance.setText("" + metrics.getMaxAdvance());
            this.tfmaxAscent.setText("" + metrics.getMaxAscent());
            this.tfmaxDescent.setText("" + metrics.getMaxDescent());
            this.tffontHeight.setText("" + metrics.getHeight());
        }
    }

    public class GlobalPropertiesPanel
    extends JPanel {
        JTextField tflineLeader;
        JTextField tflowercaseHeight;
        JTextField tfmaxWidth;
        JTextField tfmaxAscent;
        JTextField tfmaxDescent;
        JTextField tffontHeight;
        JTextField tfbaseline;

        public GlobalPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            JLabel lglobal = new JLabel("Font Properties (WmiFontMetrics)");
            this.add((Component)lglobal, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            JLabel llineLeader = new JLabel("Line Leader");
            this.add((Component)llineLeader, gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.tflineLeader = new JTextField(2);
            this.add((Component)this.tflineLeader, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            JLabel llowercaseHeight = new JLabel("Lowercase Height");
            this.add((Component)llowercaseHeight, gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            this.tflowercaseHeight = new JTextField(2);
            this.add((Component)this.tflowercaseHeight, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            JLabel lmaxWidth = new JLabel("Maximum Width");
            this.add((Component)lmaxWidth, gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.tfmaxWidth = new JTextField(2);
            this.add((Component)this.tfmaxWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            JLabel lmaxAscent = new JLabel("Maximum Ascent");
            this.add((Component)lmaxAscent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tfmaxAscent = new JTextField(2);
            this.add((Component)this.tfmaxAscent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            JLabel lmaxDescent = new JLabel("Maximum Descent");
            this.add((Component)lmaxDescent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 6;
            this.tfmaxDescent = new JTextField(2);
            this.add((Component)this.tfmaxDescent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 7;
            JLabel lfontHeight = new JLabel("Font Height");
            this.add((Component)lfontHeight, gbc);
            gbc.gridx = 1;
            gbc.gridy = 7;
            this.tffontHeight = new JTextField(2);
            this.add((Component)this.tffontHeight, gbc);
        }

        public void update(WmiFontMetrics metrics) {
            this.tflineLeader.setText("" + metrics.getFontProperty(0));
            this.tflowercaseHeight.setText("" + metrics.getFontProperty(1));
            this.tfmaxWidth.setText("" + metrics.getFontProperty(2));
            this.tfmaxAscent.setText("" + metrics.getFontProperty(3));
            this.tfmaxDescent.setText("" + metrics.getFontProperty(4));
            this.tffontHeight.setText("" + metrics.getFontProperty(5));
        }
    }

    public class GlyphMetricsPropertiesPanel
    extends JPanel {
        JTextField tfadvanceX;
        JTextField tfadvanceY;
        JTextField tflsb;
        JTextField tfrsb;
        JTextField tfboundWidth;
        JTextField tfboundHeight;
        JTextField tfboundOrigin;

        public GlyphMetricsPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            JLabel lglobal = new JLabel("Values from GlyphMetric for character");
            this.add((Component)lglobal, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.3;
            this.add((Component)new JLabel("Advance X"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 0.7;
            this.tfadvanceX = new JTextField(2);
            this.add((Component)this.tfadvanceX, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 0.3;
            this.add((Component)new JLabel("Advance Y"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 0.7;
            this.tfadvanceY = new JTextField(2);
            this.add((Component)this.tfadvanceY, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.weightx = 0.3;
            this.add((Component)new JLabel("Left Side B"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.weightx = 0.7;
            this.tflsb = new JTextField(2);
            this.add((Component)this.tflsb, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.weightx = 0.7;
            this.add((Component)new JLabel("Right Side B"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.weightx = 0.7;
            this.tfrsb = new JTextField(2);
            this.add((Component)this.tfrsb, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            this.add((Component)new JLabel("Bound Width"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tfboundWidth = new JTextField(2);
            this.add((Component)this.tfboundWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            this.add((Component)new JLabel("Bound Height"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 6;
            this.tfboundHeight = new JTextField(2);
            this.add((Component)this.tfboundHeight, gbc);
            gbc.gridx = 0;
            gbc.gridy = 7;
            this.add((Component)new JLabel("Bound Origin"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 7;
            this.tfboundOrigin = new JTextField(6);
            this.add((Component)this.tfboundOrigin, gbc);
        }

        public void update(Font thefont) {
            GlyphVector vec = WmiFontMetricInspector.this.activeFont.createGlyphVector(((Graphics2D)this.getGraphics()).getFontRenderContext(), WmiFontMetricInspector.this.tfCharacter.getText());
            GlyphMetrics gm = vec.getGlyphMetrics(0);
            Rectangle2D rbound = gm.getBounds2D();
            this.tfadvanceX.setText("" + (int)gm.getAdvanceX());
            this.tfadvanceY.setText("" + (int)gm.getAdvanceY());
            this.tflsb.setText("" + (int)gm.getLSB());
            this.tfrsb.setText("" + (int)gm.getRSB());
            this.tfboundWidth.setText("" + (int)rbound.getWidth());
            this.tfboundHeight.setText("" + (int)rbound.getHeight());
            this.tfboundOrigin.setText((int)rbound.getX() + ", " + (int)rbound.getY());
        }
    }

    public class GlyphVectorBoundsPropertiesPanel
    extends JPanel {
        JTextField tflogicalWidth;
        JTextField tflogicalHeight;
        JTextField tfvisualWidth;
        JTextField tfvisualHeight;
        JTextField tflogicalOrigin;
        JTextField tfvisualOrigin;

        public GlyphVectorBoundsPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            JLabel lglobal = new JLabel("Properties from bounds of GlyphVector for char");
            this.add((Component)lglobal, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.3;
            this.add((Component)new JLabel("Logical Width"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 0.7;
            this.tflogicalWidth = new JTextField(2);
            this.add((Component)this.tflogicalWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 0.3;
            this.add((Component)new JLabel("Logical Height"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 0.7;
            this.tflogicalHeight = new JTextField(2);
            this.add((Component)this.tflogicalHeight, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.weightx = 0.3;
            this.add((Component)new JLabel("Logical Origin"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.weightx = 0.7;
            this.tflogicalOrigin = new JTextField(6);
            this.add((Component)this.tflogicalOrigin, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            this.add((Component)new JLabel("Visual Width"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.tfvisualWidth = new JTextField(2);
            this.add((Component)this.tfvisualWidth, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            this.add((Component)new JLabel("Visual Height"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tfvisualHeight = new JTextField(2);
            this.add((Component)this.tfvisualHeight, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            this.add((Component)new JLabel("Visual Origin"), gbc);
            gbc.gridx = 1;
            gbc.gridy = 6;
            this.tfvisualOrigin = new JTextField(6);
            this.add((Component)this.tfvisualOrigin, gbc);
        }

        public void update(Font thefont) {
            GlyphVector vec = WmiFontMetricInspector.this.activeFont.createGlyphVector(((Graphics2D)this.getGraphics()).getFontRenderContext(), WmiFontMetricInspector.this.tfCharacter.getText());
            Rectangle2D lbound = vec.getLogicalBounds();
            this.tflogicalWidth.setText("" + (int)lbound.getWidth());
            this.tflogicalHeight.setText("" + (int)lbound.getHeight());
            this.tflogicalOrigin.setText((int)lbound.getX() + ", " + (int)lbound.getY());
            Rectangle2D vbound = vec.getVisualBounds();
            this.tfvisualWidth.setText("" + (int)vbound.getWidth());
            this.tfvisualHeight.setText("" + (int)vbound.getHeight());
            this.tfvisualOrigin.setText((int)vbound.getX() + ", " + (int)vbound.getY());
        }
    }

    public class LineMetricsPropertiesPanel
    extends JPanel {
        JTextField tflineLeader;
        JTextField tfmaxWidth;
        JTextField tfascent;
        JTextField tfdescent;
        JTextField tffontHeight;
        JTextField tfbaseline;

        public LineMetricsPropertiesPanel() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            JLabel lglobal = new JLabel("Properties for char from java.awt.font.LineMetrics");
            this.add((Component)lglobal, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            JLabel llineLeader = new JLabel("Leader(getLeading())");
            this.add((Component)llineLeader, gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            this.tflineLeader = new JTextField(2);
            this.add((Component)this.tflineLeader, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            JLabel lAscent = new JLabel("Ascent");
            this.add((Component)lAscent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 3;
            this.tfascent = new JTextField(2);
            this.add((Component)this.tfascent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            JLabel lDescent = new JLabel("Descent");
            this.add((Component)lDescent, gbc);
            gbc.gridx = 1;
            gbc.gridy = 4;
            this.tfdescent = new JTextField(2);
            this.add((Component)this.tfdescent, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            JLabel lfontHeight = new JLabel("Height");
            this.add((Component)lfontHeight, gbc);
            gbc.gridx = 1;
            gbc.gridy = 5;
            this.tffontHeight = new JTextField(2);
            this.add((Component)this.tffontHeight, gbc);
        }

        public void update(Font thefont) {
            LineMetrics metrics = WmiFontMetricInspector.this.activeFont.getLineMetrics(WmiFontMetricInspector.this.tfCharacter.getText(), ((Graphics2D)this.getGraphics()).getFontRenderContext());
            this.tflineLeader.setText("" + (int)metrics.getLeading());
            this.tfascent.setText("" + (int)metrics.getAscent());
            this.tfdescent.setText("" + (int)metrics.getDescent());
            this.tffontHeight.setText("" + (int)metrics.getHeight());
        }
    }
}

