/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiFormatObserver;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.util.WmiNamedWriter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class WmiExportFormatter {
    public static final int FORMAT_SUCCESS = 0;
    public static final int FORMAT_FAILURE = -1;
    public static final int FORMAT_CANCEL = -2;
    private List observers;
    private Writer writer;
    private Stack writerStack;
    protected WmiModel rootModel;
    private AbstractStringEncoder encoder = null;
    private boolean clipboardAction = false;

    protected WmiExportFormatter() {
    }

    protected void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void beginFormat(Writer writer, WmiModel model) throws WmiFormatException, WmiNoReadAccessException {
        if (model == null) {
            throw new NullPointerException("model is null");
        }
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (!WmiModelLock.hasLock(model, 0) && !WmiModelLock.hasLock(model, 1)) {
            throw new WmiNoReadAccessException(model);
        }
        this.writer = writer;
        this.rootModel = model;
    }

    protected void endFormat(boolean writerShared) throws IOException {
        assert (this.writerStack == null || this.writerStack.isEmpty()) : "writers remaining on writer stack";
        try {
            this.flushBuffer();
            if (!writerShared) {
                this.writer.close();
            }
        }
        finally {
            this.writer = null;
            this.rootModel = null;
            this.encoder = null;
        }
    }

    protected final WmiModel getRootModel() {
        return this.rootModel;
    }

    protected String getFilename() {
        String filename = null;
        if (this.writer instanceof WmiNamedWriter) {
            filename = ((WmiNamedWriter)((Object)this.writer)).getFilename();
        }
        return filename;
    }

    protected final AbstractStringEncoder getEncoder() {
        return this.encoder;
    }

    public final void setEncoder(AbstractStringEncoder encoder) {
        if (this.canSetEncoder()) {
            this.encoder = encoder;
        }
    }

    protected AbstractStringEncoder createDefaultEncoder() {
        return RuntimeLocale.getExportEncoder();
    }

    public abstract boolean canSetEncoder();

    public boolean setOptions() {
        return true;
    }

    public final WmiMathDocumentModel getDocument() {
        return this.rootModel.getDocument();
    }

    protected final void throwFormatException(Exception e) throws WmiFormatException {
        e.printStackTrace();
        throw new WmiFormatException(e.toString(), this.writer);
    }

    public final void pushWriter(Writer writer) {
        if (this.writerStack == null) {
            this.writerStack = new Stack();
        }
        this.writerStack.push(this.writer);
        this.writer = writer;
    }

    public final void popWriter() throws IOException {
        if (this.writerStack == null || this.writerStack.isEmpty()) {
            throw new IllegalStateException("writer stack is empty -- can't pop");
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = (Writer)this.writerStack.pop();
    }

    public final int format(Writer writer, WmiModel model) throws WmiFormatException, WmiNoReadAccessException {
        return this.format(writer, model, false);
    }

    private int format(Writer writer, WmiModel model, boolean writerShared) throws WmiFormatException, WmiNoReadAccessException {
        this.beginFormat(writer, model);
        if (this.encoder == null) {
            this.encoder = this.createDefaultEncoder();
        }
        int result = -1;
        try {
            try {
                result = this.format();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.endFormat(writerShared);
                }
                catch (IOException e2) {
                    this.throwFormatException(e2);
                }
            }
        }
        finally {
            try {
                this.endFormat(writerShared);
            }
            catch (IOException e) {
                this.throwFormatException(e);
            }
        }
        return result;
    }

    protected static int formatUsingExistingWriter(WmiExportFormatter sourceForWriter, WmiExportFormatter formatter, WmiModel model) throws WmiFormatException, WmiNoReadAccessException {
        if (formatter.canSetEncoder()) {
            formatter.setEncoder(sourceForWriter.getEncoder());
        }
        return formatter.format(sourceForWriter.writer, model, true);
    }

    protected abstract int format() throws WmiFormatException, WmiNoReadAccessException;

    protected abstract boolean ignoreHiddenModels();

    public void openCompositeModel(WmiModelTag tag) throws IOException {
    }

    public void closeCompositeModel(WmiModelTag tag) throws IOException {
    }

    public abstract void writeMathModel(WmiMathModel var1) throws WmiNoReadAccessException, IOException;

    public abstract void writeTextModel(WmiTextModel var1) throws WmiNoReadAccessException, IOException;

    public abstract void writeAttribute(Object var1, Object var2) throws IOException;

    public final void writeText(String unicodeText) throws IOException {
        String encoded = this.transformForTextOutput(unicodeText);
        this.writeBinary(encoded);
    }

    public final void writeBinary(String binaryData) throws IOException {
        this.writer.write(binaryData);
    }

    protected String transformForTextOutput(String unicodeText) {
        return this.encode(unicodeText);
    }

    protected String encode(String unicodeString) {
        String encodedString = unicodeString;
        if (this.encoder != null && this.shouldEncode(unicodeString)) {
            encodedString = this.encoder.fromUnicode(unicodeString);
        }
        return encodedString;
    }

    protected boolean shouldEncode(String unicodeString) {
        int i = 0;
        while (i < unicodeString.length()) {
            char ch = unicodeString.charAt(i);
            if ('\u007f' < ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean registerObserver(WmiFormatObserver newObserver) {
        if (newObserver != null) {
            if (this.observers == null) {
                this.observers = new ArrayList();
            }
            this.observers.add(newObserver);
        }
        return true;
    }

    public void reportModelError(WmiModel model, Object details) {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiFormatObserver obsv = (WmiFormatObserver)this.observers.get(b);
                obsv.modelError(model, details);
                ++b;
            }
        }
    }

    protected void reportFormatBegin() {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiFormatObserver obsv = (WmiFormatObserver)this.observers.get(b);
                obsv.formatBegin(this.getDocument());
                ++b;
            }
        }
    }

    protected void reportFormatEnd() {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiFormatObserver obsv = (WmiFormatObserver)this.observers.get(b);
                obsv.formatEnd(this.getDocument());
                ++b;
            }
        }
    }

    protected void reportUnrecognizedTag(WmiModel model) {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiFormatObserver obsv = (WmiFormatObserver)this.observers.get(b);
                obsv.unrecognizedModelTag(model);
                ++b;
            }
        }
    }

    protected WmiView modelToView(WmiModel model, WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiView view = null;
        WmiViewFactory factory = docView.getViewFactory();
        if (factory != null) {
            view = model instanceof WmiCompositeModel ? factory.createView(model, docView) : this.createTemporaryLeafView(model, docView, factory);
        }
        if (view instanceof WmiPositionedView) {
            ((WmiPositionedView)view).layoutView();
        }
        return view;
    }

    private WmiView createTemporaryLeafView(WmiModel model, WmiMathDocumentView docView, WmiViewFactory factory) throws WmiNoReadAccessException {
        WmiParagraphModel paragraph = null;
        WmiCompositeModel testModel = WmiModelUtil.findAncestorOfClass(model, WmiParagraphModel.class);
        paragraph = testModel instanceof WmiParagraphModel ? (WmiParagraphModel)testModel : new WmiParagraphModel(this.getDocument());
        WmiParagraphView paraView = new WmiParagraphView(paragraph, docView);
        WmiView newView = factory.createView(model, paraView);
        paraView.appendView(newView);
        return newView;
    }

    public boolean isClipboardAction() {
        return this.clipboardAction;
    }

    public void setClipboardAction(boolean clipboardAction) {
        this.clipboardAction = clipboardAction;
    }
}

