/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import java.io.IOException;
import java.util.HashMap;

public abstract class WmiHashedExportFormatter
extends WmiExportFormatter {
    private HashMap actionTable = new HashMap();

    protected WmiHashedExportFormatter() {
        this.hashActions();
    }

    protected abstract void hashActions();

    protected void addAction(WmiModelTag tag, WmiExportAction action) {
        this.actionTable.put(tag, action);
    }

    protected WmiExportAction getFormatAction(WmiModelTag tag) {
        return (WmiExportAction)this.actionTable.get(tag);
    }

    protected boolean isModelVisible(WmiModel model) throws WmiNoReadAccessException {
        return model.isVisible();
    }

    protected void postFormat() throws IOException {
    }

    protected void preFormat() throws IOException {
    }

    public void processModel(WmiModel model) throws WmiNoReadAccessException, IOException {
        WmiModelTag tag;
        if (this.ignoreHiddenModels() && !this.isModelVisible(model)) {
            return;
        }
        WmiModelTag wmiModelTag = tag = model != null ? model.getTag() : null;
        if (tag != null) {
            boolean processChildren = false;
            WmiExportAction action = this.getFormatAction(tag);
            if (action != null) {
                processChildren = action.processChildModels();
                action.openModel(this, model);
            } else {
                this.reportUnrecognizedTag(model);
            }
            if (processChildren && model instanceof WmiCompositeModel) {
                WmiCompositeModel parent = (WmiCompositeModel)model;
                int c = 0;
                while (c < parent.getChildCount()) {
                    this.processModel(parent.getChild(c));
                    ++c;
                }
            }
            if (action != null) {
                action.closeModel(this, model);
            }
        } else {
            this.reportModelError(model, "Could not identify model tag.");
        }
    }

    @Override
    protected int format() throws WmiFormatException, WmiNoReadAccessException {
        WmiModel model = this.getRootModel();
        int result = 0;
        this.reportFormatBegin();
        try {
            this.preFormat();
            this.processModel(model);
            this.postFormat();
        }
        catch (IOException ioe) {
            WmiErrorLog.log(ioe);
            result = -1;
        }
        this.reportFormatEnd();
        return result;
    }

    @Override
    public void writeAttribute(Object name, Object value) throws IOException {
        this.writeText(name.toString());
        this.writeBinary("=");
        this.writeText(value.toString());
    }

    @Override
    public void writeTextModel(WmiTextModel text) throws WmiNoReadAccessException, IOException {
        this.writeText(text.getText());
    }
}

