/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.WmiImportActionProxy;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.WmiParseObserver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public abstract class WmiHashedImportParser
implements WmiImportParser {
    private HashMap actionTable = new HashMap();
    private Stack charAttributeStack = new Stack();
    private WmiModel activeModel = null;
    private int rootLevelOffset = 0;
    private ArrayList observers = new ArrayList();
    private Stack textEncodingStack = new Stack();
    protected WmiFontAttributeSet charAttr = new WmiFontAttributeSet();
    protected WmiCompositeModel rootModel = null;

    protected WmiHashedImportParser() {
        this.hashActions();
    }

    protected abstract void hashActions();

    protected void cancelActiveModel() throws WmiNoReadAccessException {
        if (this.activeModel != null) {
            this.activeModel = this.activeModel.getParent();
        }
    }

    protected void commitChild(WmiModel child) throws WmiNoWriteAccessException {
        if (child != null && this.activeModel instanceof WmiCompositeModel) {
            WmiCompositeModel currentParent = (WmiCompositeModel)this.activeModel;
            if (currentParent == this.rootModel) {
                try {
                    currentParent.addChild(child, this.rootLevelOffset++);
                }
                catch (WmiModelIndexOutOfBoundsException boundsE) {
                    this.reportObjectError(currentParent.getTag().toString(), null, currentParent, boundsE);
                }
            } else {
                currentParent.appendChild(child);
            }
        }
    }

    public WmiModel getActiveModel() {
        return this.activeModel;
    }

    public void setActiveModel(WmiModel active) {
        this.activeModel = active;
    }

    protected String getTextEncoding() {
        String encoding = null;
        if (!this.textEncodingStack.empty()) {
            encoding = (String)this.textEncodingStack.peek();
        }
        return encoding;
    }

    protected boolean hasAncestor(WmiModelTag tag) throws WmiNoReadAccessException {
        boolean ancestorExists = false;
        if (this.activeModel != null) {
            ancestorExists = this.activeModel.getTag() == tag ? true : WmiModelUtil.findAncestorOfTag(this.activeModel, tag) != null;
        }
        return ancestorExists;
    }

    protected boolean hasAncestor(WmiModelTag[] tags) throws WmiNoReadAccessException {
        boolean ancestorExists = false;
        if (this.activeModel != null) {
            int t = 0;
            while (!ancestorExists && t < tags.length) {
                WmiModelTag tag = tags[t];
                if (this.activeModel.getTag() == tag) {
                    ancestorExists = true;
                }
                ++t;
            }
            if (!ancestorExists) {
                ancestorExists = WmiModelUtil.findAncestorOfTag(this.activeModel, tags) != null;
            }
        }
        return ancestorExists;
    }

    protected void parserInitialization(WmiCompositeModel parentModel, int parentInsertOffset) {
        this.rootModel = parentModel;
        this.rootLevelOffset = parentInsertOffset;
        this.charAttributeStack.clear();
        this.textEncodingStack.clear();
    }

    protected void reportParseBegin() {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiParseObserver obsv = (WmiParseObserver)this.observers.get(b);
                obsv.parseBegin(this.getDocument());
                ++b;
            }
        }
    }

    protected void reportParseEnd() {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiParseObserver obsv = (WmiParseObserver)this.observers.get(b);
                obsv.parseEnd(this.getDocument());
                ++b;
            }
        }
    }

    protected void reportUnrecognizedObject(String specTag, Object specs) {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiParseObserver obsv = (WmiParseObserver)this.observers.get(b);
                obsv.unrecognizedInputObject(specTag, specs);
                ++b;
            }
        }
    }

    protected void reportUnsupportedObject(String specTag, Object specs) {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiParseObserver obsv = (WmiParseObserver)this.observers.get(b);
                obsv.unsupportedInputObject(specTag, specs);
                ++b;
            }
        }
    }

    public void addAction(WmiModelTag specTag, WmiImportActionProxy action) {
        this.addAction(specTag.toString(), action);
    }

    public void addAction(String specTag, WmiImportActionProxy action) {
        this.actionTable.put(specTag, action);
    }

    public void addAction(WmiModelTag tag, String pname, String action) {
        this.addAction(tag, new WmiImportActionProxy(pname, action));
    }

    public void addAction(String tag, String pname, String action) {
        this.addAction(tag, new WmiImportActionProxy(pname, action));
    }

    public void closeRootModel() {
        this.charAttributeStack.clear();
        this.textEncodingStack.clear();
        this.activeModel = null;
        this.reportParseEnd();
    }

    public WmiImportAction getParseAction(String specTag) {
        WmiImportAction action = (WmiImportAction)this.actionTable.get(specTag);
        if (action == null) {
            action = (WmiImportAction)this.actionTable.get(specTag.toLowerCase());
        }
        if (action == null) {
            action = (WmiImportAction)this.actionTable.get(specTag.toUpperCase());
        }
        return action;
    }

    public void openRootModel() {
        this.reportParseBegin();
        this.activeModel = this.rootModel;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void closeModel(WmiModel newModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        block3: {
            if (newModel != null) ** GOTO lbl5
            newModel = this.activeModel;
            break block3;
lbl-1000:
            // 1 sources

            {
                this.activeModel = this.activeModel.getParent();
lbl5:
                // 2 sources

                ** while (this.activeModel != null && newModel != this.activeModel)
            }
lbl6:
            // 1 sources

            if (this.activeModel == null) {
                this.reportObjectError(null, null, newModel, "Tried to close model that did not exist in hierarchy.");
                return;
            }
        }
        if (newModel != null) {
            this.activeModel = this.activeModel.getParent();
            this.commitChild(newModel);
        }
    }

    @Override
    public String decode(String in) {
        return in;
    }

    @Override
    public void defineTextContent(String contents) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (contents != null) {
            if (contents.length() == 0) {
                WmiTextModel model = new WmiTextModel(this.getDocument(), contents, (WmiFontAttributeSet)this.getActiveCharAttributes().copyAttributes());
                this.commitChild(model);
                return;
            }
            int start = 0;
            while (start < contents.length()) {
                int pos = contents.indexOf(10, start);
                if (pos < 0) {
                    pos = contents.length() - 1;
                }
                String subContents = contents.substring(start, pos + 1);
                WmiTextModel model = new WmiTextModel(this.getDocument(), subContents, (WmiFontAttributeSet)this.getActiveCharAttributes().copyAttributes());
                this.commitChild(model);
                start = pos + 1;
            }
        }
    }

    @Override
    public void flush() {
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            try {
                doc.update(null);
            }
            catch (WmiNoUpdateAccessException updateE) {
                this.reportObjectError(doc.getTag().toString(), null, doc, updateE);
            }
        }
    }

    @Override
    public WmiFontAttributeSet getActiveCharAttributes() {
        return this.charAttr;
    }

    @Override
    public WmiMathDocumentModel getDocument() {
        return this.rootModel != null ? this.rootModel.getDocument() : null;
    }

    @Override
    public void openModel(WmiModel newModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (newModel != null) {
            if (this.activeModel instanceof WmiCompositeModel) {
                newModel.setParent((WmiCompositeModel)this.activeModel);
                this.activeModel = newModel;
            } else {
                this.reportObjectError(newModel.toString(), null, this.activeModel, "Active model is not a valid parent.");
            }
        }
    }

    @Override
    public boolean parse(InputStream input, WmiCompositeModel parent, int offset) throws WmiParseException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        InputStreamReader reader = new InputStreamReader(input);
        return this.parse(reader, parent, offset);
    }

    @Override
    public void popCharacterAttributes() {
        if (!this.charAttributeStack.empty()) {
            this.charAttr = (WmiFontAttributeSet)this.charAttributeStack.peek();
            this.charAttributeStack.pop();
        }
    }

    @Override
    public void popTextEncoding() {
        if (!this.textEncodingStack.empty()) {
            this.textEncodingStack.pop();
        }
    }

    @Override
    public WmiFontAttributeSet pushCharacterAttributes() {
        this.charAttributeStack.push(this.charAttr.copyAttributes());
        return this.getActiveCharAttributes();
    }

    @Override
    public void pushTextEncoding(String name) {
        this.textEncodingStack.push(name != null ? name : this.getTextEncoding());
    }

    @Override
    public boolean registerObserver(WmiParseObserver newObserver) {
        if (newObserver != null) {
            this.observers.add(newObserver);
        }
        return true;
    }

    @Override
    public void reportObjectError(String specTag, Object specs, WmiModel model, Object details) {
        if (this.observers != null) {
            int b = 0;
            while (b < this.observers.size()) {
                WmiParseObserver obsv = (WmiParseObserver)this.observers.get(b);
                obsv.objectError(specTag, specs, model, details);
                ++b;
            }
        }
    }

    @Override
    public void reportObjectWarning(int type, String specTag, Object specs, WmiModel model, Object details) {
        switch (type) {
            case -1: {
                this.reportObjectError(specTag, specs, model, details);
                break;
            }
            case -2: {
                this.reportUnrecognizedObject(specTag, specs);
                break;
            }
            case -3: {
                this.reportUnsupportedObject(specTag, specs);
            }
        }
    }

    @Override
    public void setActiveCharAttributes(WmiAttributeSet newAttr) {
        this.charAttr.addAttributes(newAttr);
    }

    @Override
    public boolean confirmLicense(File inputFile) {
        return true;
    }
}

