/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.util.WmiStartup;

public class WmiImportActionProxy
implements WmiImportAction {
    protected String fullyQualifiedClassname;
    protected WmiImportAction action;
    protected static boolean checkAll = true;
    protected static boolean checkChosen;

    protected WmiImportActionProxy() {
    }

    public WmiImportActionProxy(String pname, String classname) {
        this.fullyQualifiedClassname = String.valueOf(pname) + "." + classname;
        if (checkAll) {
            if (!checkAll) {
                int v = (int)(System.currentTimeMillis() % 50L);
                boolean bl = checkAll = v == 1;
            }
            if (checkAll) {
                if (!checkChosen) {
                    WmiStartup.progress("* * * NOTE * * * extra check in  WmiImportActionProxy; do not use this timing");
                }
                this.loadAction();
            }
            checkChosen = true;
        }
    }

    protected void loadAction() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.fullyQualifiedClassname);
        }
        catch (ClassNotFoundException e) {
            WmiErrorLog.log(e);
        }
        catch (IllegalArgumentException e) {
            WmiErrorLog.log(e);
        }
        try {
            this.action = (WmiImportAction)clazz.newInstance();
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    private final WmiImportAction getAction() {
        if (this.action == null) {
            this.loadAction();
        }
        assert (this.action != null) : "got a null pointer trying to create " + this.fullyQualifiedClassname;
        return this.action;
    }

    @Override
    public void beginAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.getAction().beginAction(parser, inputSource);
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.getAction().endAction(parser, inputSource);
    }

    public String getFullyQualifiedClassname() {
        return this.fullyQualifiedClassname;
    }
}

