/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.util.WmiSearchVisitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class WmiMetadataTableExporter {
    public void writeMetadata(WmiMetadataManager mgr, WmiExportFormatter formatter) throws IOException, WmiNoReadAccessException {
        Set tagIdSet;
        this.beginMetadataTable(formatter);
        Set categorySet = mgr.getCategoryList();
        if (categorySet != null) {
            for (Object catId : categorySet) {
                WmiMetatagCategory cat;
                if (!(catId instanceof String) || (cat = mgr.findCategory((String)catId)) == null) continue;
                this.writeCategoryTag(cat, formatter);
            }
        }
        if ((tagIdSet = mgr.getMetatagIdList()) != null && !formatter.isClipboardAction()) {
            HashSet<String> usedTags = new HashSet<String>();
            WmiModelUtil.visitModels(mgr.getModel(), this.getVisitor(usedTags));
            Iterator ti = tagIdSet.iterator();
            usedTags.add("0");
            while (ti.hasNext()) {
                WmiMetatag tag;
                Object tagId = ti.next();
                if (!(tagId instanceof String) || (tag = mgr.findMetatag((String)tagId)) == null || tag.getName() == null || !usedTags.contains(tagId)) continue;
                this.writeMetatag(tag, formatter);
            }
        }
        this.endMetadataTable(formatter);
    }

    protected WmiMetaDataWrapperVisitor getVisitor(Set tags) {
        return new WmiMetaDataWrapperVisitor(tags);
    }

    protected abstract void beginMetadataTable(WmiExportFormatter var1) throws IOException;

    protected abstract void endMetadataTable(WmiExportFormatter var1) throws IOException;

    protected abstract void writeCategoryTag(WmiMetatagCategory var1, WmiExportFormatter var2) throws IOException;

    protected abstract void writeMetatag(WmiMetatag var1, WmiExportFormatter var2) throws IOException;

    protected static class WmiMetaDataWrapperVisitor
    implements WmiSearchVisitor {
        protected Set usedTags;

        public WmiMetaDataWrapperVisitor(Set tags) {
            this.usedTags = tags;
        }

        @Override
        public int visitMatch(Object match) {
            if (match instanceof WmiMetatagWrapperModel) {
                try {
                    this.usedTags.add(((WmiMetatagWrapperModel)match).getMetatagId());
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
            return 0;
        }
    }
}

